<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>
<#assign debugMode = false>


<button class="btn btn-default availability-button"
        ng-class="$ctrl.cssClasses"
        ng-if="$ctrl.availability && $ctrl.availability.reasonable && (!$ctrl.forExemplar || $ctrl.availability.capabilities.length > 0)"
        ng-click="$ctrl.request()">

    <#if debugMode>
        {{$ctrl.availability.capabilities | prop:'name' | inline}}
    </#if>

    <#-- TODO: Zvazit, zda na tohle neudelat direktivu. Neco na zpusob ng-messages -->

    <span ng-if="$ctrl.choose.when($ctrl.isCapableOfOneOf('mvsRequestability'))">
        ${loc.loc("loan.VyzadatPresMvs")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.availability.capabilities.length > 1 && $ctrl.isCapableOfOneOf('downloadability'))">
        ${loc.loc("loan.MoznostiVypujceniNeboStazeni")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.availability.capabilities.length > 1 && $ctrl.isCapableOfOneOf('ereadingLoanability', 'flexibooksLoanability', 'levnaknihovnaLoanability'))">
        ${loc.loc("loan.MoznostiVypujceniNeboEBook")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.availability.capabilities.length > 1)">
        ${loc.loc("loan.MoznostiVypujceni")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('mailRequestability'))">
        ${loc.loc("loan.Objednat")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('pickupability'))" data-qa="exemplar-available-button">
        ${loc.loc("loan.request.Vypujcit")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('standardOrderability'))" data-qa="exemplar-order-button">
        ${loc.loc("loan.Objednat")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('standardReservability'))" data-qa="exemplar-reservation-button">
        ${loc.loc("commons.rezervovat")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('visitPickupability', 'standardVisitOrderability', 'standardVisitReservability') && $ctrl.isCapableOfOneOf('ereadingLoanability', 'flexibooksLoanability', 'levnaknihovnaLoanability'))">
        ${loc.loc("loan.PrezencneNeboEBook")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('visitPickupability'))" data-qa="exemplar-free-for-visit-button">
        ${loc.loc("loan.PickupForVisit")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('standardVisitOrderability'))">
        ${loc.loc("loan.OrderForVisit")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('standardVisitReservability'))">
        ${loc.loc("loan.ReserveForVisit")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('ereadingLoanability'))">
        ${loc.loc("loan.VypujcitEBook")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('flexibooksLoanability'))">
        ${loc.loc("loan.VypujcitEBook")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('levnaknihovnaLoanability'))">
        ${loc.loc("loan.VypujcitEBook")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('downloadability'))">
        ${loc.loc("commons.ZobrazitPlnyText")?noEsc}
    </span>
    <span ng-if="$ctrl.choose.elsewhen($ctrl.isCapableOfOneOf('slotVisitOrderability'))">
        ${loc.loc('loan.OrderOnTime')}
    </span>
    <span ng-if="$ctrl.choose.otherwise()" data-qa="exemplar-not-available-button">
        ${loc.loc("loan.CannotRequestLoanForMyself")?noEsc}
    </span>

</button>
