import type {Preview} from '@storybook/svelte';
import 'bootstrap-less/bootstrap/bootstrap.less'; // import and load bootstrap styles
import '../styles/default.less'; // import and load portaro stylesheet
import * as jQuery from 'jquery';

// @ts-ignore manually add jquery to window object for storybook
window.$ = window.jQuery = jQuery;

// import and load bootstraps JS only after the jQuery is added to the window object !!!
import('bootstrap-less/js/bootstrap');

const preview: Preview = {
  parameters: {
    actions: { argTypesRegex: "^on[A-Z].*" },
    controls: {
      matchers: {
        color: /(background|color)$/i,
        date: /Date$/,
      },
    },
  }
};

export default preview;