<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <#attempt>
        <script type="text/javascript">
            window.model.editationObject = ${objectMapper.writeValueAsString(editationObject)?noEsc};
        </script>
    <#recover>
        ${.error}
    </#attempt>

    <style type="text/css">
        /* <![CDATA[ */
        .record-editation-sticky-header.is-sticky {
            background: white;
            border-bottom: 1px solid #D3D3D3;
            box-shadow: 2px 1px 6px -6px #D3D3D3; /* 4th value is not to show shadow at top border */
            padding-bottom: 10px;
        }
        /* ]]> */
    </style>


    <div ng-controller="PagedRecordEditationController as $ctrl" ng-init="$ctrl.init()" ng-cloak class="record-editation paged-record-editation normalniContentSMezerouNahore" id="record-editation-page-content">

        <div hl-sticky="" class="record-editation-sticky-header" container="record-editation-page-content" collection="record-editation-sticky-header" collection-parent="kp-main-menu">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <h1>
                            <span ng-show="$ctrl.editationService.text()" data-qa="record-editation-record-name">{{$ctrl.editationService.text()}}</span>
                            <span ng-show="!$ctrl.editationService.text()">${loc.loc("editace.Untitled")?noEsc}</span>
                            <span ng-show="$ctrl.editationService.isDraft()" class="text-muted">(${loc.loc("editace.draft")?noEsc})</span>
                        </h1>
                    </div>
                </div>

                <div class="row">
                    <div class="col-xs-7">
                        <button class="btn btn-primary" ng-show="$ctrl.editationService.isDraft()" ng-click="$ctrl.publishDraftAndClose()" data-qa="record-editation-publish-and-close">
                            ${loc.loc("editace.PublishAndClose")?noEsc}
                        </button>

                        <button class="btn btn-primary" ng-show="!$ctrl.editationService.isDraft()" ng-click="$ctrl.saveAndClose()" data-qa="record-editation-save-and-close">
                            ${loc.loc("editace.SaveAndClose")?noEsc}
                        </button>

                        <button class="btn btn-default" ng-show="$ctrl.editationService.isDraft()" ng-click="$ctrl.deleteDraftAndClose()" data-qa="record-editation-discard-concept">
                            ${loc.loc("editace.DiscardConcept")?noEsc}
                        </button>

                        <button class="btn btn-default" ng-show="!$ctrl.editationService.isDraft()" ng-click="$ctrl.discardAndClose()" data-qa="record-editation-close">
                            ${loc.loc("commons.zavrit")?noEsc}
                        </button>

                        <button class="btn btn-default" ng-show="!$ctrl.editationService.isRevisionSaved()" ng-click="$ctrl.saveAndContinue()" data-qa="record-editation-save-and-continue">
                            ${loc.loc("editace.SaveChangesAndContinue")?noEsc}
                        </button>

                        <span style="margin-left: 10px;">
                            <span class="text-muted" ng-show="$ctrl.editationService.state() !== 'PROCESSING' && $ctrl.editationService.isRevisionSaved()">
                                <span class="glyphicon glyphicon-ok"></span>
                                <span>${loc.loc("editace.AllChangesSaved")?noEsc}</span>
                            </span>
                            <span jp-loading="xs" ng-show="$ctrl.editationService.state() === 'PROCESSING'"></span>
                        </span>
                    </div>

                    <div class="col-xs-5">
                        <form class="form-inline pull-right" ng-if="$ctrl.editationService.fondSelectionEditor()" ng-submit="$ctrl.editationService.setFond($ctrl.editationService.editation().fond.id)" name="fondSelectForm">
                            <div class="form-group">
                                <label for="record-editation-fond-select">${loc.loc("editace.vyberFond")?noEsc}:</label>
                                <kp-svelte-component-wrapper component="::$ctrl.kpValueEditorForceSettingsWrapper"
                                                             props="{
                                                                forceSettings: [
                                                                    {type: 'acceptable', options: {switchToInlineModeThreshold: 1}},
                                                                    {type: 'single-acceptable', options: {switchToInlineModeThreshold: 1}},
                                                                    {type: 'multiple-acceptable', options: {switchToInlineModeThreshold: 1}}],
                                                                type: $ctrl.editationService.fondSelectionEditor().type,
                                                                editorId: 'record-editation-fond-select',
                                                                options: $ctrl.editationService.fondSelectionEditor().options,
                                                                validations: $ctrl.editationService.fondSelectionEditor().validations,
                                                                model: $ctrl.editationService.editation().fond,
                                                                size: 'sm'}"
                                                             ng-on-model-change="$ctrl.editationService.setFond($event.originalEvent.detail)">
                                </kp-svelte-component-wrapper>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <kp-record-editation editation="$ctrl.editationService"
                                 show-indicators="$ctrl.editationService.showIndicators()"
                                 show-field-identifiers="$ctrl.editationService.showFieldIdentifiers()">
            </kp-record-editation>
        </div>

    </div>
</@layouts.full>
