<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div ng-cloak class="jp-pagination">

    <div>
        <button type="button" ng-show="pagination.hasPrevious()" ng-disabled="pagination.state.previousPage === 'PROCESSING'" ng-click="pagination.requestPreviousPage()" class="btn btn-default btn-block btn-sm">
            <span ng-hide="pagination.state.previousPage === 'PROCESSING'">${springMacroRequestContext.getMessage("vysledky.NacistPredchozichX", ["{{pagination.getPageSize()}}"])?noEsc}</span>
            <span jp-loading="xs" ng-show="pagination.state.previousPage === 'PROCESSING'"></span>
        </button>
    </div>

    <div aria-live="polite">
        <div role="status" jp-loading="{{loadingSize}}" ng-if="pagination.state.distantPage === 'PROCESSING'"></div>

        <p role="status" ng-if="pagination.getError()" class="text-muted text-center">{{pagination.getError()}}</p>

        <p role="status" ng-if="!pagination.getError() && pagination.state.page === 'NORMAL' && pagination.items.length === 0" class="text-muted text-center">${loc.loc("commons.ZadnePolozky")?noEsc}</p>

        <div ng-if="pagination.state.distantPage === 'NORMAL'" ng-transclude></div>
    </div>

    <div>
        <button type="button" ng-show="pagination.hasNext()" ng-disabled="pagination.state.nextPage === 'PROCESSING'" ng-click="pagination.requestNextPage()" class="btn btn-default btn-block btn-sm">
            <span ng-hide="pagination.state.nextPage === 'PROCESSING'">
                <span ng-if="pagination.getPageSize()">${springMacroRequestContext.getMessage("vysledky.NacistDalsichX", ["{{pagination.getPageSize()}}"])?noEsc}</span>
                <span ng-if="!pagination.getPageSize()">${loc.loc("vysledky.NacistDalsi")?noEsc}</span>
            </span>
            <span jp-loading="xs" ng-show="pagination.state.nextPage === 'PROCESSING'"></span>
        </button>
    </div>

    <nav ng-show="showPageButtons && pagination.showedPageNumbers.length > 0" class="page-select" style="margin-bottom: 20px;" aria-label="${loc.loc('vysledky.Pagination')?noEsc}">
        <div>
            <span ng-show="pagination.showedPageNumbers[0] > 1">
                <a ng-href="" ng-click="pagination.requestPage(1)" class="btn-page" ng-class="{'active': isPageShowed(1)}" aria-label="{{'${loc.loc("vysledky.GotToPageX")?noEsc}' | strParams : 1}}">1</a>
                <span>&#8230;</span> <#-- ellipsis -->
            </span>
            <span ng-repeat="n in pagination.showedPageNumbers">
                <a ng-href="" ng-click="pagination.requestPage(n)" class="btn-page" ng-class="{'active': isPageShowed(n)}" aria-label="{{'${loc.loc("vysledky.GotToPageX")?noEsc}' | strParams : n}}">{{n}}</a>
            </span>
            <span ng-show="pagination.showedPageNumbers[pagination.showedPageNumbers.length-1] < pagination.getTotalPages()">
                <span>&#8230;</span> <#-- ellipsis -->
                <a ng-href="" ng-click="pagination.requestPage(pagination.getTotalPages())" class="btn-page" ng-class="{'active': isPageShowed(pagination.getTotalPages())}" aria-label="{{'${loc.loc("vysledky.GotToPageX")?noEsc}' | strParams : pagination.getTotalPages()}}">{{pagination.getTotalPages()}}</a>
            </span>
        </div>
        <div style="clear: left;"></div>
    </nav>

</div>