<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div ng-controller="PaymentFormCtrl" ng-init="init(model, modalWindowActions.submitPromise)" class="payment-selection-dialog">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true" ng-click="modalWindowActions.cancel()">&times;</button>
        <h3 class="modal-title">Zaplatit</h3>
    </div>

    <form ng-submit="submit()">
        <div class="modal-body">

            <p class="text-center">
                <strong>${loc.loc("payment.VybertePoplatkyKZaplaceni")?noEsc}</strong>
            </p>

            <table class="table table-hover">
                <tr ng-repeat="amount in formPackage.formObject.amounts" ng-class="{'text-muted': !amount.isSendable()}">

                    <td>
                        <input type="checkbox" ng-model="amount.enabled" />
                    </td>

                    <td style="width: 50%" ng-switch="amount.direct && typesEditable">
                        <span ng-switch-when="true">
                            <select class="form-control" ng-model="amount.type" ng-options="t as t|loc for t in amountTypes track by t.id"></select>
                        </span>
                        <span ng-switch-default>
                            {{amount.type|loc}}
                        </span>
                    </td>

                    <td ng-switch="amount.direct || sumsEditable">
                        <span ng-switch-when="true">
                            <input class="form-control" type="number" ng-model="amount.sum" min="{{0}}" max="{{amount.getMaxSum()}}" />
                        </span>
                        <span ng-switch-default>
                            {{amount.sum}}Kč
                        </span>
                    </td>

                </tr>
            </table>

            <p ng-if="formPackage.directPaymentAddable">
                <button ng-click="addDirectPayment()" type="button" class="btn btn-default btn-sm">
                    <span class="glyphicon glyphicon-plus"></span> Přidat přímou platbu
                </button>
            </p>

            <p style="border-top: 1px solid lightgray; padding-top: 20px; margin-top: 20px;">
                <kp-svelte-component-wrapper component="::kpUniversalFormComponent"
                                             props="{formSettings: formPackage.formSetting, model: formPackage.formObject}"
                                             ng-on-submit="submit()">
                </kp-svelte-component-wrapper>
            </p>

            <p>
                <button type="submit" class="btn btn-primary btn-block" ng-disabled="!isSubmittable()">
                    ${loc.loc("payment.Zaplatit")?noEsc} {{getTotalSum()}}Kč
                </button>
            </p>

        </div>

        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" ng-click="modalWindowActions.cancel()">
                ${loc.loc("commons.zavrit")?noEsc}
            </button>
        </div>
    </form>

</div>