/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.web;

import com.sun.net.httpserver.HttpExchange;
import cz.kpsys.portaro.commons.io.ReplacingInputStream;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.jobrunr.dashboard.server.AbstractHttpExchangeHandler;
import org.jobrunr.dashboard.server.http.ContentType;
import org.jobrunr.utils.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedStaticFileHttpHandler
extends AbstractHttpExchangeHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxiedStaticFileHttpHandler.class);
    @NonNull
    private final String contextPath;
    @NonNull
    private final String rootDir;
    private final boolean singlePageApp;
    @NonNull
    private final LinkedHashMap<String, String> replacements = new LinkedHashMap();

    public ProxiedStaticFileHttpHandler replacing(String pattern, String replacement) {
        this.replacements.put(pattern, replacement);
        return this;
    }

    @NonNull
    public String getContextPath() {
        return this.contextPath;
    }

    public void handle(HttpExchange httpExchange) {
        try {
            String requestUri = httpExchange.getRequestURI().toString();
            requestUri = this.sanitizeRequestUri(requestUri);
            String toServe = requestUri.substring((this.contextPath + "/").length());
            URL resource = this.getClass().getClassLoader().getResource(this.rootDir + toServe);
            if (resource != null) {
                httpExchange.getResponseHeaders().add("content-type", ContentType.from((String)toServe));
                httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
                httpExchange.sendResponseHeaders(200, 0L);
                this.copyResourceToResponseBody(resource, httpExchange);
            } else {
                httpExchange.sendResponseHeaders(404, -1L);
            }
        }
        catch (Exception shouldNotHappen) {
            log.error("Error serving static files", (Throwable)shouldNotHappen);
        }
    }

    private String sanitizeRequestUri(String requestUri) {
        if (requestUri.contains(".")) {
            return requestUri;
        }
        if (this.singlePageApp) {
            return this.contextPath + "/index.html";
        }
        if (requestUri.equals(this.contextPath)) {
            return requestUri + "/index.html";
        }
        if (requestUri.equals(this.contextPath + "/")) {
            return requestUri + "index.html";
        }
        return requestUri;
    }

    void copyResourceToResponseBody(URL resource, HttpExchange httpExchange) throws IOException {
        try (InputStream inputStream = resource.openStream();
             OutputStream outputStream = httpExchange.getResponseBody();){
            InputStream replacingInputStream = ReplacingInputStream.of((InputStream)inputStream, (Map)this.replacements);
            IOUtils.copyStream((InputStream)replacingInputStream, (OutputStream)outputStream);
        }
    }

    @ConstructorProperties(value={"contextPath", "rootDir", "singlePageApp"})
    @Generated
    public ProxiedStaticFileHttpHandler(@NonNull String contextPath, @NonNull String rootDir, boolean singlePageApp) {
        Objects.requireNonNull(contextPath, "contextPath is marked non-null but is null");
        Objects.requireNonNull(rootDir, "rootDir is marked non-null but is null");
        this.contextPath = contextPath;
        this.rootDir = rootDir;
        this.singlePageApp = singlePageApp;
    }
}

