/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.auth.internal.PasswordCheckingStringPairUserProvider;
import cz.kpsys.portaro.auth.password.PasswordChecker;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.localization.UserFriendlyExceptionTextResolver;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.export.ExportedExemplarsLoader;
import cz.kpsys.portaro.licence.FeatureEnabledProvider;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.loan.LoanLoader;
import cz.kpsys.portaro.loan.LoansProviderService;
import cz.kpsys.portaro.loan.availability.ExemplarAvailabilityService;
import cz.kpsys.portaro.loan.cancellation.CancellationService;
import cz.kpsys.portaro.loan.renewal.RenewabilityService;
import cz.kpsys.portaro.loan.renewal.RenewalService;
import cz.kpsys.portaro.loan.request.StandardLoanRequestService;
import cz.kpsys.portaro.ncip.EnabledCheckingHandler;
import cz.kpsys.portaro.ncip.ExceptionHandlingProxyHandler;
import cz.kpsys.portaro.ncip.JaxbXmlMessageHandler;
import cz.kpsys.portaro.ncip.NcipController;
import cz.kpsys.portaro.ncip.NcipSecurityActions;
import cz.kpsys.portaro.ncip.NcipSettingKeys;
import cz.kpsys.portaro.ncip.ProblemCreator;
import cz.kpsys.portaro.ncip.SecurityCheckingHandler;
import cz.kpsys.portaro.ncip.XmlMessageHandler;
import cz.kpsys.portaro.ncip.handler.DispatchingHandler;
import cz.kpsys.portaro.ncip.handler.NcipHandler;
import cz.kpsys.portaro.ncip.handler.UnwrappedHandler;
import cz.kpsys.portaro.ncip.handler.UnwrappingHandler;
import cz.kpsys.portaro.ncip.impl.Authenticator;
import cz.kpsys.portaro.ncip.impl.CancelRequestItemHandler;
import cz.kpsys.portaro.ncip.impl.ItemOptionalFieldsLoader;
import cz.kpsys.portaro.ncip.impl.LookupAgencyHandler;
import cz.kpsys.portaro.ncip.impl.LookupItemHandler;
import cz.kpsys.portaro.ncip.impl.LookupItemSetHandler;
import cz.kpsys.portaro.ncip.impl.LookupRequestHandler;
import cz.kpsys.portaro.ncip.impl.LookupUserHandler;
import cz.kpsys.portaro.ncip.impl.NcipAgencyIdProvider;
import cz.kpsys.portaro.ncip.impl.RenewItemHandler;
import cz.kpsys.portaro.ncip.impl.RequestItemHandler;
import cz.kpsys.portaro.ncip.impl.convert.BuildingToNcipLocationConverter;
import cz.kpsys.portaro.ncip.impl.convert.DocumentToNcipBibliographicDescriptionConverter;
import cz.kpsys.portaro.ncip.impl.convert.ExemplarAvailabilityToNcipCirculationStatusConverter;
import cz.kpsys.portaro.ncip.impl.convert.ExemplarAvailabilityToNcipItemUseRestrictionTypeConverter;
import cz.kpsys.portaro.ncip.impl.convert.ExemplarToNcipItemDescriptionConverter;
import cz.kpsys.portaro.ncip.impl.convert.ExemplarToNcipItemIdConverterAsId;
import cz.kpsys.portaro.ncip.impl.convert.LoanToNcipLoanConverter;
import cz.kpsys.portaro.ncip.impl.convert.LoanToNcipRequestIdConverter;
import cz.kpsys.portaro.ncip.impl.convert.LoanToNcipRequestStatusTypeConverter;
import cz.kpsys.portaro.ncip.impl.convert.LoanToNcipRequestTypeConverter;
import cz.kpsys.portaro.ncip.impl.convert.LoanToNcipRequestedItemConverter;
import cz.kpsys.portaro.ncip.impl.convert.NcipBibliographicItemIdToRecordConverter;
import cz.kpsys.portaro.ncip.impl.convert.NcipItemIdToExemplarConverterById;
import cz.kpsys.portaro.ncip.impl.convert.NcipItemIdToLoanConverterDelegating;
import cz.kpsys.portaro.ncip.impl.convert.NcipRequestIdToLoanConverter;
import cz.kpsys.portaro.ncip.impl.convert.NcipUserIdToUserConverter;
import cz.kpsys.portaro.ncip.impl.convert.RecordToNcipBibliographicItemIdConverter;
import cz.kpsys.portaro.ncip.impl.convert.StringToNcipUnstructuredAddressConverter;
import cz.kpsys.portaro.ncip.impl.convert.TransactionToNcipAmountConverter;
import cz.kpsys.portaro.ncip.impl.convert.UserToNcipUserIdConverter;
import cz.kpsys.portaro.ncip.schema.BibliographicDescription;
import cz.kpsys.portaro.ncip.schema.BibliographicItemId;
import cz.kpsys.portaro.ncip.schema.ItemId;
import cz.kpsys.portaro.ncip.schema.RequestId;
import cz.kpsys.portaro.ncip.schema.RequestedItem;
import cz.kpsys.portaro.ncip.schema.UnstructuredAddress;
import cz.kpsys.portaro.ncip.schema.UserId;
import cz.kpsys.portaro.ncip.schema.custom.RequestStatusType;
import cz.kpsys.portaro.ncip.schema.custom.RequestType;
import cz.kpsys.portaro.oai.provider.impl.OaiSettingKeys;
import cz.kpsys.portaro.payment.TransactionLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.document.Document;
import cz.kpsys.portaro.record.document.DocumentLoader;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.export.RecordExport;
import cz.kpsys.portaro.record.export.RecordExportConfig;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.ConfigurableBasicUserToStringIdentifierConverter;
import cz.kpsys.portaro.user.ConfigurableUserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.SearchingUserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.StringPairUserProvider;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.UserConstants;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
@Lazy
public class NcipConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcipConfig.class);
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader;
    @NonNull
    private final ByIdLoadable<User, String> stringIdUserLoader;
    @NonNull
    private final UserByBasicUserLoader userLoader;
    @NonNull
    private final PasswordChecker passwordChecker;
    @NonNull
    private final LoanLoader loanLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader;
    @NonNull
    private final ExemplarAvailabilityService exemplarAvailabilityService;
    @NonNull
    private final TransactionLoader transactionLoader;
    @NonNull
    private final DocumentLoader detailedDocumentLoader;
    @NonNull
    private final ByIdLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final IdAndIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<Exemplar, Integer> exemplarLoader;
    @NonNull
    private final ExportedExemplarsLoader exportedExemplarsLoader;
    @NonNull
    private final @NonNull Provider<@NonNull RecordExport> defaultRecordExportProvider;
    @NonNull
    private final HierarchyContextsByModeLoader<Department> departmentAccessor;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final RenewalService renewalService;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver;
    @NonNull
    private final StandardLoanRequestService standardLoanRequestService;
    @NonNull
    private final CancellationService cancellationService;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final RenewabilityService renewabilityService;
    @NonNull
    private final LoansProviderService securedLoansProviderService;

    @Bean
    public NcipController ncipController() {
        log.info("Enabling module {}", (Object)"ncip-server");
        return new NcipController(this.xmlMessageHandler());
    }

    public String agencyId() {
        return "KPSYS-TEST";
    }

    @Bean
    public XmlMessageHandler xmlMessageHandler() {
        ProblemCreator problemCreator = new ProblemCreator(this.translator, this.userFriendlyExceptionTextResolver);
        return new JaxbXmlMessageHandler(problemCreator, true, (NcipHandler)new ExceptionHandlingProxyHandler((NcipHandler)new EnabledCheckingHandler((ContextualProvider)ContextIgnoringContextualProvider.of((Provider)new FeatureEnabledProvider(this.featureManager, "ncip-server")), (NcipHandler)new SecurityCheckingHandler(this.securityManager, (NcipHandler)new DispatchingHandler(new NcipHandler[]{this.lookupItemHandler(), this.lookupItemSetHandler(), this.lookupUserHandler(), this.requestItemHandler(), this.renewItemHandler(), this.lookupRequestHandler(), this.cancelRequestItemHandler(), this.lookupAgencyHandler()}))), problemCreator));
    }

    @Bean
    public NcipHandler lookupAgencyHandler() {
        ContextualProvider userRegistrationUrl = department -> (String)this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).getOn(department) + "/?showLogin=true";
        return UnwrappingHandler.ofLookupAgency((UnwrappedHandler)new LookupAgencyHandler(this.systemInstitutionProvider, userRegistrationUrl, this.ncipAgencyIdProvider(), this.stringToNcipUnstructuredAddressConverter()));
    }

    @Bean
    public NcipHandler cancelRequestItemHandler() {
        return UnwrappingHandler.ofCancelRequestItem((UnwrappedHandler)new CancelRequestItemHandler(this.loanSearchLoader, this.ncipItemIdToExemplarConverter(), this.ncipRequestIdToLoanConverter(), this.cancellationService, this.ncipUserIdToUserConverter()));
    }

    @Bean
    public NcipHandler lookupRequestHandler() {
        return UnwrappingHandler.ofLookupRequest((UnwrappedHandler)new LookupRequestHandler(this.exemplarToItemIdConverter(), this.ncipRequestIdToLoanConverter(), this.ncipItemIdToLoanConverter(), this.translator, this.basicUserToNcipUserIdConverter(), this.loanToNcipRequestIdConverter(), this.loanToNcipRequestTypeConverter(), this.loanToNcipRequestStatusTypeConverter()));
    }

    @Bean
    public NcipHandler renewItemHandler() {
        return UnwrappingHandler.ofRenewItem((UnwrappedHandler)new RenewItemHandler(this.renewalService, this.ncipItemIdToLoanConverter(), this.ncipUserIdToUserConverter(), this.basicUserToNcipUserIdConverter()));
    }

    @Bean
    public NcipHandler requestItemHandler() {
        return UnwrappingHandler.ofRequestItem((UnwrappedHandler)new RequestItemHandler(this.standardLoanRequestService, this.nonDetailedDocumentLoader, this.ncipItemIdToExemplarConverter(), this.ncipUserIdToUserConverter()));
    }

    @Bean
    public NcipHandler lookupUserHandler() {
        return UnwrappingHandler.ofLookupUser((UnwrappedHandler)new LookupUserHandler(this.authenticator(), this.securedLoansProviderService, this.transactionLoader, this.basicUserToNcipUserIdConverter(), this.ncipAgencyIdProvider(), this.stringToNcipUnstructuredAddressConverter(), this.ncipUserIdToUserConverter(), this.loanToNcipRequestedItemConverter(), this.loanToNcipLoanConverter(), this.amountToNcipAmountConverter(), this.translator));
    }

    @Bean
    public NcipHandler lookupItemSetHandler() {
        return UnwrappingHandler.ofLookupItemSet((UnwrappedHandler)new LookupItemSetHandler((AllByIdsLoadable)this.exemplarLoader, this.nonDetailedDocumentLoader, this.exportedExemplarsLoader, this.defaultRecordExportProvider, this.itemOptionalFieldsLoader(), this.ncipBibliographicItemIdToRecordConverter(), this.recordToBibliographicItemIdConverter(), this.exemplarToItemIdConverter(), this.ncipUserIdToUserConverter()));
    }

    @Bean
    public NcipHandler lookupItemHandler() {
        return UnwrappingHandler.ofLookupItem((UnwrappedHandler)new LookupItemHandler(this.ncipItemIdToExemplarConverter(), this.itemOptionalFieldsLoader(), this.ncipUserIdToUserConverter()));
    }

    @Bean
    public UserByContextualIdentifierLoader<User> userByNcipIdentifierLoader() {
        return new ConfigurableUserByContextualIdentifierLoader(this.settingLoader.getDepartmentedProvider(NcipSettingKeys.NCIP_USER_IDENTIFIER), this.stringIdUserLoader, this.userSearchLoader, this.departmentAccessor);
    }

    @Bean
    public NcipUserIdToUserConverter ncipUserIdToUserConverter() {
        return new NcipUserIdToUserConverter(this.userByNcipIdentifierLoader());
    }

    @Bean
    public ContextualFunction<BasicUser, Department, String> basicUserToNcipIdentifierConverter() {
        return new ConfigurableBasicUserToStringIdentifierConverter(this.settingLoader.getDepartmentedProvider(NcipSettingKeys.NCIP_USER_IDENTIFIER), this.userLoader);
    }

    @Bean
    public ContextualFunction<BasicUser, Department, UserId> basicUserToNcipUserIdConverter() {
        return new UserToNcipUserIdConverter(this.ncipAgencyIdProvider(), this.basicUserToNcipIdentifierConverter());
    }

    @Bean
    public Authenticator authenticator() {
        return new Authenticator((StringPairUserProvider)new PasswordCheckingStringPairUserProvider(this.userByNcipIdentifierLoader(), this.passwordChecker), (StringPairUserProvider)new PasswordCheckingStringPairUserProvider((UserByContextualIdentifierLoader)new SearchingUserByContextualIdentifierLoader(this.userSearchLoader, (Property)UserConstants.SearchParams.USERNAME), this.passwordChecker), (StringPairUserProvider)new PasswordCheckingStringPairUserProvider((UserByContextualIdentifierLoader)new SearchingUserByContextualIdentifierLoader(this.userSearchLoader, (Property)UserConstants.SearchParams.BAR_CODE), this.passwordChecker));
    }

    @Bean
    public Converter<Exemplar, ItemId> exemplarToItemIdConverter() {
        return new ExemplarToNcipItemIdConverterAsId();
    }

    @Bean
    public Converter<ItemId, Exemplar> ncipItemIdToExemplarConverter() {
        return new NcipItemIdToExemplarConverterById((ByIdLoadable)this.exemplarLoader);
    }

    @Bean
    public Converter<ItemId, Loan> ncipItemIdToLoanConverter() {
        return new NcipItemIdToLoanConverterDelegating(this.ncipItemIdToExemplarConverter(), this.loanSearchLoader);
    }

    @Bean
    public Converter<RequestId, Loan> ncipRequestIdToLoanConverter() {
        return new NcipRequestIdToLoanConverter((ByIdLoadable)this.loanLoader);
    }

    @Bean
    public ItemOptionalFieldsLoader itemOptionalFieldsLoader() {
        return new ItemOptionalFieldsLoader((ByIdLoadable)this.detailedDocumentLoader, this.exemplarAvailabilityService, this.documentToBibliographicDescriptionConverter(), (Converter)new ExemplarToNcipItemDescriptionConverter(), new BuildingToNcipLocationConverter(this.translator), (Converter)new ExemplarAvailabilityToNcipItemUseRestrictionTypeConverter(), (Converter)new ExemplarAvailabilityToNcipCirculationStatusConverter());
    }

    @Bean
    public Converter<String, UnstructuredAddress> stringToNcipUnstructuredAddressConverter() {
        return new StringToNcipUnstructuredAddressConverter();
    }

    @Bean
    public NcipAgencyIdProvider ncipAgencyIdProvider() {
        return new NcipAgencyIdProvider(this.agencyId());
    }

    @Bean
    public Converter<Record, BibliographicItemId> recordToBibliographicItemIdConverter() {
        return new RecordToNcipBibliographicItemIdConverter(this.useRecordIdEnabledProvider());
    }

    private Provider<@NonNull Boolean> useRecordIdEnabledProvider() {
        return () -> {
            String oaiDocumentIdPattern = (String)this.settingLoader.getOnRoot(OaiSettingKeys.DOCUMENT_ID_PATTERN);
            return oaiDocumentIdPattern == null || oaiDocumentIdPattern.contains(RecordExportConfig.RECORD_ID_PLACEHOLDER);
        };
    }

    @Bean
    public Converter<BibliographicItemId, ? extends Document> ncipBibliographicItemIdToRecordConverter() {
        return new NcipBibliographicItemIdToRecordConverter(this.useRecordIdEnabledProvider(), this.nonDetailedDocumentByKindedIdLoader, this.nonDetailedDocumentLoader);
    }

    @Bean
    public Converter<Loan, RequestId> loanToNcipRequestIdConverter() {
        return new LoanToNcipRequestIdConverter();
    }

    @Bean
    public Converter<Loan, RequestedItem> loanToNcipRequestedItemConverter() {
        return new LoanToNcipRequestedItemConverter(this.detailedDocumentLoader, this.exemplarToItemIdConverter(), this.loanToNcipRequestIdConverter(), this.documentToBibliographicDescriptionConverter(), this.loanToNcipRequestTypeConverter(), this.loanToNcipRequestStatusTypeConverter());
    }

    @Bean
    public Converter<Record, BibliographicDescription> documentToBibliographicDescriptionConverter() {
        return new DocumentToNcipBibliographicDescriptionConverter(this.recordToBibliographicItemIdConverter());
    }

    @Bean
    public LoanToNcipLoanConverter loanToNcipLoanConverter() {
        return new LoanToNcipLoanConverter(this.detailedDocumentLoader, this.exemplarToItemIdConverter(), this.renewabilityService, this.documentToBibliographicDescriptionConverter());
    }

    @Bean
    public Converter<Loan, RequestStatusType> loanToNcipRequestStatusTypeConverter() {
        return new LoanToNcipRequestStatusTypeConverter();
    }

    @Bean
    public Converter<Loan, RequestType> loanToNcipRequestTypeConverter() {
        return new LoanToNcipRequestTypeConverter();
    }

    @Bean
    public TransactionToNcipAmountConverter amountToNcipAmountConverter() {
        return new TransactionToNcipAmountConverter(this.translator);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(NcipSecurityActions.NCIP_USE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, none) -> (Boolean)this.settingLoader.getDepartmentedProvider(NcipSettingKeys.NCIP_CLIENT_AUTHENTICATION_REQUIRED).getOn((Object)ctx) == false ? PermissionResult.allow() : PermissionResult.forbidden(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActive(), (auth, ctx, none) -> {
            String username = auth.getActiveUser().getUsername();
            if (username != null && Set.of("SU", "cpk").contains(username)) {
                return PermissionResult.allow();
            }
            return PermissionResult.forbidden((Text)Texts.ofNative((String)"Authenticated user is not in NCIP username whitelist"));
        }})}));
    }

    @ConstructorProperties(value={"settingLoader", "featureManager", "userSearchLoader", "stringIdUserLoader", "userLoader", "passwordChecker", "loanLoader", "loanSearchLoader", "exemplarAvailabilityService", "transactionLoader", "detailedDocumentLoader", "nonDetailedDocumentLoader", "nonDetailedDocumentByKindedIdLoader", "exemplarLoader", "exportedExemplarsLoader", "defaultRecordExportProvider", "departmentAccessor", "systemInstitutionProvider", "renewalService", "translator", "userFriendlyExceptionTextResolver", "standardLoanRequestService", "cancellationService", "securityManager", "permissionRegistry", "permissionFactory", "renewabilityService", "securedLoansProviderService"})
    @Generated
    public NcipConfig(@NonNull SettingLoader settingLoader, @NonNull FeatureManager featureManager, @NonNull ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader, @NonNull ByIdLoadable<User, String> stringIdUserLoader, @NonNull UserByBasicUserLoader userLoader, @NonNull PasswordChecker passwordChecker, @NonNull LoanLoader loanLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader, @NonNull ExemplarAvailabilityService exemplarAvailabilityService, @NonNull TransactionLoader transactionLoader, @NonNull DocumentLoader detailedDocumentLoader, @NonNull ByIdLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull IdAndIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader, @NonNull IdAndIdsLoadable<Exemplar, Integer> exemplarLoader, @NonNull ExportedExemplarsLoader exportedExemplarsLoader, @NonNull @NonNull Provider<@NonNull RecordExport> defaultRecordExportProvider, @NonNull HierarchyContextsByModeLoader<Department> departmentAccessor, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull RenewalService renewalService, @NonNull Translator<Department> translator, @NonNull UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver, @NonNull StandardLoanRequestService standardLoanRequestService, @NonNull CancellationService cancellationService, @NonNull SecurityManager securityManager, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull RenewabilityService renewabilityService, @NonNull LoansProviderService securedLoansProviderService) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(stringIdUserLoader, "stringIdUserLoader is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(passwordChecker, "passwordChecker is marked non-null but is null");
        Objects.requireNonNull(loanLoader, "loanLoader is marked non-null but is null");
        Objects.requireNonNull(loanSearchLoader, "loanSearchLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarAvailabilityService, "exemplarAvailabilityService is marked non-null but is null");
        Objects.requireNonNull(transactionLoader, "transactionLoader is marked non-null but is null");
        Objects.requireNonNull(detailedDocumentLoader, "detailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentByKindedIdLoader, "nonDetailedDocumentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarLoader, "exemplarLoader is marked non-null but is null");
        Objects.requireNonNull(exportedExemplarsLoader, "exportedExemplarsLoader is marked non-null but is null");
        Objects.requireNonNull(defaultRecordExportProvider, "defaultRecordExportProvider is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(renewalService, "renewalService is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(userFriendlyExceptionTextResolver, "userFriendlyExceptionTextResolver is marked non-null but is null");
        Objects.requireNonNull(standardLoanRequestService, "standardLoanRequestService is marked non-null but is null");
        Objects.requireNonNull(cancellationService, "cancellationService is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(renewabilityService, "renewabilityService is marked non-null but is null");
        Objects.requireNonNull(securedLoansProviderService, "securedLoansProviderService is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.featureManager = featureManager;
        this.userSearchLoader = userSearchLoader;
        this.stringIdUserLoader = stringIdUserLoader;
        this.userLoader = userLoader;
        this.passwordChecker = passwordChecker;
        this.loanLoader = loanLoader;
        this.loanSearchLoader = loanSearchLoader;
        this.exemplarAvailabilityService = exemplarAvailabilityService;
        this.transactionLoader = transactionLoader;
        this.detailedDocumentLoader = detailedDocumentLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.nonDetailedDocumentByKindedIdLoader = nonDetailedDocumentByKindedIdLoader;
        this.exemplarLoader = exemplarLoader;
        this.exportedExemplarsLoader = exportedExemplarsLoader;
        this.defaultRecordExportProvider = defaultRecordExportProvider;
        this.departmentAccessor = departmentAccessor;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.renewalService = renewalService;
        this.translator = translator;
        this.userFriendlyExceptionTextResolver = userFriendlyExceptionTextResolver;
        this.standardLoanRequestService = standardLoanRequestService;
        this.cancellationService = cancellationService;
        this.securityManager = securityManager;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.renewabilityService = renewabilityService;
        this.securedLoansProviderService = securedLoansProviderService;
    }
}

