/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.form.editor2.ValueEditorModifier;
import cz.kpsys.portaro.form.editor2.range.RangeValueEditor;
import cz.kpsys.portaro.form.editor2.range.RangeValueEditorOptions;
import cz.kpsys.portaro.form.form.FormByFormObjectFactory;
import cz.kpsys.portaro.maps.DatabaseCachingGeocoderProxy;
import cz.kpsys.portaro.maps.Geocoder;
import cz.kpsys.portaro.maps.GoogleMapsGeocoder;
import cz.kpsys.portaro.proveniencesmap.AuthorityToHistoricalPlacesConverter;
import cz.kpsys.portaro.proveniencesmap.CoordinatesFromFieldFinder;
import cz.kpsys.portaro.proveniencesmap.HistoricalPlace;
import cz.kpsys.portaro.proveniencesmap.HistoricalPlaceLoader;
import cz.kpsys.portaro.proveniencesmap.HistoricalPlaceSaveTableWriteGenerator;
import cz.kpsys.portaro.proveniencesmap.HistoricalPlaceUpdater;
import cz.kpsys.portaro.proveniencesmap.HistoricalPlacesRequest;
import cz.kpsys.portaro.proveniencesmap.PlacesHistoryApiController;
import cz.kpsys.portaro.proveniencesmap.PlacesHistoryPageController;
import cz.kpsys.portaro.proveniencesmap.ProvenienceType;
import cz.kpsys.portaro.proveniencesmap.SpringDbHistoricalPlaceLoader;
import cz.kpsys.portaro.record.authority.Authority;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.Calendar;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.web.client.RestOperations;

@Configuration
@Lazy
public class HistoricalPlaceConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoricalPlaceConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final IdAndIdsLoadable<Authority, UUID> authorityLoader;
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final FormByFormObjectFactory formByFormObjectFactory;
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final CacheDeletableById recordCache;

    @Bean
    public PlacesHistoryPageController placesHistoryPageController() {
        return new PlacesHistoryPageController(this.publicContextPath);
    }

    @Bean
    public PlacesHistoryApiController placesHistoryApiController() {
        log.info("Enabling Proveniences map module");
        return new PlacesHistoryApiController(this.historicalPlaceLoader(), this.historicalPlaceUpdater(), this.formByFormObjectFactory);
    }

    @Bean
    public HistoricalPlaceLoader historicalPlaceLoader() {
        return new SpringDbHistoricalPlaceLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public Saver<HistoricalPlace> historicalPlaceSaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new HistoricalPlaceSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[0]);
    }

    @Bean
    public HistoricalPlaceUpdater historicalPlaceUpdater() {
        DatabaseCachingGeocoderProxy geocoder = new DatabaseCachingGeocoderProxy(this.jdbcTemplate, this.queryFactory, (Geocoder)new GoogleMapsGeocoder(this.rest));
        return new HistoricalPlaceUpdater(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.authorityLoader, this.historicalPlaceSaver(), (Converter)new AuthorityToHistoricalPlacesConverter(new CoordinatesFromFieldFinder((Geocoder)geocoder)), this.recordCache);
    }

    @Bean
    public AllValuesProvider<ProvenienceType> historicalPlacesRequestProveniencesTypes() {
        return ProvenienceType.CODEBOOK;
    }

    @Bean
    ValueEditorModifier<RangeValueEditor, HistoricalPlacesRequest> historicalPlacesRequestYearRangeModifier() {
        return (editor, formObject, ctx) -> {
            int min = editor.getOptions().flatMap(RangeValueEditorOptions::getMin).orElse(0);
            return editor.withExtremes(min, Calendar.getInstance().get(1));
        };
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(ProvenienceType.class, (ByIdLoadable)ProvenienceType.CODEBOOK);
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "dmlAppserverService", "authorityLoader", "rest", "converterRegisterer", "formByFormObjectFactory", "publicContextPath", "recordCache"})
    @Generated
    public HistoricalPlaceConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DmlAppserverService dmlAppserverService, @NonNull IdAndIdsLoadable<Authority, UUID> authorityLoader, @NonNull RestOperations rest, @NonNull ConverterRegisterer converterRegisterer, @NonNull FormByFormObjectFactory formByFormObjectFactory, @NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull CacheDeletableById recordCache) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(authorityLoader, "authorityLoader is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(formByFormObjectFactory, "formByFormObjectFactory is marked non-null but is null");
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.dmlAppserverService = dmlAppserverService;
        this.authorityLoader = authorityLoader;
        this.rest = rest;
        this.converterRegisterer = converterRegisterer;
        this.formByFormObjectFactory = formByFormObjectFactory;
        this.publicContextPath = publicContextPath;
        this.recordCache = recordCache;
    }
}

