/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.FeatureNotEnabledException;
import cz.kpsys.portaro.FieldsNotResolvableException;
import cz.kpsys.portaro.app.webutil.SessionDestroyedEventListener;
import cz.kpsys.portaro.appserver.AppserverInformativeResponseException;
import cz.kpsys.portaro.auth.BadLoginCredentialsException;
import cz.kpsys.portaro.auth.InsufficientlyAuthenticatedException;
import cz.kpsys.portaro.auth.UserIsNotPersonAuthenticationException;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.external.ExternalAuthenticationCancelException;
import cz.kpsys.portaro.auth.external.ExternallyAuthenticatedUserIsNotInLocalException;
import cz.kpsys.portaro.auth.useragent.EvidedUserUserAgentRegistration;
import cz.kpsys.portaro.commons.ip.IpAddressInRangeResolver;
import cz.kpsys.portaro.commons.localization.UserFriendlyExceptionTextResolver;
import cz.kpsys.portaro.commons.logging.LogOnlyAsDebug;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SeveritedException;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.ProgrammaticalTransactionalSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.AnnotationUtil;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.web.ObjectUrlIdResolver;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.conversation.StaticActionResponse;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.form.conversation.AnnotationFormSubmitPackageModifier;
import cz.kpsys.portaro.form.form.FormByFormObjectFactory;
import cz.kpsys.portaro.form.formobject.ConfirmableRequest;
import cz.kpsys.portaro.form.formobject.ConfirmationRequestFormObjectModifier;
import cz.kpsys.portaro.form.spring.BindExceptionObjectResolverByForm;
import cz.kpsys.portaro.form.spring.BindingResultRecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.ConstraintViolationExceptionObjectResolverByForm;
import cz.kpsys.portaro.form.spring.ConstraintViolationExceptionRecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.MessageTemplateResolvingConstraintViolationExceptionRecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.MethodArgumentNotValidExceptionObjectResolverByForm;
import cz.kpsys.portaro.form.spring.RecoverableErrorResolver;
import cz.kpsys.portaro.form.spring.ValidationErrorFormResolver;
import cz.kpsys.portaro.form.submit.AnnotationFormSubmitTargetByFormObjectResolver;
import cz.kpsys.portaro.form.submit.FormSubmitTargetByFormObjectResolver;
import cz.kpsys.portaro.form.validation.AdhocValidator;
import cz.kpsys.portaro.form.validation.AfterRequiredValidationViolationFormObjectModifier;
import cz.kpsys.portaro.form.validation.BeforeRequiredSupportingAdhocValidator;
import cz.kpsys.portaro.form.validation.JavaxValidationAdhocValidator;
import cz.kpsys.portaro.form.validation.RequiredFieldsValidationGroupAdhocValidator;
import cz.kpsys.portaro.logging.ClientSession;
import cz.kpsys.portaro.logging.ClientSessionByClientRequestUpdater;
import cz.kpsys.portaro.logging.ClientSessionEntity;
import cz.kpsys.portaro.logging.ClientSessionRepository;
import cz.kpsys.portaro.logging.ClientSessionSavingClientRequestSaver;
import cz.kpsys.portaro.logging.ClientSessionToEntityConverter;
import cz.kpsys.portaro.logging.CombinedClientSessionRepository;
import cz.kpsys.portaro.logging.InMemoryClientSessionRepository;
import cz.kpsys.portaro.logging.UserCheckingBotFinder;
import cz.kpsys.portaro.logging.WebClientRequestWebResolver;
import cz.kpsys.portaro.object.CompositeDepartmentedObjectModifier;
import cz.kpsys.portaro.object.DepartmentedObjectModifier;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.pops.agreement.AgreementConfirmationException;
import cz.kpsys.portaro.search.lucene.IncorrectLuceneQueryException;
import cz.kpsys.portaro.security.NotActivatedException;
import cz.kpsys.portaro.user.UserByUsernameLoader;
import cz.kpsys.portaro.view.web.ClientSessionVerifierApiController;
import cz.kpsys.portaro.view.web.log.UserInfoLogAddingSimpleRequestDebugStringBuilder;
import cz.kpsys.portaro.view.web.ratelimit.RateLimitExceededException;
import cz.kpsys.portaro.web.ExceptionObjectResolverByUserFriendlyTextResolver;
import cz.kpsys.portaro.web.JsonResponseEntityHttpResponseWriter;
import cz.kpsys.portaro.web.ResponseEntityHttpResponseWriter;
import cz.kpsys.portaro.web.bot.BotFinder;
import cz.kpsys.portaro.web.bot.BotProbabilityProvider;
import cz.kpsys.portaro.web.bot.CompositeBotFinder;
import cz.kpsys.portaro.web.bot.ExactUserAgentMatcher;
import cz.kpsys.portaro.web.bot.InfixUserAgentMatcher;
import cz.kpsys.portaro.web.bot.IpBasedBotFinder;
import cz.kpsys.portaro.web.bot.PrefixUserAgentMatcher;
import cz.kpsys.portaro.web.bot.UserAgentBasedBotFinder;
import cz.kpsys.portaro.web.bot.UserAgentMatcher;
import cz.kpsys.portaro.web.client.WebClientRequest;
import cz.kpsys.portaro.web.exception.AddableExceptionResponseLogger;
import cz.kpsys.portaro.web.exception.CompositeExceptionObjectResolver;
import cz.kpsys.portaro.web.exception.CompositeWebClientRequestExceptionResponseLogger;
import cz.kpsys.portaro.web.exception.ExceptionObjectResolver;
import cz.kpsys.portaro.web.exception.ExceptionResponseLogger;
import cz.kpsys.portaro.web.log.RequestDebugStringBuilder;
import cz.kpsys.portaro.web.page.CompositeCurrentPageDialogsResolver;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import jakarta.persistence.EntityManager;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiPredicate;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.ServletWrappingController;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;

@org.springframework.context.annotation.Configuration
public class WebConfig {
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final WebResolver<Department> currentDepartmentWebResolver;
    @NonNull
    private final Provider<UUID> traceIdRepository;
    @NonNull
    private final IpAddressInRangeResolver internalIpResolver;
    @NonNull
    private final ServletWrappingController appserverProxyController;
    @NonNull
    private final ServletWrappingController dbConsoleProxyController;
    @NonNull
    private final ServletWrappingController jobRunrDashboardProxyController;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final ObjectUrlIdResolver objectUrlIdResolver;
    @NonNull
    private final UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver;
    @NonNull
    private final FormByFormObjectFactory formByFormObjectFactory;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final BeanFactory applicationContext;
    @NonNull
    private final UserByUsernameLoader userByUsernameLoader;
    @NonNull
    private final Validator validator;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final PlatformTransactionManager transactionManager;

    @Bean
    public SimpleUrlHandlerMapping urlHandlerMapping() {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setLazyInitHandlers(true);
        mapping.setOrder(0x7FFFFFFD);
        Properties mappings = new Properties();
        mappings.put("/appserver/**", this.appserverProxyController);
        mappings.put("/db/**", this.dbConsoleProxyController);
        mappings.put("/jobs/**", this.jobRunrDashboardProxyController);
        mapping.setMappings(mappings);
        return mapping;
    }

    @Bean
    public WebResolver<WebClientRequest> webClientRequestWebResolver() {
        return new WebClientRequestWebResolver(this.currentAuthWebResolver, this.currentDepartmentWebResolver, this.traceIdRepository);
    }

    @Bean
    public FreeMarkerViewResolver freeMarkerAngularTemplatesViewResolver() {
        FreeMarkerViewResolver resolver = new FreeMarkerViewResolver();
        resolver.setCache(false);
        resolver.setPrefix("");
        resolver.setSuffix(".ftl");
        resolver.setContentType("text/html;charset=UTF-8");
        resolver.setOrder(10);
        return resolver;
    }

    @Bean
    public FreeMarkerConfigurer freeMarkerConfig() throws IOException, TemplateException {
        FreeMarkerConfigurationFactory factory = new FreeMarkerConfigurationFactory();
        TemplateLoader[] loaders = new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/"), new ClassTemplateLoader(this.getClass(), "/freemarker"), new ClassTemplateLoader(FreeMarkerConfigurer.class, "")};
        factory.setPreTemplateLoaders(loaders);
        factory.setDefaultEncoding(StandardCharsets.UTF_8.name());
        Properties props = new Properties();
        props.put("date_format", "d.M.yyyy");
        props.put("datetime_format", "d.M.yyyy HH:mm:ss");
        props.put("incompatible_improvements", Configuration.VERSION_2_3_31.toString());
        factory.setFreemarkerSettings(props);
        FreeMarkerConfigurer result = new FreeMarkerConfigurer();
        result.setConfiguration(factory.createConfiguration());
        return result;
    }

    @Bean
    public ResponseEntityHttpResponseWriter responseEntityHttpResponseWriter() {
        return new JsonResponseEntityHttpResponseWriter(this.objectMapper);
    }

    @Bean
    public ValidationErrorFormResolver<ObjectError> bindingResultFormResolver() {
        return new ValidationErrorFormResolver(this.formSubmitTargetByFormObjectResolver(), (DepartmentedObjectModifier)new CompositeDepartmentedObjectModifier(List.of(new AfterRequiredValidationViolationFormObjectModifier(this.applicationContext), new ConfirmationRequestFormObjectModifier())), this.formByFormObjectFactory, this.currentDepartmentProvider, this.bindingResultRecoverableErrorResolver(), (TypedDepartmentedObjectModifier)new AnnotationFormSubmitPackageModifier(this.applicationContext));
    }

    @Bean
    public FormSubmitTargetByFormObjectResolver formSubmitTargetByFormObjectResolver() {
        return new AnnotationFormSubmitTargetByFormObjectResolver(this.objectUrlIdResolver);
    }

    @Bean
    public RecoverableErrorResolver<ObjectError> bindingResultRecoverableErrorResolver() {
        return new BindingResultRecoverableErrorResolver((Collection)this.customByFormRecoverableFieldResolver());
    }

    @Bean
    public ValidationErrorFormResolver<ConstraintViolation<?>> constraintViolationFormResolver() {
        return new ValidationErrorFormResolver(this.formSubmitTargetByFormObjectResolver(), (DepartmentedObjectModifier)new CompositeDepartmentedObjectModifier(List.of(new AfterRequiredValidationViolationFormObjectModifier(this.applicationContext), new ConfirmationRequestFormObjectModifier())), this.formByFormObjectFactory, this.currentDepartmentProvider, this.constraintViolationRecoverableErrorResolver(), (TypedDepartmentedObjectModifier)new AnnotationFormSubmitPackageModifier(this.applicationContext));
    }

    @Bean
    public RecoverableErrorResolver<ConstraintViolation<?>> constraintViolationRecoverableErrorResolver() {
        return new ConstraintViolationExceptionRecoverableErrorResolver((Collection)this.customByFormRecoverableFieldResolver());
    }

    @Bean
    public RecoverableErrorResolver<ConstraintViolation<?>> messageTemplateResolvingConstraintViolationRecoverableErrorResolver() {
        return new MessageTemplateResolvingConstraintViolationExceptionRecoverableErrorResolver((Collection)this.customByFormRecoverableFieldResolver());
    }

    private List<BiPredicate<Object, String>> customByFormRecoverableFieldResolver() {
        return List.of((violatedFormObject, field) -> violatedFormObject instanceof ConfirmableRequest && field.equals("confirmed"));
    }

    @Bean
    public AdhocValidator adhocValidator() {
        return new BeforeRequiredSupportingAdhocValidator((AdhocValidator)new JavaxValidationAdhocValidator(this.validator), (AdhocValidator)new RequiredFieldsValidationGroupAdhocValidator(this.validator), this.applicationContext);
    }

    @Bean
    public CompositeExceptionObjectResolver<Throwable> exceptionResponseObjectResolver() {
        return new CompositeExceptionObjectResolver().with(MethodArgumentNotValidException.class, (ExceptionObjectResolver)new MethodArgumentNotValidExceptionObjectResolverByForm(this.bindingResultFormResolver())).with(BindException.class, (ExceptionObjectResolver)new BindExceptionObjectResolverByForm(this.bindingResultFormResolver())).with(ConstraintViolationException.class, (ExceptionObjectResolver)new ConstraintViolationExceptionObjectResolverByForm(this.constraintViolationFormResolver())).withStatic(NotActivatedException.class, (Object)new StaticActionResponse("user-activation-required", false)).withFallback((ExceptionObjectResolver)new ExceptionObjectResolverByUserFriendlyTextResolver("Exception", this.userFriendlyExceptionTextResolver));
    }

    @Bean
    public RequestDebugStringBuilder requestDebugStringBuilder() {
        return new UserInfoLogAddingSimpleRequestDebugStringBuilder(this.currentAuthWebResolver);
    }

    @Bean
    public AddableExceptionResponseLogger exceptionResponseLogger() {
        return new CompositeWebClientRequestExceptionResponseLogger(this.webClientRequestWebResolver(), this.requestDebugStringBuilder()).with(SeveritedException.class, (request, e) -> e.isError() ? ExceptionResponseLogger.LogLevel.ERROR : ExceptionResponseLogger.LogLevel.DEBUG).withDebug(InsufficientlyAuthenticatedException.class).withDebug(InsufficientAuthenticationException.class).withDebug(BadLoginCredentialsException.class).withDebug(UserIsNotPersonAuthenticationException.class).withDebug(ExternalAuthenticationCancelException.class).withError(ExternallyAuthenticatedUserIsNotInLocalException.class).withDebug(AccessDeniedException.class).withDebug(RateLimitExceededException.class).withDebug(FeatureNotEnabledException.class).withDebug(AgreementConfirmationException.class).withError(IncorrectLuceneQueryException.class).withDebug(HttpRequestMethodNotSupportedException.class).withDebug(FieldsNotResolvableException.class).withDebug(MethodArgumentNotValidException.class).withDebug(ConstraintViolationException.class).withDebug(AppserverInformativeResponseException.class).with(ItemNotFoundException.class, (request, e) -> this.botFinder().isProbablyHuman(request) ? ExceptionResponseLogger.LogLevel.ERROR : ExceptionResponseLogger.LogLevel.DEBUG).with(EmptyResultDataAccessException.class, (request, e) -> this.botFinder().isProbablyHuman(request) ? ExceptionResponseLogger.LogLevel.ERROR : ExceptionResponseLogger.LogLevel.DEBUG).withError(HttpSessionRequiredException.class).with(IOException.class, (request, e) -> "ClientAbortException".equals(e.getClass().getSimpleName()) ? ExceptionResponseLogger.LogLevel.DEBUG : ExceptionResponseLogger.LogLevel.ERROR).withUnwrapping(TypeMismatchException.class, ExceptionResponseLogger.LogLevel.ERROR).withUnwrapping(ConversionFailedException.class, ExceptionResponseLogger.LogLevel.ERROR).with(Exception.class, (request, e) -> {
            if (AnnotationUtil.findClassLevelAnnotation((Object)e, LogOnlyAsDebug.class).isPresent()) {
                return ExceptionResponseLogger.LogLevel.DEBUG;
            }
            return e.getMessage() != null && e.getMessage().contains("message.warning") ? ExceptionResponseLogger.LogLevel.DEBUG : ExceptionResponseLogger.LogLevel.ERROR;
        });
    }

    @Bean
    public Saver<WebClientRequest> clientRequestSaver() {
        return new ClientSessionSavingClientRequestSaver(this.clientSessionRepository(), this.internalIpResolver);
    }

    @Bean
    public ApplicationListener<HttpSessionDestroyedEvent> sessionDestroyedEventListener() {
        return new SessionDestroyedEventListener(this.clientSessionRepository());
    }

    @Bean
    public ClientSessionRepository clientSessionRepository() {
        return new CombinedClientSessionRepository((ClientSessionRepository)new InMemoryClientSessionRepository(), this.sessionClientSaver());
    }

    @Bean
    public Saver<ClientSession> sessionClientSaver() {
        return ProgrammaticalTransactionalSaver.create((Saver)new PreConvertingSaver((Converter)new ClientSessionToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(ClientSessionEntity.class, this.entityManager))), (PlatformTransactionManager)this.transactionManager);
    }

    @Bean
    public BotFinder botFinder() {
        return new CompositeBotFinder((BotProbabilityProvider)new UserAgentBasedBotFinder(ListUtil.union((Collection[])new Collection[]{this.evidedUserBotUserAgentRegistrations(), this.anonymousBotUserAgentMatchers()})), (BotProbabilityProvider)new IpBasedBotFinder(), (BotProbabilityProvider)new UserCheckingBotFinder(this.clientSessionRepository()));
    }

    @Bean
    public List<EvidedUserUserAgentRegistration> evidedUserBotUserAgentRegistrations() {
        return List.of(new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"UptimeRobot"), department -> this.userByUsernameLoader.get("uptimerobot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"Verbis/"), department -> this.userByUsernameLoader.get("verbisapplication")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"AhrefsBot"), department -> this.userByUsernameLoader.get("ahrefsbot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"Applebot"), department -> this.userByUsernameLoader.get("applelebot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"bingbot"), department -> this.userByUsernameLoader.get("bingbot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"Googlebot"), department -> this.userByUsernameLoader.get("googlebot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"MJ12bot"), department -> this.userByUsernameLoader.get("mj12bot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"PetalBot"), department -> this.userByUsernameLoader.get("petalbot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"SemrushBot"), department -> this.userByUsernameLoader.get("semrushbot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"SeznamBot"), department -> this.userByUsernameLoader.get("seznambot")), new EvidedUserUserAgentRegistration((UserAgentMatcher)InfixUserAgentMatcher.ofSingle((String)"YandexBot"), department -> this.userByUsernameLoader.get("yandexbot")));
    }

    @Bean
    public List<UserAgentMatcher> anonymousBotUserAgentMatchers() {
        return List.of(InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"UptimeRobot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"Verbis"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"googlebot"), ExactUserAgentMatcher.ofSingle((String)"revolt"), ExactUserAgentMatcher.ofSingle((String)"NeohapsisLab"), ExactUserAgentMatcher.ofSingle((String)"Mediapartners-Google"), ExactUserAgentMatcher.ofSingle((String)"Phantom.js bot"), ExactUserAgentMatcher.ofSingle((String)"Morfeus Fucking Scanner"), ExactUserAgentMatcher.ofSingle((String)"betaBot"), ExactUserAgentMatcher.ofSingle((String)"the beast"), ExactUserAgentMatcher.ofSingle((String)"shellshock-scan"), ExactUserAgentMatcher.ofSingle((String)"mifetcher/1.0"), ExactUserAgentMatcher.ofSingle((String)"ContextAd Bot 1.0"), ExactUserAgentMatcher.ofSingle((String)"Jyxobot/1"), ExactUserAgentMatcher.ofSingle((String)"Seznam.cz open proxy check bot"), ExactUserAgentMatcher.ofSingle((String)"listicka"), ExactUserAgentMatcher.ofSingle((String)"Ruby"), ExactUserAgentMatcher.ofSingle((String)"YisouSpider"), ExactUserAgentMatcher.ofSingle((String)"LinkSaver/2.0"), ExactUserAgentMatcher.ofSingle((String)"LinkParser/2.0"), ExactUserAgentMatcher.ofSingle((String)"Dragonfly File Reader"), ExactUserAgentMatcher.ofSingle((String)"netscan.gtisc.gatech.edu"), ExactUserAgentMatcher.ofSingle((String)"BOT/0.1 (BOT for JCE)"), ExactUserAgentMatcher.ofSingle((String)"Twitterbot/1.0"), ExactUserAgentMatcher.ofSingle((String)"ltx71 - (http://ltx71.com/)"), ExactUserAgentMatcher.ofSingle((String)"Zend_Http_Client"), ExactUserAgentMatcher.ofSingle((String)"eBot/1.0 (+http://alfa.elchron.cz)"), ExactUserAgentMatcher.ofSingle((String)"bitlybot/2.0"), ExactUserAgentMatcher.ofSingle((String)"iZSearch.com"), ExactUserAgentMatcher.ofSingle((String)"Mozilla/5.0 (X11; U; en-US; Fortinet"), ExactUserAgentMatcher.ofSingle((String)"Mozilla/5.0 (compatible; worldwebheritage.org/1.0; +crawl@worldwebheritage.org)"), ExactUserAgentMatcher.ofSingle((String)"ADmantX Platform Semantic Analyzer - ADmantX Inc. - www.admantx.com - support@admantx.com"), ExactUserAgentMatcher.ofSingle((String)"Mozilla/3.0 (compatible; Indy Library)"), ExactUserAgentMatcher.ofSingle((String)"Mediatoolkitbot (complaints@mediatoolkit.com)"), ExactUserAgentMatcher.ofSingle((String)"Mozilla/5.0 (compatible; DataForSeoBot/1.0; +https://dataforseo.com/dataforseo-bot)"), ExactUserAgentMatcher.ofSingle((String)"Hello, world"), ExactUserAgentMatcher.ofSingle((String)"https://gdnplus.com:Gather Analyze Provide."), ExactUserAgentMatcher.ofSingle((String)"Linux Gnu (cow)"), ExactUserAgentMatcher.ofSingle((String)"Auto Spider 1.0"), ExactUserAgentMatcher.ofSingle((String)"Hello World"), ExactUserAgentMatcher.ofSingle((String)"DavClnt"), ExactUserAgentMatcher.ofSingle((String)"Chrome Privacy Preserving Prefetch Proxy"), ExactUserAgentMatcher.ofSingle((String)"Keybot Translation-Search-Machine"), ExactUserAgentMatcher.ofSingle((String)"wp_is_mobile"), PrefixUserAgentMatcher.ofSingle((String)"python-requests/"), PrefixUserAgentMatcher.ofSingle((String)"Mozilla/5.0 zgrab/"), PrefixUserAgentMatcher.ofSingle((String)"webprosbot/"), PrefixUserAgentMatcher.ofSingle((String)"NetSystemsResearch"), PrefixUserAgentMatcher.ofSingle((String)"curl/"), PrefixUserAgentMatcher.ofSingle((String)"okhttp/"), PrefixUserAgentMatcher.ofSingle((String)"Go-http-client/"), PrefixUserAgentMatcher.ofSingle((String)"gbrmss/"), PrefixUserAgentMatcher.ofSingle((String)"Mozilla/5.0 (compatible; DotBot/"), PrefixUserAgentMatcher.ofSingle((String)"Mozilla/5.0 (compatible; Adsbot/"), PrefixUserAgentMatcher.ofSingle((String)"Sogou web spider"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"bot.htm"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"surveybot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"yahoo.com"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"seznambot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"fulltext.sblog.cz"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"baiduspider"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"apache-httpclient"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"check_http"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"yandexbot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"java/"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"ezooms"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"exabot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"ahrefsbot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"yandex"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"crawler"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"python-openid"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"python-urllib"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"cliqz.com"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"microsoft url control"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"ia_archiver"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"libwww-perl"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"feedreader"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"pycurl"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"openstat"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"xpymep.exe"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"bot.php"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"mj12bot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"wotbox"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"pagesinventory"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"ahrefsbot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"compspy.com"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"windows-rss-platform"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"bubing"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"zmeu"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"seznam screenshot-generator"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"facebook.com"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"masscan"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"niki-bot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"www.checkprivacy"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"thefuckie"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"nutch"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"www.feedly.com"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"addthis.com"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"proxy gear pro"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"nikto"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"mj12bot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"prtg network monitor"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"spbot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"gigablastopensource"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"metaspider"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"publiclibraryarchive"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"visionutils"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"feedfetcher-google"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"/usr/bin/"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"wget/"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"qwantify"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"reactornetty"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"semrushbot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"verbis/"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"bingpreview"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"petalbot"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"postmanruntime"), InfixUserAgentMatcher.ofSingleCaseInsensitive((String)"facebookexternalhit"), InfixUserAgentMatcher.ofSingle((String)"aiohttp"), InfixUserAgentMatcher.ofSingle((String)"TurnitinBot"), InfixUserAgentMatcher.ofSingle((String)"Turnitin"), InfixUserAgentMatcher.ofSingle((String)"J2ME/MIDP; Opera Mini"), InfixUserAgentMatcher.ofSingle((String)"CensysInspect"), InfixUserAgentMatcher.ofSingle((String)"InternetMeasurement"), InfixUserAgentMatcher.ofSingle((String)"Mail.RU_Bot"), InfixUserAgentMatcher.ofSingle((String)"research@pdrlabs.net"), InfixUserAgentMatcher.ofSingle((String)"FirmoGraph"), InfixUserAgentMatcher.ofSingle((String)"panscient.com"), InfixUserAgentMatcher.ofSingle((String)"AlexaMediaPlayer"), InfixUserAgentMatcher.ofSingle((String)"serpstatbot"), InfixUserAgentMatcher.ofSingle((String)"MiniRedir"), InfixUserAgentMatcher.ofSingle((String)"SearchHelper"), InfixUserAgentMatcher.ofSingle((String)"Amazonbot"), InfixUserAgentMatcher.ofSingle((String)"OpenVAS"));
    }

    @Bean
    public CompositeCurrentPageDialogsResolver currentPageDialogsResolver() {
        return new CompositeCurrentPageDialogsResolver();
    }

    @Bean
    public ClientSessionVerifierApiController clientSessionVerifierApiController() {
        return new ClientSessionVerifierApiController(this.webClientRequestWebResolver(), this.clientSessionByClientRequestUpdater());
    }

    @Bean
    public ClientSessionByClientRequestUpdater clientSessionByClientRequestUpdater() {
        return new ClientSessionByClientRequestUpdater(this.clientSessionRepository(), this.botFinder());
    }

    @ConstructorProperties(value={"currentAuthWebResolver", "currentDepartmentWebResolver", "traceIdRepository", "internalIpResolver", "appserverProxyController", "dbConsoleProxyController", "jobRunrDashboardProxyController", "objectMapper", "objectUrlIdResolver", "userFriendlyExceptionTextResolver", "formByFormObjectFactory", "currentDepartmentProvider", "applicationContext", "userByUsernameLoader", "validator", "entityManager", "transactionManager"})
    @Generated
    public WebConfig(@NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull WebResolver<Department> currentDepartmentWebResolver, @NonNull Provider<UUID> traceIdRepository, @NonNull IpAddressInRangeResolver internalIpResolver, @NonNull ServletWrappingController appserverProxyController, @NonNull ServletWrappingController dbConsoleProxyController, @NonNull ServletWrappingController jobRunrDashboardProxyController, @NonNull ObjectMapper objectMapper, @NonNull ObjectUrlIdResolver objectUrlIdResolver, @NonNull UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver, @NonNull FormByFormObjectFactory formByFormObjectFactory, @NonNull Provider<Department> currentDepartmentProvider, @NonNull BeanFactory applicationContext, @NonNull UserByUsernameLoader userByUsernameLoader, @NonNull Validator validator, @NonNull EntityManager entityManager, @NonNull PlatformTransactionManager transactionManager) {
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentWebResolver, "currentDepartmentWebResolver is marked non-null but is null");
        Objects.requireNonNull(traceIdRepository, "traceIdRepository is marked non-null but is null");
        Objects.requireNonNull(internalIpResolver, "internalIpResolver is marked non-null but is null");
        Objects.requireNonNull(appserverProxyController, "appserverProxyController is marked non-null but is null");
        Objects.requireNonNull(dbConsoleProxyController, "dbConsoleProxyController is marked non-null but is null");
        Objects.requireNonNull(jobRunrDashboardProxyController, "jobRunrDashboardProxyController is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(objectUrlIdResolver, "objectUrlIdResolver is marked non-null but is null");
        Objects.requireNonNull(userFriendlyExceptionTextResolver, "userFriendlyExceptionTextResolver is marked non-null but is null");
        Objects.requireNonNull(formByFormObjectFactory, "formByFormObjectFactory is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(userByUsernameLoader, "userByUsernameLoader is marked non-null but is null");
        Objects.requireNonNull(validator, "validator is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(transactionManager, "transactionManager is marked non-null but is null");
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.currentDepartmentWebResolver = currentDepartmentWebResolver;
        this.traceIdRepository = traceIdRepository;
        this.internalIpResolver = internalIpResolver;
        this.appserverProxyController = appserverProxyController;
        this.dbConsoleProxyController = dbConsoleProxyController;
        this.jobRunrDashboardProxyController = jobRunrDashboardProxyController;
        this.objectMapper = objectMapper;
        this.objectUrlIdResolver = objectUrlIdResolver;
        this.userFriendlyExceptionTextResolver = userFriendlyExceptionTextResolver;
        this.formByFormObjectFactory = formByFormObjectFactory;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.applicationContext = applicationContext;
        this.userByUsernameLoader = userByUsernameLoader;
        this.validator = validator;
        this.entityManager = entityManager;
        this.transactionManager = transactionManager;
    }
}

