/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.LabeledValuesGroup;
import cz.kpsys.portaro.commons.object.filter.EqualsPredicate;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.core.editor.AcceptableValuesProviderLoaderDispatcher;
import cz.kpsys.portaro.core.editor.DispatchingValueEditorByDatatypeLoader;
import cz.kpsys.portaro.core.editor.RecordValueEditorByDatatypeResolver;
import cz.kpsys.portaro.datatype.DatatypableStringConverter;
import cz.kpsys.portaro.datatype.DatatypableStringConverterImpl;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.ExemplarConstants;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWay;
import cz.kpsys.portaro.exemplar.customvalue.CustomValue;
import cz.kpsys.portaro.exemplar.exchangeset.ExchangeExemplarSet;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatus;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.file.FileConstants;
import cz.kpsys.portaro.file.filecategory.FileCategory;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeLoader;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeResolver;
import cz.kpsys.portaro.form.editor.resolver.ValueEditorByPropertyResolver;
import cz.kpsys.portaro.form.editor.resolver.ValueEditorByPropertyResolverByByDatatypeResolver;
import cz.kpsys.portaro.form.editor.resolver.ValueEditorByPropertyResolverByExtractingFromEditedProperty;
import cz.kpsys.portaro.form.editor.resolver.ValueEditorByPropertyResolverComposite;
import cz.kpsys.portaro.form.editor2.AnnotationBasedEditedPropertyResolver;
import cz.kpsys.portaro.form.editor2.AnnotationsAwareValueEditorResolver;
import cz.kpsys.portaro.form.editor2.FieldsWhiteListResolver;
import cz.kpsys.portaro.form.editor2.FormObjectPrototypeFactory;
import cz.kpsys.portaro.form.editor2.acceptableroot.AcceptableRootValueEditorResolver;
import cz.kpsys.portaro.form.editor2.accessnumber.AccessNumberValueEditorResolver;
import cz.kpsys.portaro.form.editor2.bool.BooleanValueEditorResolver;
import cz.kpsys.portaro.form.editor2.date.DateValueEditorResolver;
import cz.kpsys.portaro.form.editor2.html.HtmlValueEditorResolver;
import cz.kpsys.portaro.form.editor2.list.ListValueEditorResolver;
import cz.kpsys.portaro.form.editor2.multipleacceptable.MultipleAcceptableValueEditorResolver;
import cz.kpsys.portaro.form.editor2.number.NumberValueEditorResolver;
import cz.kpsys.portaro.form.editor2.object.ObjectValueEditorResolver;
import cz.kpsys.portaro.form.editor2.password.PasswordValueEditorResolver;
import cz.kpsys.portaro.form.editor2.range.RangeValueEditorResolver;
import cz.kpsys.portaro.form.editor2.scannabletext.ScannableTextValueEditorResolver;
import cz.kpsys.portaro.form.editor2.searchoredit.SearchOrEditValueEditorResolver;
import cz.kpsys.portaro.form.editor2.signature.SignatureValueEditorResolver;
import cz.kpsys.portaro.form.editor2.singleacceptable.SingleAcceptableValueEditorResolver;
import cz.kpsys.portaro.form.editor2.text.TextValueEditorResolver;
import cz.kpsys.portaro.form.editor2.year.YearValueEditorResolver;
import cz.kpsys.portaro.form.form.AnnotationFormByFormObjectFactory;
import cz.kpsys.portaro.form.form.FormByFormObjectFactory;
import cz.kpsys.portaro.form.property.CompositeEditedPropertyResolver;
import cz.kpsys.portaro.form.property.EditedPropertyResolver;
import cz.kpsys.portaro.form.property.StaticEditedPropertyResolver;
import cz.kpsys.portaro.form.property.ValueEditorFromTypeAnnotationsResolver;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.loan.extern.ExternalLoanService;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.object.JpaPhraseEntityLoader;
import cz.kpsys.portaro.object.PhraseEntity;
import cz.kpsys.portaro.object.PhraseEntityLoader;
import cz.kpsys.portaro.object.SpringDbAcceptableValuesGroupDefValLoader;
import cz.kpsys.portaro.record.ForeignDatabase;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.lucene.FacetKeyIdentified;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.UserConstants;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class ValueEditorConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValueEditorConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ConversionService conversionService;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final Codebook<Fond, Integer> authorityFondLoader;
    @NonNull
    private final AllValuesProvider<Fond> documentFondLoader;
    @NonNull
    private final AllValuesProvider<Fond> allowedAuthorityFondsProvider;
    @NonNull
    private final AllValuesProvider<Fond> allowedDocumentFondsProvider;
    @NonNull
    private final AllValuesProvider<Location> locationLoader;
    @NonNull
    private final AllValuesProvider<Department> departmentLoader;
    @NonNull
    private final ByIdLoadable<LabeledValuesGroup<LabeledIdentified<String>, String>, Object> iniAcceptableValuesGroupLoader;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final AllValuesProvider<FileCategory> fileCategoryLoader;
    @NonNull
    private final AllValuesProvider<FileCategory> allowedFileCategoryLoader;
    @NonNull
    private final AllValuesProvider<SearchField> searchFieldLoader;
    @NonNull
    private final ApplicationContext applicationContext;

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public DatatypableStringConverter datatypableStringConverter() {
        return new DatatypableStringConverterImpl(this.conversionService, this.typesByDatatypes(), this.defValAcceptableValuesGroupLoader(), this.iniAcceptableValuesGroupLoader);
    }

    @Bean
    public Map<ScalarDatatype, Class<?>> typesByDatatypes() {
        HashMap map = new HashMap();
        map.put(CoreConstants.Datatype.TEXT, String.class);
        map.put(CoreConstants.Datatype.NUMBER, Double.class);
        map.put(CoreConstants.Datatype.BOOLEAN, Boolean.class);
        map.put(CoreConstants.Datatype.URL, String.class);
        map.put(CoreConstants.Datatype.DATE, Date.class);
        map.put(CoreConstants.Datatype.DATETIME, Date.class);
        map.put(CoreConstants.Datatype.YEAR, Integer.class);
        map.put(CoreConstants.Datatype.DEPARTMENT, Department.class);
        map.put(RecordConstants.Datatype.FOND, Fond.class);
        map.put(RecordConstants.Datatype.DOCUMENT_FOND, Fond.class);
        map.put(RecordConstants.Datatype.AUTHORITY_FOND, Fond.class);
        map.put(RecordConstants.Datatype.RECORD_STATUS, RecordStatus.class);
        map.put(RecordConstants.Datatype.EXEMPLAR_STATUS, ExemplarStatus.class);
        map.put(ExemplarConstants.Datatype.CUSTOM_VALUE, CustomValue.class);
        map.put(ExemplarConstants.Datatype.LOCATION, Location.class);
        map.put(ExemplarConstants.Datatype.EXCHANGE_EXEMPLAR_SET, ExchangeExemplarSet.class);
        map.put(UserConstants.Datatype.READER_CATEGORY, ReaderCategory.class);
        map.put(RecordConstants.Datatype.THEMATIC_GROUP, ThematicGroup.class);
        map.put(RecordConstants.Datatype.ACQUISITION_WAY, AcquisitionWay.class);
        map.put(LoanConstants.Datatype.LOAN_CATEGORY, LoanCategory.class);
        map.put(CoreConstants.Datatype.DATABASE, ForeignDatabase.class);
        map.put(FileConstants.Datatype.FILE_CATEGORY, FileCategory.class);
        map.put(CoreConstants.Datatype.FACET_VALUE, FacetKeyIdentified.class);
        map.put(CoreConstants.Datatype.SEARCH_FIELD, SearchField.class);
        map.put(LoanConstants.Datatype.EXTERNAL_LOAN_SERVICE, ExternalLoanService.class);
        return map;
    }

    @Bean
    public ByIdLoadable<LabeledValuesGroup<LabeledIdentified<String>, String>, Object> defValAcceptableValuesGroupLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbAcceptableValuesGroupDefValLoader(this.jdbcTemplate, this.queryFactory)).staticCached(LabeledValuesGroup.class.getSimpleName()).fallbackWhenNotFoundById(id -> {
            log.warn("V tabulce {} chybi skupina s {} = {}", new Object[]{"def_val", "kod_val", id});
            return new LabeledValuesGroup(id);
        }).build();
    }

    @Bean
    public PhraseEntityLoader phraseEntityLoader() {
        return new JpaPhraseEntityLoader((JpaRepository)new SimpleJpaRepository(PhraseEntity.class, this.entityManager));
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public ValueEditorByDatatypeLoader valueEditorByDatatypeLoader() {
        return new DispatchingValueEditorByDatatypeLoader((ByIdLoadable)this.acceptableValuesProviderLoader(), (ValueEditorByDatatypeResolver)RecordValueEditorByDatatypeResolver.createWithStandardBehaviour((ByIdLoadable)this.fondLoader));
    }

    @Bean
    public AcceptableValuesProviderLoaderDispatcher acceptableValuesProviderLoader() {
        return new AcceptableValuesProviderLoaderDispatcher(this.allowedDatatypeToAllValuesProviderMap(), this.defValAcceptableValuesGroupLoader(), this.iniAcceptableValuesGroupLoader);
    }

    @Bean
    public LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allowedDatatypeToAllValuesProviderMap() {
        LinkedHashMap map = new LinkedHashMap();
        map.put((Predicate<String>)new EqualsPredicate((Object)RecordConstants.Datatype.DOCUMENT_FOND.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.allowedDocumentFondsProvider);
        map.put((Predicate<String>)new EqualsPredicate((Object)RecordConstants.Datatype.AUTHORITY_FOND.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.allowedAuthorityFondsProvider);
        map.put((Predicate<String>)new EqualsPredicate((Object)RecordConstants.Datatype.RECORD_STATUS.getName()), (AllValuesProvider<LabeledIdentified<?>>)RecordStatus.CODEBOOK);
        map.put((Predicate<String>)new EqualsPredicate((Object)CoreConstants.Datatype.DEPARTMENT.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.departmentLoader);
        map.put((Predicate<String>)new EqualsPredicate((Object)ExemplarConstants.Datatype.LOCATION.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.locationLoader);
        map.put((Predicate<String>)new EqualsPredicate((Object)FileConstants.Datatype.FILE_CATEGORY.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.allowedFileCategoryLoader);
        map.put((Predicate<String>)new EqualsPredicate((Object)CoreConstants.Datatype.SEARCH_FIELD.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.searchFieldLoader);
        map.put((Predicate<String>)new EqualsPredicate((Object)LoanConstants.Datatype.EXTERNAL_LOAN_SERVICE.getName()), (AllValuesProvider<LabeledIdentified<?>>)ExternalLoanService.CODEBOOK);
        return map;
    }

    @Bean
    public LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap() {
        LinkedHashMap map = new LinkedHashMap(this.allowedDatatypeToAllValuesProviderMap());
        map.put((Predicate<String>)new EqualsPredicate((Object)RecordConstants.Datatype.DOCUMENT_FOND.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.documentFondLoader);
        map.put((Predicate<String>)new EqualsPredicate((Object)RecordConstants.Datatype.AUTHORITY_FOND.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.authorityFondLoader);
        map.put((Predicate<String>)new EqualsPredicate((Object)CoreConstants.Datatype.SEARCH_FIELD.getName()), (AllValuesProvider<LabeledIdentified<?>>)ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.searchFieldLoader, searchField -> {
            MultiText text = MultiText.ofTexts((String)"{} ({})", (Text[])new Text[]{searchField.getText(), Texts.ofNative((String)searchField.getSourceDescription())});
            return new LabeledId((Serializable)((Object)((String)searchField.getId())), (Text)text);
        }));
        map.put((Predicate<String>)new EqualsPredicate((Object)FileConstants.Datatype.FILE_CATEGORY.getName()), (AllValuesProvider<LabeledIdentified<?>>)this.fileCategoryLoader);
        return map;
    }

    @Bean
    public FieldsWhiteListResolver fieldsWhiteListResolver() {
        return new FieldsWhiteListResolver((BeanFactory)this.applicationContext);
    }

    @Bean
    public List<AnnotationsAwareValueEditorResolver> valueEditorAnnotationsResolvers() {
        return new ArrayList<AnnotationsAwareValueEditorResolver>();
    }

    @Bean
    public AnnotationBasedEditedPropertyResolver annotationBasedEditedPropertyResolver() {
        return new AnnotationBasedEditedPropertyResolver(this.valueEditorAnnotationsResolvers());
    }

    @Bean
    public ValueEditorByPropertyResolver valueEditorByPropertyResolver() {
        return new ValueEditorByPropertyResolverComposite(List.of(new ValueEditorByPropertyResolverByExtractingFromEditedProperty(), new ValueEditorByPropertyResolverByByDatatypeResolver(this.valueEditorByDatatypeLoader())));
    }

    @Bean
    public FormByFormObjectFactory formByFormObjectFactory() {
        StaticEditedPropertyResolver staticEditedPropertyResolver = new StaticEditedPropertyResolver(this.valueEditorByPropertyResolver());
        CompositeEditedPropertyResolver compositeEditedPropertyResolver = new CompositeEditedPropertyResolver(List.of(staticEditedPropertyResolver, this.annotationBasedEditedPropertyResolver()));
        return new AnnotationFormByFormObjectFactory(this.fieldsWhiteListResolver(), (EditedPropertyResolver)compositeEditedPropertyResolver, (BeanFactory)this.applicationContext);
    }

    @Bean
    public FormObjectPrototypeFactory formObjectPrototypeFactory() {
        return new FormObjectPrototypeFactory((BeanFactory)this.applicationContext);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initializeValueEditorAnnotationsResolvers() {
        this.valueEditorAnnotationsResolvers().addAll(List.of(new BooleanValueEditorResolver((BeanFactory)this.applicationContext), new TextValueEditorResolver((BeanFactory)this.applicationContext), new DateValueEditorResolver(), new AcceptableRootValueEditorResolver((BeanFactory)this.applicationContext), new SingleAcceptableValueEditorResolver((BeanFactory)this.applicationContext), new MultipleAcceptableValueEditorResolver((BeanFactory)this.applicationContext), new SearchOrEditValueEditorResolver((BeanFactory)this.applicationContext), new ScannableTextValueEditorResolver((BeanFactory)this.applicationContext), new AccessNumberValueEditorResolver((BeanFactory)this.applicationContext), new SignatureValueEditorResolver((BeanFactory)this.applicationContext), new NumberValueEditorResolver(), new YearValueEditorResolver(), new RangeValueEditorResolver((BeanFactory)this.applicationContext), new HtmlValueEditorResolver(), new ListValueEditorResolver((ValueEditorFromTypeAnnotationsResolver)this.annotationBasedEditedPropertyResolver(), this.formObjectPrototypeFactory(), (BeanFactory)this.applicationContext), new ObjectValueEditorResolver(this.formByFormObjectFactory(), this.formObjectPrototypeFactory()), new PasswordValueEditorResolver((BeanFactory)this.applicationContext)));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "codebookLoaderBuilderFactory", "conversionService", "fondLoader", "authorityFondLoader", "documentFondLoader", "allowedAuthorityFondsProvider", "allowedDocumentFondsProvider", "locationLoader", "departmentLoader", "iniAcceptableValuesGroupLoader", "entityManager", "fileCategoryLoader", "allowedFileCategoryLoader", "searchFieldLoader", "applicationContext"})
    @Generated
    public ValueEditorConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ConversionService conversionService, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull Codebook<Fond, Integer> authorityFondLoader, @NonNull AllValuesProvider<Fond> documentFondLoader, @NonNull AllValuesProvider<Fond> allowedAuthorityFondsProvider, @NonNull AllValuesProvider<Fond> allowedDocumentFondsProvider, @NonNull AllValuesProvider<Location> locationLoader, @NonNull AllValuesProvider<Department> departmentLoader, @NonNull ByIdLoadable<LabeledValuesGroup<LabeledIdentified<String>, String>, Object> iniAcceptableValuesGroupLoader, @NonNull EntityManager entityManager, @NonNull AllValuesProvider<FileCategory> fileCategoryLoader, @NonNull AllValuesProvider<FileCategory> allowedFileCategoryLoader, @NonNull AllValuesProvider<SearchField> searchFieldLoader, @NonNull ApplicationContext applicationContext) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(authorityFondLoader, "authorityFondLoader is marked non-null but is null");
        Objects.requireNonNull(documentFondLoader, "documentFondLoader is marked non-null but is null");
        Objects.requireNonNull(allowedAuthorityFondsProvider, "allowedAuthorityFondsProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDocumentFondsProvider, "allowedDocumentFondsProvider is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(iniAcceptableValuesGroupLoader, "iniAcceptableValuesGroupLoader is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(fileCategoryLoader, "fileCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(allowedFileCategoryLoader, "allowedFileCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(searchFieldLoader, "searchFieldLoader is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.conversionService = conversionService;
        this.fondLoader = fondLoader;
        this.authorityFondLoader = authorityFondLoader;
        this.documentFondLoader = documentFondLoader;
        this.allowedAuthorityFondsProvider = allowedAuthorityFondsProvider;
        this.allowedDocumentFondsProvider = allowedDocumentFondsProvider;
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.iniAcceptableValuesGroupLoader = iniAcceptableValuesGroupLoader;
        this.entityManager = entityManager;
        this.fileCategoryLoader = fileCategoryLoader;
        this.allowedFileCategoryLoader = allowedFileCategoryLoader;
        this.searchFieldLoader = searchFieldLoader;
        this.applicationContext = applicationContext;
    }
}

