/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.UserAuthenticationFunctions;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.department.AuthContextualDepartmentsLoader;
import cz.kpsys.portaro.auth.department.BypassableCurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoaderByUserDepartmentsLoader;
import cz.kpsys.portaro.auth.department.FamilyModeAuthContextualDepartmentsLoader;
import cz.kpsys.portaro.barcode.BarCodeValidatorContextualProvider;
import cz.kpsys.portaro.commons.barcode.BarCodeType;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.barcode.BarCodeValidatorByBarCodeTypeProvider;
import cz.kpsys.portaro.commons.barcode.ValidLengthBarCodeValidator;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.DynamicallyCachedAllByIdsLoader;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.cache.SavingDynamicallyCachedAllByIdsLoader;
import cz.kpsys.portaro.commons.cache.StaticCache;
import cz.kpsys.portaro.commons.cache.StaticCacheFactory;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.json.ByStringConverterJsonDeserializer;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.filter.EqualsPredicate;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.InstantiingLabeledIdentifiableLoaderSpringDb;
import cz.kpsys.portaro.database.JpaAllValuesProvider;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.sec.BypassableCurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.record.sec.CachingUserEditableFondsLoader;
import cz.kpsys.portaro.record.sec.CurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.record.sec.CurrentAuthEditableFondsLoaderByUserFondsLoader;
import cz.kpsys.portaro.record.sec.UserEditableFondsLoader;
import cz.kpsys.portaro.record.sec.UserEditableFondsLoaderByPermissions;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.permission.ActionPermissionAccessor;
import cz.kpsys.portaro.security.permission.ActionPermissionAccessorDelegating;
import cz.kpsys.portaro.security.permission.ConditionallyPermittingActionPermissionAccessor;
import cz.kpsys.portaro.security.permission.DefaultPermissionEntity;
import cz.kpsys.portaro.security.permission.UserPermissionEntity;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.AllByIdsDelegatingUserLoader;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.CachingUserIdPageSearchLoader;
import cz.kpsys.portaro.user.NonEvidedCurrentAuthenticationUserLoader;
import cz.kpsys.portaro.user.NonEvidedDelegatingBasicUserLoader;
import cz.kpsys.portaro.user.NonEvidedDelegatingUserLoader;
import cz.kpsys.portaro.user.RoleNamesResolver;
import cz.kpsys.portaro.user.SearchingMultiTryingSuUserIdProvider;
import cz.kpsys.portaro.user.SearchingUserByUsernameLoader;
import cz.kpsys.portaro.user.SpringDbAllUsersByIdsLoader;
import cz.kpsys.portaro.user.SpringDbBasicUserLoader;
import cz.kpsys.portaro.user.SpringDbNetIdLoader;
import cz.kpsys.portaro.user.SpringDbUserIdSearchLoader;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserByUsernameLoader;
import cz.kpsys.portaro.user.UserConstants;
import cz.kpsys.portaro.user.UserDepartmentsLoader;
import cz.kpsys.portaro.user.UserFunctions;
import cz.kpsys.portaro.user.UserLoader;
import cz.kpsys.portaro.user.UserLoaderDispatching;
import cz.kpsys.portaro.user.UserSearchRoleType;
import cz.kpsys.portaro.user.UserSettingKeys;
import cz.kpsys.portaro.user.UsernameSearchingUserIdProvider;
import cz.kpsys.portaro.user.contact.BasicContactManager;
import cz.kpsys.portaro.user.contact.ContactLoader;
import cz.kpsys.portaro.user.contact.ContactManager;
import cz.kpsys.portaro.user.contact.ContactSource;
import cz.kpsys.portaro.user.contact.ContactType;
import cz.kpsys.portaro.user.contact.SpringDbContactLoader;
import cz.kpsys.portaro.user.contact.SpringDbUserAddressLoader;
import cz.kpsys.portaro.user.contact.UserAddressLoader;
import cz.kpsys.portaro.user.entity.EntitiesToUsersConverter;
import cz.kpsys.portaro.user.relation.DelegatingUserRelationsHelper;
import cz.kpsys.portaro.user.relation.JpaUserRelationLoader;
import cz.kpsys.portaro.user.relation.RepresentableUserLoader;
import cz.kpsys.portaro.user.relation.RepresentableUserLoaderByUserRelationLoader;
import cz.kpsys.portaro.user.relation.UserRelation;
import cz.kpsys.portaro.user.relation.UserRelationEntity;
import cz.kpsys.portaro.user.relation.UserRelationLoader;
import cz.kpsys.portaro.user.relation.UserRelationsHelper;
import cz.kpsys.portaro.user.role.editor.LibrarianGroup;
import cz.kpsys.portaro.user.role.reader.EntityToReaderCategoryConverter;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import cz.kpsys.portaro.user.role.reader.ReaderCategoryEntity;
import cz.kpsys.portaro.user.sec.CachingUserEditableDepartmentsLoader;
import cz.kpsys.portaro.user.sec.CachingUserReadableDepartmentsLoader;
import cz.kpsys.portaro.user.sec.SpringDbUserDepartmentsLoader;
import cz.kpsys.portaro.user.sec.UserDepartmentsByUserIdsLoader;
import cz.kpsys.portaro.user.sec.UserDepartmentsLoaderSuEditLevelChecking;
import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.format.FormatterRegistry;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class UserConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final StaticCacheFactory staticCacheFactory;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final FormatterRegistry conversionService;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final HttpServletRequest request;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final Provider<Fond> desiderataFondProvider;
    @NonNull
    private final LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allowedDatatypeToAllValuesProviderMap;
    @NonNull
    private final LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final BarCodeValidatorByBarCodeTypeProvider barCodeValidatorByBarCodeTypeProvider;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;

    @Bean
    public Codebook<ReaderCategory, String> readerCategoryLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(ReaderCategoryEntity.class, "id").convertedEachBy((Converter)new EntityToReaderCategoryConverter()).staticCached(ReaderCategory.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<LibrarianGroup, Integer> librarianGroupLoader() {
        InstantiingLabeledIdentifiableLoaderSpringDb loader = new InstantiingLabeledIdentifiableLoaderSpringDb(this.jdbcTemplate, this.queryFactory, LibrarianGroup.class, "def_group", "id_group", "nazev", "id_group");
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)loader).staticCached(LibrarianGroup.class.getSimpleName()).build();
    }

    @Bean
    public ContactLoader contactLoader() {
        return new SpringDbContactLoader(this.jdbcTemplate, this.queryFactory, ContactType.CODEBOOK, ContactSource.CODEBOOK);
    }

    @Bean
    public UserAddressLoader userAddressLoader() {
        return new SpringDbUserAddressLoader(this.jdbcTemplate, this.queryFactory, ContactSource.CODEBOOK);
    }

    @Bean
    public ContactManager contactManager() {
        return new BasicContactManager((UserByBasicUserLoader)this.userLoader(), this.userRelationsHelper());
    }

    @Bean
    public UserDepartmentsByUserIdsLoader readableUserDepartmentsByUserIdsLoader() {
        return new SpringDbUserDepartmentsLoader(this.jdbcTemplate, this.queryFactory, this.departmentLoader, "vaz_cten_pujc", "fk_pujc", "fk_uziv_cten");
    }

    @Bean
    public SpringDbUserDepartmentsLoader editableUserDepartmentsByUserIdsLoader() {
        return new SpringDbUserDepartmentsLoader(this.jdbcTemplate, this.queryFactory, this.departmentLoader, "vaz_uziv_pujc", "fk_pujc", "fk_uziv");
    }

    @Bean
    public IdAndIdsLoadable<BasicUser, Integer> basicUserLoader() {
        SpringDbBasicUserLoader databaseLoader = new SpringDbBasicUserLoader(this.jdbcTemplate, this.queryFactory);
        ChunkingAllByIdsLoader chunkingLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)databaseLoader);
        DynamicallyCachedAllByIdsLoader cacheableLoader = new DynamicallyCachedAllByIdsLoader(this.userCache(), (AllByIdsLoadable)chunkingLoader);
        NonEvidedDelegatingBasicUserLoader anonymousDelegatingLoader = new NonEvidedDelegatingBasicUserLoader((AllByIdsLoadable)this.nonEvidedUserLoader(), (AllByIdsLoadable)cacheableLoader);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)anonymousDelegatingLoader, BasicUser.class);
    }

    @Bean
    public UserLoader userLoader() {
        EntitiesToUsersConverter entitiesToUsersConverter = new EntitiesToUsersConverter((ByIdLoadable)this.readerCategoryLoader(), (ByIdLoadable)this.departmentLoader, (ByIdLoadable)this.librarianGroupLoader(), this.contactLoader(), this.userAddressLoader(), this.readableUserDepartmentsByUserIdsLoader(), (UserDepartmentsByUserIdsLoader)this.editableUserDepartmentsByUserIdsLoader());
        SpringDbAllUsersByIdsLoader databaseLoader = new SpringDbAllUsersByIdsLoader(this.jdbcTemplate, this.queryFactory, (Converter)entitiesToUsersConverter);
        ChunkingAllByIdsLoader chunkingLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)databaseLoader);
        SavingDynamicallyCachedAllByIdsLoader cacheableLoader = new SavingDynamicallyCachedAllByIdsLoader(this.userCache(), (AllByIdsLoadable)chunkingLoader);
        NonEvidedDelegatingUserLoader anonymousDelegatingLoader = new NonEvidedDelegatingUserLoader((IdAndIdsLoadable)this.nonEvidedUserLoader(), (AllByIdsLoadable)cacheableLoader);
        return new AllByIdsDelegatingUserLoader((AllByIdsLoadable)anonymousDelegatingLoader);
    }

    @Bean
    public DynamicCache<User> userCache() {
        GuavaTimedDynamicCache bean = GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofSeconds(30L), (boolean)false);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), () -> ((GuavaTimedDynamicCache)bean).clear());
        return bean;
    }

    @Bean
    public AllByIdsLoadableByIdLoaderAdapter<User, Integer> nonEvidedUserLoader() {
        return new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)new NonEvidedCurrentAuthenticationUserLoader(this.authenticationHolder));
    }

    @Bean
    public ByIdLoadable<User, String> stringIdUserLoader() {
        return new UserLoaderDispatching((ByIdLoadable)this.userLoader(), this.currentAuthWebResolver, this.request);
    }

    @Bean
    public ByIdLoadable<BasicUser, String> stringIdBasicUserLoader() {
        return new UserLoaderDispatching((ByIdLoadable)this.basicUserLoader(), this.currentAuthWebResolver, this.request);
    }

    @Bean
    public PageSearchLoader<MapBackedParams, Integer> userIdPageSearchLoader() {
        SpringDbUserIdSearchLoader bean = new SpringDbUserIdSearchLoader(this.jdbcTemplate, this.queryFactory, (Provider)new StaticContextualDelegatingProvider(this.userBarCodeValidatorProvider(), this.realRootDepartmentProvider));
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "searchedUsersByParams");
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "searchedUsersCountByParams");
        return new CachingUserIdPageSearchLoader((PageSearchLoader)bean);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Integer> userIdSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, this.userIdPageSearchLoader());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, BasicUser> basicUserSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.userIdSearchLoader(), (AllByIdsLoadable)this.basicUserLoader()));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.userIdSearchLoader(), (AllByIdsLoadable)this.userLoader()));
    }

    @Bean
    public UserByUsernameLoader userByUsernameLoader() {
        return new SearchingUserByUsernameLoader(this.userSearchLoader());
    }

    @Bean
    public Provider<Integer> portaroUserIdProvider() {
        return new UsernameSearchingUserIdProvider(this.userIdSearchLoader(), "OPAC");
    }

    @Bean
    public Provider<User> portaroUserProvider() {
        return ProviderByIdProvider.of((ByIdLoadable)this.userLoader(), (Provider)this.portaroUserIdProvider());
    }

    @Bean
    public Provider<User> suUserProvider() {
        return ProviderByIdProvider.of((ByIdLoadable)this.userLoader(), (Provider)new SearchingMultiTryingSuUserIdProvider((PageSearchLoader)this.userIdSearchLoader(), "SU"));
    }

    @Bean
    public RoleNamesResolver roleNamesResolver() {
        return new RoleNamesResolver();
    }

    @Bean
    public SecurityAccessor securityAccessor() {
        return new SecurityAccessor((CurrentAuthDepartmentsLoader)this.currentAuthEditableDepartmentsLoader(), this.departmentAccessor);
    }

    @Bean
    public CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader() {
        CurrentAuthEditableFondsLoaderByUserFondsLoader pure = new CurrentAuthEditableFondsLoaderByUserFondsLoader(this.editableUserFondsLoader());
        return new BypassableCurrentAuthEditableFondsLoader((CurrentAuthEditableFondsLoader)pure, (AllValuesProvider)this.fondLoader).bypassWhenAuth(UserAuthenticationFunctions.hasAdminAndLibrarianRole());
    }

    @Bean
    public UserEditableFondsLoader editableUserFondsLoader() {
        UserEditableFondsLoaderByPermissions.FondToActionIdConverter fondToActionIdConverter = new UserEditableFondsLoaderByPermissions.FondToActionIdConverter(this.desiderataFondProvider.optionally());
        UserEditableFondsLoaderByPermissions pure = new UserEditableFondsLoaderByPermissions((ActionPermissionAccessor)this.actionPermissionAccessor(), (AllValuesProvider)this.fondLoader, (Converter)fondToActionIdConverter);
        CachingUserEditableFondsLoader bean = new CachingUserEditableFondsLoader((UserEditableFondsLoader)pure);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)bean);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "userEditableFonds");
        return bean;
    }

    @Bean
    public AuthContextualDepartmentsLoader familyModeAuthContextualDepartmentsLoader() {
        return new FamilyModeAuthContextualDepartmentsLoader((CurrentAuthDepartmentsLoader)this.currentAuthEditableDepartmentsLoader(), this.departmentAccessor);
    }

    @Bean
    public BypassableCurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader() {
        CurrentAuthDepartmentsLoaderByUserDepartmentsLoader pure = new CurrentAuthDepartmentsLoaderByUserDepartmentsLoader(this.editableUserDepartmentsLoader(), this.departmentAccessor);
        return new BypassableCurrentAuthDepartmentsLoader((CurrentAuthDepartmentsLoader)pure, (AllValuesProvider)this.departmentLoader).bypassWhenAuth(UserAuthenticationFunctions.hasAdminAndLibrarianRole()).bypassWhenAuthUser(UserFunctions.isUser((Provider)this.portaroUserProvider()));
    }

    @Bean
    public UserDepartmentsLoader cachedEditableUserDepartmentsLoader() {
        CachingUserEditableDepartmentsLoader cached = new CachingUserEditableDepartmentsLoader((UserDepartmentsLoader)this.editableUserDepartmentsByUserIdsLoader());
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)cached);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "userEditableDepartments");
        return cached;
    }

    @Bean
    public UserDepartmentsLoader editableUserDepartmentsLoader() {
        return new UserDepartmentsLoaderSuEditLevelChecking(this.cachedEditableUserDepartmentsLoader(), (UserByBasicUserLoader)this.userLoader(), (AllValuesProvider)this.departmentLoader);
    }

    @Bean
    public UserDepartmentsLoader readableUserDepartmentsLoader() {
        SpringDbUserDepartmentsLoader pure = new SpringDbUserDepartmentsLoader(this.jdbcTemplate, this.queryFactory, this.departmentLoader, "vaz_cten_pujc", "fk_pujc", "fk_uziv_cten");
        CachingUserReadableDepartmentsLoader bean = new CachingUserReadableDepartmentsLoader((UserDepartmentsLoader)pure);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "userReadableDepartments");
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)bean);
        return bean;
    }

    @Bean
    public ConditionallyPermittingActionPermissionAccessor actionPermissionAccessor() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(2000L).build();
        ActionPermissionAccessorDelegating bean = new ActionPermissionAccessorDelegating(this.defaultPermissionDtoLoader(), this.userPermissionEntityLoader(), (UserByBasicUserLoader)this.userLoader(), cache);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)bean);
        return new ConditionallyPermittingActionPermissionAccessor((ActionPermissionAccessor)bean).whenUser(UserFunctions.hasSuEditLevel((UserByBasicUserLoader)this.userLoader())).permitAllActions().whenUser(UserFunctions.isUser((Provider)this.portaroUserProvider())).permitAllActions();
    }

    @Bean
    public Codebook<DefaultPermissionEntity, Integer> defaultPermissionDtoLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(DefaultPermissionEntity.class).staticCached(DefaultPermissionEntity.class.getSimpleName()).build();
    }

    @Bean
    public AllValuesProvider<UserPermissionEntity> userPermissionEntityLoader() {
        JpaAllValuesProvider loader = new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(UserPermissionEntity.class, this.entityManager));
        StaticCache cachedLoader = this.staticCacheFactory.createStaticCache((AllValuesProvider)loader);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), () -> ((StaticCache)cachedLoader).clear());
        return cachedLoader;
    }

    @Bean
    public UserRelationsHelper userRelationsHelper() {
        return new DelegatingUserRelationsHelper(this.userRelationLoader(), this.userLoader());
    }

    @Bean
    public UserRelationLoader userRelationLoader() {
        JpaUserRelationLoader bean = new JpaUserRelationLoader((JpaRepository)new SimpleJpaRepository(UserRelationEntity.class, this.entityManager), (AllByIdsLoadable)this.basicUserLoader());
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "userRelations");
        this.cacheService.registerSpringCacheCleaner(UserRelation.class.getSimpleName(), "userRelations");
        return bean;
    }

    @Bean
    public RepresentableUserLoader representableUserLoader() {
        return new RepresentableUserLoaderByUserRelationLoader(this.userRelationLoader());
    }

    @Bean
    public ContextualProvider<Department, BarCodeValidator> userBarCodeValidatorProvider() {
        return new BarCodeValidatorContextualProvider(this.barCodeValidatorByBarCodeTypeProvider.withAdditionalValidator(BarCodeType.CUSTOM, (BarCodeValidator)new ValidLengthBarCodeValidator(this.settingLoader.getOnRootProvider(UserSettingKeys.USER_BARCODE_CORE_MAX_LENGTH))), this.settingLoader.getDepartmentedProvider(SettingKeys.USER_BARCODE_TYPES));
    }

    @Bean
    public AllValuesProvider<String> userNetIdLoader() {
        return new SpringDbNetIdLoader(this.jdbcTemplate, this.queryFactory);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAcceptableValuesProviders() {
        this.allowedDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)UserConstants.Datatype.READER_CATEGORY.getName()), this.readerCategoryLoader());
        this.allDatatypeToAllValuesProviderMap.put(new EqualsPredicate((Object)UserConstants.Datatype.READER_CATEGORY.getName()), this.readerCategoryLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForStringId(ContactSource.class, (ByIdLoadable)ContactSource.CODEBOOK).registerForIntegerId(LibrarianGroup.class, (ByIdLoadable)this.librarianGroupLoader()).registerForStringId(ReaderCategory.class, (ByIdLoadable)this.readerCategoryLoader()).registerForStringId(UserSearchRoleType.class, (ByIdLoadable)UserSearchRoleType.CODEBOOK);
        this.conversionService.addConverter(Integer.class, BasicUser.class, (Converter)new IdToObjectConverter((ByIdLoadable)this.basicUserLoader()));
        this.conversionService.addConverter(String.class, BasicUser.class, (Converter)new IdToObjectConverter(this.stringIdBasicUserLoader()));
        this.objectMapperModule.addDeserializer(BasicUser.class, (JsonDeserializer)new ByStringConverterJsonDeserializer(BasicUser.class, (Converter)new IdToObjectConverter(this.stringIdBasicUserLoader())));
        this.conversionService.addConverter(Integer.class, User.class, (Converter)new IdToObjectConverter((ByIdLoadable)this.userLoader()));
        this.conversionService.addConverter(String.class, User.class, (Converter)new IdToObjectConverter(this.stringIdUserLoader()));
        this.objectMapperModule.addDeserializer(User.class, (JsonDeserializer)new ByStringConverterJsonDeserializer(User.class, (Converter)new IdToObjectConverter(this.stringIdUserLoader())));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "entityManager", "cacheService", "staticCacheFactory", "codebookLoaderBuilderFactory", "converterRegisterer", "conversionService", "objectMapperModule", "departmentLoader", "departmentAccessor", "authenticationHolder", "currentAuthWebResolver", "request", "fondLoader", "desiderataFondProvider", "allowedDatatypeToAllValuesProviderMap", "allDatatypeToAllValuesProviderMap", "settingLoader", "barCodeValidatorByBarCodeTypeProvider", "realRootDepartmentProvider"})
    @Generated
    public UserConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull EntityManager entityManager, @NonNull CacheService cacheService, @NonNull StaticCacheFactory staticCacheFactory, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull FormatterRegistry conversionService, @NonNull SimpleModule objectMapperModule, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull AuthenticationHolder authenticationHolder, @NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull HttpServletRequest request, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull Provider<Fond> desiderataFondProvider, @NonNull LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allowedDatatypeToAllValuesProviderMap, @NonNull LinkedHashMap<Predicate<String>, AllValuesProvider<? extends LabeledIdentified<?>>> allDatatypeToAllValuesProviderMap, @NonNull SettingLoader settingLoader, @NonNull BarCodeValidatorByBarCodeTypeProvider barCodeValidatorByBarCodeTypeProvider, @NonNull Provider<Department> realRootDepartmentProvider) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(staticCacheFactory, "staticCacheFactory is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(request, "request is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(desiderataFondProvider, "desiderataFondProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDatatypeToAllValuesProviderMap, "allowedDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(barCodeValidatorByBarCodeTypeProvider, "barCodeValidatorByBarCodeTypeProvider is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.entityManager = entityManager;
        this.cacheService = cacheService;
        this.staticCacheFactory = staticCacheFactory;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.converterRegisterer = converterRegisterer;
        this.conversionService = conversionService;
        this.objectMapperModule = objectMapperModule;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.authenticationHolder = authenticationHolder;
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.request = request;
        this.fondLoader = fondLoader;
        this.desiderataFondProvider = desiderataFondProvider;
        this.allowedDatatypeToAllValuesProviderMap = allowedDatatypeToAllValuesProviderMap;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
        this.settingLoader = settingLoader;
        this.barCodeValidatorByBarCodeTypeProvider = barCodeValidatorByBarCodeTypeProvider;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }
}

