/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.json.ByStringConverterJsonDeserializer;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.ResourceLoaderByCustomFileLoader;
import cz.kpsys.portaro.search.UntypedSearcherFactory;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.template.AllTemplateDescriptorsProviderByCustomFileLoader;
import cz.kpsys.portaro.template.AllTemplateDescriptorsProviderClasspath;
import cz.kpsys.portaro.template.BasicTemplateDescriptor;
import cz.kpsys.portaro.template.CachingAllTemplateDescriptorsProvider;
import cz.kpsys.portaro.template.ClasspathFileTemplateResourceLoader;
import cz.kpsys.portaro.template.MaybeDepartmentedTemplateResourceLoader;
import cz.kpsys.portaro.template.TemplateDescriptor;
import cz.kpsys.portaro.template.TemplateDescriptorLoader;
import cz.kpsys.portaro.template.TemplateDescriptorLoaderByAllValuesProvider;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.velocity.VelocityResourceLoaderByTemplateLoader;
import cz.kpsys.portaro.template.velocity.VelocityTemplateEngine;
import cz.kpsys.portaro.view.web.rest.TemplateApiController;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.format.FormatterRegistry;

@Configuration
public class TemplateConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader;
    @NonNull
    private final Codebook<CustomFile, String> customFileLoader;
    @NonNull
    private final FileDataStreamer cachedUnsecuredFileDataStreamer;
    @NonNull
    private final UntypedSearcherFactory untypedSearcherFactory;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final FormatterRegistry conversionService;

    @Bean
    public TemplateApiController templateController() {
        return new TemplateApiController(this.templateDescriptorLoader());
    }

    @Bean
    public VelocityEngine velocityEngine() {
        MaybeDepartmentedTemplateResourceLoader templateLoader = new MaybeDepartmentedTemplateResourceLoader((ByIdLoadable)new ResourceLoaderByCustomFileLoader(this.hierarchyTraversingCustomFileLoader, this.cachedUnsecuredFileDataStreamer), (ByIdLoadable)new ClasspathFileTemplateResourceLoader(List.of("velocity"), true));
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loaders", (Object)"templateloader");
        engine.setProperty("resource.loader.templateloader.class", (Object)VelocityResourceLoaderByTemplateLoader.class.getName());
        engine.setProperty("resource.loader.templateloader.templateLoader", (Object)templateLoader);
        engine.setProperty("resource.loader.templateloader.cache", (Object)true);
        engine.setProperty("resource.loader.templateloader.modification_check_interval", (Object)3L);
        engine.setProperty("parser.space_gobbling", (Object)"bc");
        engine.setProperty("directive.if.empty_check", (Object)"false");
        engine.setProperty("velocimacro.library.path", (Object)"/html/macros.vtl");
        engine.setProperty("parser.pool.size", (Object)20);
        engine.setProperty("velocimacro.inline.allow", (Object)true);
        engine.setProperty("velocimacro.inline.replace_global", (Object)true);
        return engine;
    }

    @Bean
    public TemplateEngine templateEngine() {
        return new VelocityTemplateEngine(this.velocityEngine(), this.translator, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull(), this.publicContextPath, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.systemInstitutionProvider, this.untypedSearcherFactory);
    }

    @Bean
    public AllValuesProvider<TemplateDescriptor> allTemplateDescriptorsProvider() {
        CompositeAllValuesProvider bean = new CompositeAllValuesProvider(new AllValuesProvider[]{new AllTemplateDescriptorsProviderByCustomFileLoader((AllValuesProvider)this.customFileLoader, List.of("cert")), new AllTemplateDescriptorsProviderClasspath("classpath:velocity/*.vtl", "macros.vtl", "html")});
        CachingAllTemplateDescriptorsProvider cached = new CachingAllTemplateDescriptorsProvider((AllValuesProvider)bean);
        this.cacheService.registerSpringCacheCleaner(TemplateDescriptor.class.getSimpleName(), "templateDescriptors");
        this.cacheService.registerSpringCacheCleaner(CustomFile.class.getSimpleName(), "templateDescriptors");
        return cached;
    }

    @Bean
    public TemplateDescriptorLoader templateDescriptorLoader() {
        return new TemplateDescriptorLoaderByAllValuesProvider(this.allTemplateDescriptorsProvider());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.objectMapperModule.addDeserializer(TemplateDescriptor.class, (JsonDeserializer)new ByStringConverterJsonDeserializer(TemplateDescriptor.class, BasicTemplateDescriptor::parse));
        this.conversionService.addConverter(String.class, TemplateDescriptor.class, BasicTemplateDescriptor::parse);
    }

    @ConstructorProperties(value={"publicContextPath", "cacheService", "settingLoader", "systemInstitutionProvider", "translator", "hierarchyTraversingCustomFileLoader", "customFileLoader", "cachedUnsecuredFileDataStreamer", "untypedSearcherFactory", "objectMapperModule", "conversionService"})
    @Generated
    public TemplateConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull Translator<Department> translator, @NonNull ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader, @NonNull Codebook<CustomFile, String> customFileLoader, @NonNull FileDataStreamer cachedUnsecuredFileDataStreamer, @NonNull UntypedSearcherFactory untypedSearcherFactory, @NonNull SimpleModule objectMapperModule, @NonNull FormatterRegistry conversionService) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(hierarchyTraversingCustomFileLoader, "hierarchyTraversingCustomFileLoader is marked non-null but is null");
        Objects.requireNonNull(customFileLoader, "customFileLoader is marked non-null but is null");
        Objects.requireNonNull(cachedUnsecuredFileDataStreamer, "cachedUnsecuredFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(untypedSearcherFactory, "untypedSearcherFactory is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.translator = translator;
        this.hierarchyTraversingCustomFileLoader = hierarchyTraversingCustomFileLoader;
        this.customFileLoader = customFileLoader;
        this.cachedUnsecuredFileDataStreamer = cachedUnsecuredFileDataStreamer;
        this.untypedSearcherFactory = untypedSearcherFactory;
        this.objectMapperModule = objectMapperModule;
        this.conversionService = conversionService;
    }
}

