/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.AuthenticationSetter;
import cz.kpsys.portaro.auth.Authenticator;
import cz.kpsys.portaro.auth.Authenticity;
import cz.kpsys.portaro.auth.ConditionalAuthenticator;
import cz.kpsys.portaro.auth.OnlyThrowingAccessDeniedHandler;
import cz.kpsys.portaro.auth.anonym.AnonymAuthConfig;
import cz.kpsys.portaro.auth.cas.CasAuthSettingKeys;
import cz.kpsys.portaro.auth.cas.CasAuthenticationRequest;
import cz.kpsys.portaro.auth.cas.CasAuthenticator;
import cz.kpsys.portaro.auth.cas.CasLogouter;
import cz.kpsys.portaro.auth.cas.CasSsoConsumer;
import cz.kpsys.portaro.auth.cas.CasSuccessAuthentication;
import cz.kpsys.portaro.auth.cas.TicketValidatorProtocolResolver;
import cz.kpsys.portaro.auth.credreg.CredentialsRegistrationAuthConfig;
import cz.kpsys.portaro.auth.current.resolver.CompositeUserAuthenticationAuthenticationResolver;
import cz.kpsys.portaro.auth.current.resolver.UserAuthenticationAuthenticationResolver;
import cz.kpsys.portaro.auth.department.BooleanContextualProvidedRequestMatcher;
import cz.kpsys.portaro.auth.external.SSOAuthenticationFilter;
import cz.kpsys.portaro.auth.external.SsoConsumer;
import cz.kpsys.portaro.auth.ezak.EzakAuthConfig;
import cz.kpsys.portaro.auth.httpbasic.HttpbasicAuthConfig;
import cz.kpsys.portaro.auth.ldap.LdapAuthConfig;
import cz.kpsys.portaro.auth.logout.LogoutController;
import cz.kpsys.portaro.auth.logout.Logouter;
import cz.kpsys.portaro.auth.multifactor.MultifactorAuthConfig;
import cz.kpsys.portaro.auth.oauth2.authorizationcode.OAuth2AuthorizationCodeAuthConfig;
import cz.kpsys.portaro.auth.oauth2.authorizationserver.OAuth2AuthorizationServerConfig;
import cz.kpsys.portaro.auth.oauth2.jwt.JwtAuthConfig;
import cz.kpsys.portaro.auth.openid.OpenIdAuthConfig;
import cz.kpsys.portaro.auth.process.AuthoritiedSuccessAuthentication;
import cz.kpsys.portaro.auth.process.GenericAuthoritiedSuccessAuthentication;
import cz.kpsys.portaro.auth.saml2.idp.Saml2IdentityProviderConfig;
import cz.kpsys.portaro.auth.saml2.sp.Saml2ServiceProviderConfig;
import cz.kpsys.portaro.auth.sidechannel.SideChannelAuthConfig;
import cz.kpsys.portaro.auth.stringpair.StringpairAuthConfig;
import cz.kpsys.portaro.auth.switchuser.SwitchedSuccessAuthentication;
import cz.kpsys.portaro.auth.token.PairingAuthConfig;
import cz.kpsys.portaro.auth.token.TokenAuthConfig;
import cz.kpsys.portaro.auth.useragent.UserAgentAuthConfig;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.StringToIntegerListConverter;
import cz.kpsys.portaro.commons.convert.StringToStringListConverter;
import cz.kpsys.portaro.commons.convert.StringToUuidConverter;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.ip.FromToIpAddressRange;
import cz.kpsys.portaro.commons.ip.IpAddress;
import cz.kpsys.portaro.commons.ip.IpAddressInRangeResolver;
import cz.kpsys.portaro.commons.ip.ListedIpAddressRange;
import cz.kpsys.portaro.commons.ip.StringToIpAddressConverter;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.file.AccessTypeAware;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.Resource;
import cz.kpsys.portaro.file.SecuredFileDataStreamer;
import cz.kpsys.portaro.file.directory.AllIdsByDirectoryProvider;
import cz.kpsys.portaro.file.directory.DirectoryChainLoader;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.matcher.FileAccessTypeMatcher;
import cz.kpsys.portaro.file.matcher.FileCategoryMatcher;
import cz.kpsys.portaro.file.matcher.ThisOrAnyOfParentDirectoryMatcher;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.filter.FilterLoaderByRowLoader;
import cz.kpsys.portaro.filter.FilterMatcherRelationDtoLoader;
import cz.kpsys.portaro.filter.FilterMatcherRelationDtoLoaderJpa;
import cz.kpsys.portaro.filter.FilterMatcherRelationEntity;
import cz.kpsys.portaro.filter.IdentifiedFilter;
import cz.kpsys.portaro.filter.SpringDbFilterEntityLoader;
import cz.kpsys.portaro.gdpr.GdprNotSetFilter;
import cz.kpsys.portaro.logging.TraceIdRepository;
import cz.kpsys.portaro.logging.TraceIdServletFilter;
import cz.kpsys.portaro.matcher.AdaptingMatcher;
import cz.kpsys.portaro.matcher.AlwaysMatchMatcher;
import cz.kpsys.portaro.matcher.Matcher;
import cz.kpsys.portaro.matcher.MatcherEntity;
import cz.kpsys.portaro.matcher.MatcherFactory;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.collection.FileRecordCollectionMatcher;
import cz.kpsys.portaro.record.collection.RecordCollectionContainQuery;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.document.DocumentDirectoryLoader;
import cz.kpsys.portaro.record.document.SpringDbAllDocumentIdsByDirectoryLoader;
import cz.kpsys.portaro.record.matcher.FileDocumentMatcher;
import cz.kpsys.portaro.record.matcher.FileRecordSubfieldValueMatcher;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.ConfigurableUserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.auth.switchuser.SwitchUserFilter;
import cz.kpsys.portaro.user.auth.switchuser.SwitchedUserAuthenticator;
import cz.kpsys.portaro.user.matcher.AccessToItemAdaptingMatcher;
import cz.kpsys.portaro.user.matcher.AdministratorAllowingMatcher;
import cz.kpsys.portaro.user.matcher.BlockedUserMatcher;
import cz.kpsys.portaro.user.matcher.ConcreteUserMatcher;
import cz.kpsys.portaro.user.matcher.IpAddressMatcher;
import cz.kpsys.portaro.user.matcher.LoggedUserMatcher;
import cz.kpsys.portaro.user.matcher.ReaderCategoryMatcher;
import cz.kpsys.portaro.user.matcher.ValidRegistrationMatcher;
import cz.kpsys.portaro.user.prefs.UserPrefAccessor;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.web.UrlWebResolver;
import cz.kpsys.portaro.web.exception.ExceptionCatchingServletFilter;
import cz.kpsys.portaro.web.exception.ExceptionResponseLogger;
import cz.kpsys.portaro.web.log.MemoryIncreaseLoggingFilter;
import cz.kpsys.portaro.web.log.RequestStartLoggingFilter;
import cz.kpsys.portaro.web.log.ResponseTimeLoggingFilter;
import cz.kpsys.portaro.web.page.ExceptionModelAndViewResolver;
import cz.kpsys.portaro.web.server.ServerUrlConfiguration;
import cz.kpsys.portaro.web.url.EnforcingHttpsFilter;
import cz.kpsys.portaro.web.url.TrailingSlashRedirectingFilter;
import jakarta.persistence.EntityManager;
import jakarta.servlet.Filter;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.ForwardedHeaderFilter;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@Import(value={AnonymAuthConfig.class, CredentialsRegistrationAuthConfig.class, EzakAuthConfig.class, HttpbasicAuthConfig.class, LdapAuthConfig.class, MultifactorAuthConfig.class, OAuth2AuthorizationCodeAuthConfig.class, OAuth2AuthorizationServerConfig.class, OpenIdAuthConfig.class, PairingAuthConfig.class, JwtAuthConfig.class, Saml2IdentityProviderConfig.class, Saml2ServiceProviderConfig.class, SideChannelAuthConfig.class, StringpairAuthConfig.class, TokenAuthConfig.class, UserAgentAuthConfig.class})
@EnableWebSecurity(debug=false)
public class SecurityConfig {
    public static final String ADMIN = "ADMIN";
    public static final String ACTUATOR = "ACTUATOR";
    public static final String LIBRARIAN = "LIBRARIAN";
    public static final String SERVICEMAN = "SERVICEMAN";
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final TraceIdRepository traceIdRepository;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader;
    @NonNull
    private final HierarchyContextsByModeLoader<Department> departmentAccessor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final WebResolver<Department> currentDepartmentWebResolver;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final AuthenticationTrustResolver trustResolver;
    @NonNull
    private final SecurityContextRepository securityContextRepository;
    @NonNull
    private final AuthenticationFailureHandler failureHandler;
    @NonNull
    private final AuthenticationSuccessHandler redirectParameterSearchingSuccessHandler;
    @NonNull
    private final LogoutController logoutController;
    @NonNull
    private final ByIdLoadable<User, String> stringIdUserLoader;
    @NonNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NonNull
    private final ServerUrlConfiguration serverUrlConfiguration;
    @NonNull
    private final ExceptionResponseLogger exceptionResponseLogger;
    @NonNull
    private final ExceptionModelAndViewResolver exceptionModelAndViewResolver;
    @NonNull
    private final UrlWebResolver serverUrlWebResolver;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final AllByIdsLoadable<RichRecord, UUID> richRecordLoader;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final DirectoryChainLoader directoryChainLoader;
    @NonNull
    private final IpAddressInRangeResolver internalIpResolver;
    @NonNull
    private final SpringDbAllDocumentIdsByDirectoryLoader allDocumentIdsByDirectoryProvider;
    @NonNull
    private final FileDataStreamer fileDataStreamer;
    @NonNull
    private final FileDataStreamer fileTextDataStreamer;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final Consumer<HttpSecurity> anonymAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> jwtAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> ezakAuthenticationHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> oauth2AuthorizationCodeAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> openIdAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> saml2ServiceProviderHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> httpbasicAuthenticationHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> tokenAuthenticationHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> userAgentAuthenticationHttpSecurityConfigurer;
    @NonNull
    private final CompositeUserAuthenticationAuthenticationResolver compositeUserAuthenticationAuthenticationResolver;
    @NonNull
    private final List<Class<? extends AuthoritiedSuccessAuthentication>> authenticationEventSavingTypes;
    @NonNull
    private final UserPrefAccessor userPrefAccessor;
    @NonNull
    private final RecordCollectionContainQuery recordCollectionPersistentStorageContainQuery;
    private static final String SWITCH_USER_AUTH_ENTER_PATH = "/login/impersonate";
    private static final String SWITCH_USER_AUTH_EXIT_PATH = "/logout/impersonate";
    private static final String SWITCH_USER_AUTH_USER_ID_PARAMETER = "user";
    private static final String CAS_AUTH_PATH = "/login/cas";
    private static final String CAS_AUTH_PATH_OLD = "/login/jasig/authenticate";
    private static final String CAS_SERVICE_PARAMETER_NAME = "service";

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.setSharedObject(SecurityContextRepository.class, (Object)this.securityContextRepository);
        http.authenticationManager(authentication -> {
            throw new AuthenticationServiceException("Cannot use default authentication manager to authenticate %s".formatted(authentication));
        });
        http.headers(conf -> {
            conf.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable);
            conf.contentTypeOptions(HeadersConfigurer.ContentTypeOptionsConfig::disable);
        }).csrf(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).httpBasic(AbstractHttpConfigurer::disable).anonymous(AbstractHttpConfigurer::disable).oauth2Login(AbstractHttpConfigurer::disable).saml2Login(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).addFilterBefore((Filter)new TraceIdServletFilter(this.traceIdRepository), SecurityContextHolderFilter.class).addFilterAfter((Filter)new RequestStartLoggingFilter(), TraceIdServletFilter.class).addFilterAfter((Filter)new ResponseTimeLoggingFilter(), RequestStartLoggingFilter.class).addFilterAfter((Filter)new MemoryIncreaseLoggingFilter(), ResponseTimeLoggingFilter.class).addFilterAfter((Filter)new CharacterEncodingFilter(StandardCharsets.UTF_8.name(), true, true), MemoryIncreaseLoggingFilter.class).addFilterAfter((Filter)new ExceptionCatchingServletFilter(this.exceptionResponseLogger, this.exceptionModelAndViewResolver), CharacterEncodingFilter.class).addFilterAfter((Filter)new ForwardedHeaderFilter(), SecurityContextHolderFilter.class).addFilterAfter((Filter)new TrailingSlashRedirectingFilter((RequestMatcher)new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Portaro-Skip-Trailing-Slash-Redirect")), this.publicContextPath, this.settingLoader.getOnRootProvider(SettingKeys.SERVER_URL)), ForwardedHeaderFilter.class).addFilterAfter((Filter)new EnforcingHttpsFilter((RequestMatcher)new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new RequestHeaderRequestMatcher("X-Portaro-Skip-Https-Redirect"), new AntPathRequestMatcher("/.well-known/acme-challenge/*")})), this.serverUrlConfiguration, this.serverUrlWebResolver), TrailingSlashRedirectingFilter.class).addFilterAfter((Filter)this.gdprFilter(), UsernamePasswordAuthenticationFilter.class).exceptionHandling(conf -> {
            conf.accessDeniedHandler((AccessDeniedHandler)new OnlyThrowingAccessDeniedHandler());
            conf.withObjectPostProcessor((ObjectPostProcessor)new /* Unavailable Anonymous Inner Class!! */);
        }).addFilterAfter((Filter)this.casAuthenticationFilter(), AnonymousAuthenticationFilter.class).addFilterAfter((Filter)this.switchUserFilter(), AnonymousAuthenticationFilter.class).sessionManagement(conf -> {
            conf.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
            conf.sessionFixation().none();
            conf.sessionAuthenticationErrorUrl("/?showLogin=true");
        }).authorizeHttpRequests(conf -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new RequestMatcher[]{new AndRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/resources/**"), new NegatedRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/resources/**/*.map"))})})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/favicon.png"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/resources/robots.txt"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/actuator/health/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/actuator/info/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/actuator/**"})).hasAnyRole(new String[]{ACTUATOR, ADMIN, SERVICEMAN, LIBRARIAN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/appserver/**"})).hasAnyRole(new String[]{ADMIN, SERVICEMAN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/db/**"})).hasAnyRole(new String[]{ADMIN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new String[]{"/jobs/**"})).hasAnyRole(new String[]{ADMIN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.anyRequest()).permitAll();
        });
        this.anonymAuthHttpSecurityConfigurer.accept(http);
        this.jwtAuthHttpSecurityConfigurer.accept(http);
        this.httpbasicAuthenticationHttpSecurityConfigurer.accept(http);
        this.oauth2AuthorizationCodeAuthHttpSecurityConfigurer.accept(http);
        this.openIdAuthHttpSecurityConfigurer.accept(http);
        this.saml2ServiceProviderHttpSecurityConfigurer.accept(http);
        this.ezakAuthenticationHttpSecurityConfigurer.accept(http);
        this.tokenAuthenticationHttpSecurityConfigurer.accept(http);
        this.userAgentAuthenticationHttpSecurityConfigurer.accept(http);
        return (SecurityFilterChain)http.build();
    }

    private GdprNotSetFilter gdprFilter() {
        return new GdprNotSetFilter((RequestMatcher)new AndRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/api/server-urls")}), this.userPrefAccessor, this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_ANONYMIZATION_QUESTION_DIALOG), this.currentDepartmentWebResolver, this.authenticationHolder);
    }

    private SwitchUserFilter switchUserFilter() {
        SwitchUserFilter f = new SwitchUserFilter(this.stringIdUserLoader, SWITCH_USER_AUTH_USER_ID_PARAMETER, (RequestMatcher)new AntPathRequestMatcher(SWITCH_USER_AUTH_ENTER_PATH, null, true, new UrlPathHelper()), (RequestMatcher)new AntPathRequestMatcher(SWITCH_USER_AUTH_EXIT_PATH, null, true, new UrlPathHelper()), (Authenticator)new SwitchedUserAuthenticator(this.authenticationHolder, this.securityManager), this.currentDepartmentWebResolver, this.authenticationHolder, this.redirectParameterSearchingSuccessHandler, this.failureHandler, this.applicationEventPublisher, (UserAuthenticationAuthenticationResolver)this.compositeUserAuthenticationAuthenticationResolver);
        this.compositeUserAuthenticationAuthenticationResolver.withAuthenticatedUserResolverOf(SwitchedSuccessAuthentication.class, auth -> this.compositeUserAuthenticationAuthenticationResolver.resolveAuthenticatedUser((Authentication)auth.getPreviousAuthentication())).withActiveUserResolverOf(SwitchedSuccessAuthentication.class, GenericAuthoritiedSuccessAuthentication::getActiveUser).withAdditionalAuthoritiesResolverOf(SwitchedSuccessAuthentication.class, AbstractAuthenticationToken::getAuthorities).withStandaloneAuthoritiesAuthClass(SwitchedSuccessAuthentication.class).withAuthenticityResolverOf(SwitchedSuccessAuthentication.class, auth -> this.compositeUserAuthenticationAuthenticationResolver.resolveAuthenticity((Authentication)auth.getPreviousAuthentication()));
        this.authenticationEventSavingTypes.add(SwitchedSuccessAuthentication.class);
        return f;
    }

    private SSOAuthenticationFilter<CasAuthenticationRequest, CasSuccessAuthentication> casAuthenticationFilter() {
        CasSsoConsumer consumer = new CasSsoConsumer(CAS_SERVICE_PARAMETER_NAME, this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_LOGIN_URL).throwingWhenNull().invalidWhen(String::isBlank), this.serverUrlWebResolver, CAS_AUTH_PATH, "redirect", this.serverUrlConfiguration, this.currentDepartmentWebResolver);
        SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("redirect");
        return new SSOAuthenticationFilter((RequestMatcher)new AndRequestMatcher(new RequestMatcher[]{new BooleanContextualProvidedRequestMatcher(this.currentDepartmentWebResolver, this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_ENABLED)), new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(CAS_AUTH_PATH), new AntPathRequestMatcher(CAS_AUTH_PATH_OLD)})}), (SsoConsumer)consumer, this.casAuthenticator(), (AuthenticationSuccessHandler)successHandler, (AuthenticationSetter)this.authenticationHolder, (AuthenticationDetailsSource)new WebAuthenticationDetailsSource());
    }

    @Bean
    public Authenticator<CasAuthenticationRequest, CasSuccessAuthentication> casAuthenticator() {
        CasAuthenticator casAuthenticator = new CasAuthenticator(this.casTicketValidatorProvider(), this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_USER_ASSERTION_ATTRIBUTE), this.userByCasIdentifierLoader());
        ConditionalAuthenticator conditionalAuthenticator = new ConditionalAuthenticator(this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_ENABLED).toEnabledAsserter(value -> value), (Authenticator)casAuthenticator);
        this.compositeUserAuthenticationAuthenticationResolver.withAuthenticatedUserResolverOf(CasSuccessAuthentication.class, GenericAuthoritiedSuccessAuthentication::getActiveUser).withAdditionalAuthoritiesResolverOf(CasSuccessAuthentication.class, AbstractAuthenticationToken::getAuthorities).withAuthenticityResolverOf(CasSuccessAuthentication.class, auth -> Authenticity.ONE_CONFIDENTAL_FACTOR_OR_BETTER);
        this.authenticationEventSavingTypes.add(CasSuccessAuthentication.class);
        return conditionalAuthenticator;
    }

    @Bean
    public ContextualProvider<Department, @NonNull TicketValidator> casTicketValidatorProvider() {
        return this.casSystemUrlProvider().andThenContextual((BiFunction)new TicketValidatorProtocolResolver(this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_TICKET_VALIDATOR_PROTOCOL), CAS_SERVICE_PARAMETER_NAME));
    }

    @Bean
    public CasLogouter casLogouter() {
        CasLogouter bean = new CasLogouter(CAS_SERVICE_PARAMETER_NAME, this.currentDepartmentWebResolver, this.casSystemUrlProvider(), this.serverUrlWebResolver);
        this.logoutController.addLogouter((Logouter)bean);
        return bean;
    }

    @Bean
    public ContextualProvider<Department, String> casSystemUrlProvider() {
        return this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_SYSTEM_URL).throwingWhenNull();
    }

    @Bean
    public UserByContextualIdentifierLoader<User> userByCasIdentifierLoader() {
        return new ConfigurableUserByContextualIdentifierLoader(this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_USER_IDENTIFIER), this.stringIdUserLoader, this.userSearchLoader, this.departmentAccessor);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FilterLoader filterLoader() {
        MatcherFactory matcherFactory = new MatcherFactory();
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_ALWAYS_MATCH, dto -> new AlwaysMatchMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_CONCRETE_USER, dto -> new ConcreteUserMatcher((List)new StringToIntegerListConverter(",").convert((Object)dto.getValue())).withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_ADMINISTRATOR_LOGGED_USER, dto -> new AdministratorAllowingMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_IP_ADDRESS, dto -> {
            List ipAddresses = ListUtil.convert((Iterable)ListUtil.toList((String)dto.getValue(), (String)","), (Converter)new StringToIpAddressConverter());
            return new IpAddressMatcher((IpAddressInRangeResolver)new ListedIpAddressRange(ipAddresses)).withSourceOf(dto);
        });
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_IP_ADDRESS_RANGE, dto -> {
            List ipAddressPair = ListUtil.convert((Iterable)ListUtil.toList((String)dto.getValue(), (String)","), (Converter)new StringToIpAddressConverter());
            Assert.state((ipAddressPair.size() == 2 ? 1 : 0) != 0, (String)"IpAddressRange must have exactly 2 items");
            return new IpAddressMatcher((IpAddressInRangeResolver)new FromToIpAddressRange((IpAddress)ipAddressPair.get(0), (IpAddress)ipAddressPair.get(1))).withSourceOf(dto);
        });
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_INTERNAL_IP, dto -> new IpAddressMatcher(this.internalIpResolver).withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_LOGGED_USER, dto -> new LoggedUserMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_BLOCKED_USER, dto -> new BlockedUserMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_VALID_REGISTRATION, dto -> new ValidRegistrationMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_READER_CATEGORY, dto -> new ReaderCategoryMatcher(new StringToStringListConverter().throwOnBlankItems().convert(dto.getValue())).withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_ACCESS_TYPE, dto -> new AccessToItemAdaptingMatcher((Matcher)new AdaptingMatcher(AccessTypeAware::getAccessType, false, (Matcher)new FileAccessTypeMatcher((List)new StringToIntegerListConverter().convert((Object)dto.getValue())).withSourceOf(dto))));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_CATEGORY, dto -> new AccessToItemAdaptingMatcher((Matcher)new FileCategoryMatcher((List)new StringToIntegerListConverter().convert((Object)dto.getValue())).withSourceOf(dto)));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DIRECTORY_INHERITING_ACCESS_TYPE, dto -> new AccessToItemAdaptingMatcher((Matcher)new AdaptingMatcher(Resource::getDirectory, true, (Matcher)new ThisOrAnyOfParentDirectoryMatcher(this.directoryChainLoader, (Matcher)new AdaptingMatcher(AccessTypeAware::getAccessType, false, (Matcher)new FileAccessTypeMatcher((List)new StringToIntegerListConverter().convert((Object)dto.getValue())).withSourceOf(dto))))));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DOCUMENT, dto -> new AccessToItemAdaptingMatcher((Matcher)new FileDocumentMatcher((List)StringToUuidConverter.DELIMITED_LIST_CONVERTER.convert((Object)dto.getValue()), (AllIdsByDirectoryProvider)this.allDocumentIdsByDirectoryProvider, this.directoryChainLoader).withSourceOf(dto)));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DOCUMENT_SUBFIELD_VALUE, dto -> {
            List keyValue = ListUtil.toList((String)dto.getValue(), (String)"=");
            return new AccessToItemAdaptingMatcher((Matcher)new FileRecordSubfieldValueMatcher(this.directoryChainLoader, (AllIdsByDirectoryProvider)this.allDocumentIdsByDirectoryProvider, this.richRecordLoader, FieldTypeId.parseSubfield((String)((String)keyValue.get(0))), (String)keyValue.get(1)).withSourceOf(dto));
        });
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DOCUMENT_COLLECTION, dto -> new AccessToItemAdaptingMatcher((Matcher)new FileRecordCollectionMatcher(new DocumentDirectoryLoader(this.directoryChainLoader, (ByIdLoadable)this.directoryLoader, (AllIdsByDirectoryProvider)this.allDocumentIdsByDirectoryProvider), this.recordCollectionPersistentStorageContainQuery, StringToUuidConverter.INSTANCE.convert(dto.getValue())).withSourceOf(dto)));
        IdAndIdsLoadable matcherLoader = this.modelBeanBuilder.allByIdsLoader(MatcherEntity.class);
        FilterMatcherRelationDtoLoaderJpa filterMatcherRelationDtoLoader = new FilterMatcherRelationDtoLoaderJpa((JpaRepository)new SimpleJpaRepository(FilterMatcherRelationEntity.class, this.entityManager));
        SpringDbFilterEntityLoader filterEntityLoader = new SpringDbFilterEntityLoader(this.jdbcTemplate, this.queryFactory, (FilterMatcherRelationDtoLoader)filterMatcherRelationDtoLoader, (AllByIdsLoadable)matcherLoader);
        FilterLoaderByRowLoader bean = new FilterLoaderByRowLoader(filterEntityLoader, matcherFactory);
        this.cacheService.registerSpringCacheCleaner(IdentifiedFilter.class.getSimpleName(), "filterByRootId");
        return bean;
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FileDataStreamer securedFileDataStreamer() {
        return new SecuredFileDataStreamer(this.fileDataStreamer, this.authenticationHolder, this.identifiedFileLoader, this.securityManager, this.currentDepartmentProvider, SecurityActions.FILE_SHOW);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FileDataStreamer securedFileTextDataStreamer() {
        return new SecuredFileDataStreamer(this.fileTextDataStreamer, this.authenticationHolder, this.identifiedFileLoader, this.securityManager, this.currentDepartmentProvider, SecurityActions.FILE_TEXT_SHOW);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.AUTH_SWITCH_ACTIVE_USER, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActive(), this.permissionFactory.subjectUserIsEvided(), (auth, ctx, targetUser) -> !auth.getActiveUser().equals(targetUser) ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Cannot switch to yourself")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}), (auth, ctx, targetUser) -> auth.getAuthenticatedUser().equals(targetUser) ? PermissionResult.allow() : PermissionResult.forbidden(), this.permissionFactory.canRepresentUser()})}));
    }

    @ConstructorProperties(value={"publicContextPath", "traceIdRepository", "entityManager", "modelBeanBuilder", "userSearchLoader", "departmentAccessor", "settingLoader", "currentDepartmentWebResolver", "currentDepartmentProvider", "authenticationHolder", "permissionRegistry", "permissionFactory", "securityManager", "trustResolver", "securityContextRepository", "failureHandler", "redirectParameterSearchingSuccessHandler", "logoutController", "stringIdUserLoader", "applicationEventPublisher", "serverUrlConfiguration", "exceptionResponseLogger", "exceptionModelAndViewResolver", "serverUrlWebResolver", "jdbcTemplate", "queryFactory", "richRecordLoader", "cacheService", "directoryLoader", "directoryChainLoader", "internalIpResolver", "allDocumentIdsByDirectoryProvider", "fileDataStreamer", "fileTextDataStreamer", "identifiedFileLoader", "anonymAuthHttpSecurityConfigurer", "jwtAuthHttpSecurityConfigurer", "ezakAuthenticationHttpSecurityConfigurer", "oauth2AuthorizationCodeAuthHttpSecurityConfigurer", "openIdAuthHttpSecurityConfigurer", "saml2ServiceProviderHttpSecurityConfigurer", "httpbasicAuthenticationHttpSecurityConfigurer", "tokenAuthenticationHttpSecurityConfigurer", "userAgentAuthenticationHttpSecurityConfigurer", "compositeUserAuthenticationAuthenticationResolver", "authenticationEventSavingTypes", "userPrefAccessor", "recordCollectionPersistentStorageContainQuery"})
    @Generated
    public SecurityConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull TraceIdRepository traceIdRepository, @NonNull EntityManager entityManager, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader, @NonNull HierarchyContextsByModeLoader<Department> departmentAccessor, @NonNull SettingLoader settingLoader, @NonNull WebResolver<Department> currentDepartmentWebResolver, @NonNull Provider<Department> currentDepartmentProvider, @NonNull AuthenticationHolder authenticationHolder, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull SecurityManager securityManager, @NonNull AuthenticationTrustResolver trustResolver, @NonNull SecurityContextRepository securityContextRepository, @NonNull AuthenticationFailureHandler failureHandler, @NonNull AuthenticationSuccessHandler redirectParameterSearchingSuccessHandler, @NonNull LogoutController logoutController, @NonNull ByIdLoadable<User, String> stringIdUserLoader, @NonNull ApplicationEventPublisher applicationEventPublisher, @NonNull ServerUrlConfiguration serverUrlConfiguration, @NonNull ExceptionResponseLogger exceptionResponseLogger, @NonNull ExceptionModelAndViewResolver exceptionModelAndViewResolver, @NonNull UrlWebResolver serverUrlWebResolver, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull AllByIdsLoadable<RichRecord, UUID> richRecordLoader, @NonNull CacheService cacheService, @NonNull DirectoryLoader directoryLoader, @NonNull DirectoryChainLoader directoryChainLoader, @NonNull IpAddressInRangeResolver internalIpResolver, @NonNull SpringDbAllDocumentIdsByDirectoryLoader allDocumentIdsByDirectoryProvider, @NonNull FileDataStreamer fileDataStreamer, @NonNull FileDataStreamer fileTextDataStreamer, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull Consumer<HttpSecurity> anonymAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> jwtAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> ezakAuthenticationHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> oauth2AuthorizationCodeAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> openIdAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> saml2ServiceProviderHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> httpbasicAuthenticationHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> tokenAuthenticationHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> userAgentAuthenticationHttpSecurityConfigurer, @NonNull CompositeUserAuthenticationAuthenticationResolver compositeUserAuthenticationAuthenticationResolver, @NonNull List<Class<? extends AuthoritiedSuccessAuthentication>> authenticationEventSavingTypes, @NonNull UserPrefAccessor userPrefAccessor, @NonNull RecordCollectionContainQuery recordCollectionPersistentStorageContainQuery) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(traceIdRepository, "traceIdRepository is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentWebResolver, "currentDepartmentWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(trustResolver, "trustResolver is marked non-null but is null");
        Objects.requireNonNull(securityContextRepository, "securityContextRepository is marked non-null but is null");
        Objects.requireNonNull(failureHandler, "failureHandler is marked non-null but is null");
        Objects.requireNonNull(redirectParameterSearchingSuccessHandler, "redirectParameterSearchingSuccessHandler is marked non-null but is null");
        Objects.requireNonNull(logoutController, "logoutController is marked non-null but is null");
        Objects.requireNonNull(stringIdUserLoader, "stringIdUserLoader is marked non-null but is null");
        Objects.requireNonNull(applicationEventPublisher, "applicationEventPublisher is marked non-null but is null");
        Objects.requireNonNull(serverUrlConfiguration, "serverUrlConfiguration is marked non-null but is null");
        Objects.requireNonNull(exceptionResponseLogger, "exceptionResponseLogger is marked non-null but is null");
        Objects.requireNonNull(exceptionModelAndViewResolver, "exceptionModelAndViewResolver is marked non-null but is null");
        Objects.requireNonNull(serverUrlWebResolver, "serverUrlWebResolver is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(directoryChainLoader, "directoryChainLoader is marked non-null but is null");
        Objects.requireNonNull(internalIpResolver, "internalIpResolver is marked non-null but is null");
        Objects.requireNonNull(allDocumentIdsByDirectoryProvider, "allDocumentIdsByDirectoryProvider is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(fileTextDataStreamer, "fileTextDataStreamer is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(anonymAuthHttpSecurityConfigurer, "anonymAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(jwtAuthHttpSecurityConfigurer, "jwtAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(ezakAuthenticationHttpSecurityConfigurer, "ezakAuthenticationHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(oauth2AuthorizationCodeAuthHttpSecurityConfigurer, "oauth2AuthorizationCodeAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(openIdAuthHttpSecurityConfigurer, "openIdAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(saml2ServiceProviderHttpSecurityConfigurer, "saml2ServiceProviderHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(httpbasicAuthenticationHttpSecurityConfigurer, "httpbasicAuthenticationHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(tokenAuthenticationHttpSecurityConfigurer, "tokenAuthenticationHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(userAgentAuthenticationHttpSecurityConfigurer, "userAgentAuthenticationHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(compositeUserAuthenticationAuthenticationResolver, "compositeUserAuthenticationAuthenticationResolver is marked non-null but is null");
        Objects.requireNonNull(authenticationEventSavingTypes, "authenticationEventSavingTypes is marked non-null but is null");
        Objects.requireNonNull(userPrefAccessor, "userPrefAccessor is marked non-null but is null");
        Objects.requireNonNull(recordCollectionPersistentStorageContainQuery, "recordCollectionPersistentStorageContainQuery is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.traceIdRepository = traceIdRepository;
        this.entityManager = entityManager;
        this.modelBeanBuilder = modelBeanBuilder;
        this.userSearchLoader = userSearchLoader;
        this.departmentAccessor = departmentAccessor;
        this.settingLoader = settingLoader;
        this.currentDepartmentWebResolver = currentDepartmentWebResolver;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.authenticationHolder = authenticationHolder;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.securityManager = securityManager;
        this.trustResolver = trustResolver;
        this.securityContextRepository = securityContextRepository;
        this.failureHandler = failureHandler;
        this.redirectParameterSearchingSuccessHandler = redirectParameterSearchingSuccessHandler;
        this.logoutController = logoutController;
        this.stringIdUserLoader = stringIdUserLoader;
        this.applicationEventPublisher = applicationEventPublisher;
        this.serverUrlConfiguration = serverUrlConfiguration;
        this.exceptionResponseLogger = exceptionResponseLogger;
        this.exceptionModelAndViewResolver = exceptionModelAndViewResolver;
        this.serverUrlWebResolver = serverUrlWebResolver;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.richRecordLoader = richRecordLoader;
        this.cacheService = cacheService;
        this.directoryLoader = directoryLoader;
        this.directoryChainLoader = directoryChainLoader;
        this.internalIpResolver = internalIpResolver;
        this.allDocumentIdsByDirectoryProvider = allDocumentIdsByDirectoryProvider;
        this.fileDataStreamer = fileDataStreamer;
        this.fileTextDataStreamer = fileTextDataStreamer;
        this.identifiedFileLoader = identifiedFileLoader;
        this.anonymAuthHttpSecurityConfigurer = anonymAuthHttpSecurityConfigurer;
        this.jwtAuthHttpSecurityConfigurer = jwtAuthHttpSecurityConfigurer;
        this.ezakAuthenticationHttpSecurityConfigurer = ezakAuthenticationHttpSecurityConfigurer;
        this.oauth2AuthorizationCodeAuthHttpSecurityConfigurer = oauth2AuthorizationCodeAuthHttpSecurityConfigurer;
        this.openIdAuthHttpSecurityConfigurer = openIdAuthHttpSecurityConfigurer;
        this.saml2ServiceProviderHttpSecurityConfigurer = saml2ServiceProviderHttpSecurityConfigurer;
        this.httpbasicAuthenticationHttpSecurityConfigurer = httpbasicAuthenticationHttpSecurityConfigurer;
        this.tokenAuthenticationHttpSecurityConfigurer = tokenAuthenticationHttpSecurityConfigurer;
        this.userAgentAuthenticationHttpSecurityConfigurer = userAgentAuthenticationHttpSecurityConfigurer;
        this.compositeUserAuthenticationAuthenticationResolver = compositeUserAuthenticationAuthenticationResolver;
        this.authenticationEventSavingTypes = authenticationEventSavingTypes;
        this.userPrefAccessor = userPrefAccessor;
        this.recordCollectionPersistentStorageContainQuery = recordCollectionPersistentStorageContainQuery;
    }
}

