/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.autocomplete.AutocompleteByGroupLoader;
import cz.kpsys.portaro.autocomplete.AutocompleteByGroupLoaderDispatcher;
import cz.kpsys.portaro.autocomplete.AutocompleteLoader;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SameTypeSettableProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllProvidingRepository;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.datasource.Datasource;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.export.ExportDescriptorLoader;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.object.PhraseAutocompleteByGroupLoader;
import cz.kpsys.portaro.object.PhraseEntityLoader;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.newestdocuments.NewestDocumentsService;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.MapToMapSearchParamsConverter;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.Search;
import cz.kpsys.portaro.search.UntypedSearcherFactory;
import cz.kpsys.portaro.search.UntypedSearcherImpl;
import cz.kpsys.portaro.search.factory.SearchFactory;
import cz.kpsys.portaro.search.factory.SearchFactoryResolver;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsAutocompleteLoader;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsLoader;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsSaver;
import cz.kpsys.portaro.search.lucene.facets.FacetType;
import cz.kpsys.portaro.search.restriction.Restriction;
import cz.kpsys.portaro.search.sorting.Sorting;
import cz.kpsys.portaro.search.view.CompositeSearchFormFactory;
import cz.kpsys.portaro.search.view.SearchFormFactory;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.search.view.SearchViewFactory;
import cz.kpsys.portaro.search.view.ViewableSearchField;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.view.web.rest.AutocompleteApiController;
import cz.kpsys.portaro.view.web.rest.FacetTypeApiController;
import cz.kpsys.portaro.view.web.rest.FacetTypeRequest;
import cz.kpsys.portaro.view.web.rest.NewestDocumentsApiController;
import cz.kpsys.portaro.view.web.rest.QueryConversionApiController;
import cz.kpsys.portaro.view.web.rest.SearchApiController;
import cz.kpsys.portaro.view.web.rest.SearchHistoryApiController;
import cz.kpsys.portaro.view.web.rss.RssController;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class SearchViewConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider;
    @NonNull
    private final AllValuesProvider<Fond> allowedDocumentFondsProvider;
    @NonNull
    private final AllByIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final Repository<Search<? extends MapBackedParams, ?>, UUID> searchRepository;
    @NonNull
    private final AllValuesProvider<Sorting> documentSearchSortingLoader;
    @NonNull
    private final AllValuesProvider<Sorting> authoritySearchSortingLoader;
    @NonNull
    private final AllValuesProvider<Sorting> exemplarSearchSortingLoader;
    @NonNull
    private final SameTypeSettableProvider<Integer> documentDefaultPageSizeProvider;
    @NonNull
    private final AllProvidingRepository<Search<MapBackedParams, ?>, UUID> searchHistory;
    @NonNull
    private final PageSearchLoader<MapBackedParams, UUID> newestDocumentsLoader;
    @NonNull
    private final NewestDocumentsService newestDocumentsService;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final SearchedKeywordsLoader searchedKeywordsLoader;
    @NonNull
    private final Converter<Restriction<? extends SearchField>, String> restrictionToLuceneQueryConverter;
    @NonNull
    private final Converter<Restriction<? extends SearchField>, String> restrictionToZServerQueryConverter;
    @NonNull
    private final PhraseEntityLoader phraseEntityLoader;
    @NonNull
    private final SearchFactoryResolver searchFactoryResolver;
    @NonNull
    private final SearchFactory globalSearchFactory;
    @NonNull
    private final SearchFactory documentIndexSearchFactory;
    @NonNull
    private final SearchFactory topRatedSearchFactory;
    @NonNull
    private final SearchFactory newestSearchFactory;
    @NonNull
    private final SearchFactory authorityIndexSearchFactory;
    @NonNull
    private final SearchFactory mostLentSearchFactory;
    @NonNull
    private final SearchFactory mostWatchedSearchFactory;
    @NonNull
    private final SearchFactory exemplarSearchFactory;
    @NonNull
    private final SearchFactory userSearchFactory;
    @NonNull
    private final SearchFactory fileSearchFactory;
    @NonNull
    private final SearchFactory paymentSearchFactory;
    @NonNull
    private final SearchFactory loanSearchFactory;
    @NonNull
    private final SearchFactory recordOperationSearchFactory;
    @NonNull
    private final SearchFactory inventorySearchFactory;
    @NonNull
    private final SearchFactory captureSearchFactory;
    @NonNull
    private final SearchFactory matchSearchFactory;
    @NonNull
    private final SearchFactory recordRequestSearchFactory;
    @NonNull
    private final SearchFactory reminderSearchFactory;
    @NonNull
    private final SearchFactory messageSearchFactory;
    @NonNull
    private final SearchFactory zServerSearchFactory;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final SearchTextResolver searchTitleResolver;
    @NonNull
    private final SearchTextResolver searchSubtitleResolver;
    @NonNull
    private final Codebook<FacetType, Integer> facetTypeLoader;
    @NonNull
    private final Saver<FacetType> facetTypeSaver;
    @NonNull
    private final ExportDescriptorLoader exportDescriptorLoader;
    @NonNull
    private final SearchFormFactory fieldsTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory searchSelectionTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory newestTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory mostWatchedTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory topRatedTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory mostLentTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory documentIndexTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory authorityIndexTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory exemplarSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory userSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory recordOperationTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory fileSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory paymentSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory inventorySearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory matchSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory loanSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory loanReminderSearchTypeSearchFormFactory;
    @NonNull
    private final SearchFormFactory messageSearchTypeSearchFormFactory;
    @NonNull
    private final SearchedKeywordsSaver searchedKeywordsSaver;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final BiFunction<Department, SearchField, ViewableSearchField> departmentedSearchFieldToViewableSearchFieldConverter;
    @NonNull
    private final MapToMapSearchParamsConverter mapToMapSearchParamsConverter;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final Converter<FacetTypeRequest, FacetType> facetTypeRequestToFacetTypeConverter;

    @Bean
    public AutocompleteApiController autocompleteApiController() {
        AutocompleteByGroupLoaderDispatcher autocompleteByGroupLoader = new AutocompleteByGroupLoaderDispatcher().withByGroupLoader("FRZ", (AutocompleteByGroupLoader)new PhraseAutocompleteByGroupLoader(this.phraseEntityLoader).caseInsensitive()).withLoader("searched-terms", (AutocompleteLoader)new SearchedKeywordsAutocompleteLoader(this.searchedKeywordsLoader)).withStaticStringValues("prefix-university-degrees", new String[]{"Bc.", "BcA.", "DiS.", "dr.", "Ing.", "Ing. arch.", "JUDr.", "MDDr.", "MgA.", "Mgr.", "MUDr.", "MVDr.", "Ph.", "PharmDr.", "PhDr.", "RNDr.", "Th.", "ThDr.", "ThLic."}).withStaticStringValues("suffix-university-degrees", new String[]{"DiS.", "doc.", "dr.", "DSc.", "Ph.", "prof.", "Th.", "Ph.D.", "Th.D.", "CSc.", "DrSc.", "PaedDr.", "PhMr."});
        return new AutocompleteApiController((AutocompleteByGroupLoader)autocompleteByGroupLoader);
    }

    @Bean
    public FacetTypeApiController facetTypeController() {
        return new FacetTypeApiController(this.facetTypeLoader, this.facetTypeSaver, this.facetTypeRequestToFacetTypeConverter);
    }

    @Bean
    public SearchApiController searchApiController() {
        return new SearchApiController(this.actionSaver, this.searchFactoryResolver, this.publicContextPath, this.searchRepository, (Provider)this.documentDefaultPageSizeProvider, this.searchViewFactory(), this.searchHistory, this.searchedKeywordsSaver);
    }

    @Bean
    public NewestDocumentsApiController newestDocumentsApiController() {
        return new NewestDocumentsApiController(this.newestDocumentsService);
    }

    @Bean
    public QueryConversionApiController queryConversionApiController() {
        return new QueryConversionApiController(this.restrictionToLuceneQueryConverter, this.restrictionToZServerQueryConverter);
    }

    @Bean
    public SearchHistoryApiController searchHistoryApiController() {
        return new SearchHistoryApiController(this.translator, (AllValuesProvider)this.searchHistory, this.searchTitleResolver, this.publicContextPath, this.departmentedSearchFieldToViewableSearchFieldConverter);
    }

    @Bean
    public RssController rssController() {
        return new RssController(this.newestDocumentsLoader, this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORDS), this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORD_STATUSES), this.settingLoader.getOnRootProvidedList(SettingKeys.NEWS_EXEMPLAR_STATUSES), this.allowedDocumentFondsProvider, this.nonDetailedDocumentLoader, this.systemInstitutionProvider, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull(), this.modelAndPageViewFactory);
    }

    @Bean
    public SearchFormFactory searchFormFactory() {
        return new CompositeSearchFormFactory().with("fields", this.fieldsTypeSearchFormFactory).with("search-selection", this.searchSelectionTypeSearchFormFactory).with("newest", this.newestTypeSearchFormFactory).with("most-watched", this.mostWatchedTypeSearchFormFactory).with("top-rated", this.topRatedTypeSearchFormFactory).with("most-lent", this.mostLentTypeSearchFormFactory).with("document-index", this.documentIndexTypeSearchFormFactory).with("authority-index", this.authorityIndexTypeSearchFormFactory).with("exemplar-search", this.exemplarSearchTypeSearchFormFactory).with("user-search", this.userSearchTypeSearchFormFactory).with("record-operation-search", this.recordOperationTypeSearchFormFactory).with("file-search", this.fileSearchTypeSearchFormFactory).with("payment-search", this.paymentSearchTypeSearchFormFactory).with("inventory-search", this.inventorySearchTypeSearchFormFactory).with("match-search", this.matchSearchTypeSearchFormFactory).with("loan-search", this.loanSearchTypeSearchFormFactory).with("loan-reminder-search", this.loanReminderSearchTypeSearchFormFactory).with("message-search", this.messageSearchTypeSearchFormFactory);
    }

    @Bean
    public SearchViewFactory searchViewFactory() {
        return new SearchViewFactory(this.authoritySearchSortingLoader, this.documentSearchSortingLoader, this.exemplarSearchSortingLoader, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_EXPANDED_FACETS), this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull(), this.allowedDatasetsDepartmentedProvider, this.searchTitleResolver, this.searchSubtitleResolver, this.exportDescriptorLoader, this.searchFormFactory(), this.securityManager);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public UntypedSearcherFactory untypedSearcherFactory() {
        return (currentDepartment, locale) -> new UntypedSearcherImpl(this.searchFactoryResolver, this.mapToMapSearchParamsConverter, currentDepartment, locale);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerSearchFactories() {
        this.searchFactoryResolver.with(this.newestSearchFactory).with(this.mostWatchedSearchFactory).with(this.topRatedSearchFactory).with(this.mostLentSearchFactory).with(this.documentIndexSearchFactory).with(this.authorityIndexSearchFactory).with(this.exemplarSearchFactory).with(this.userSearchFactory).with(this.fileSearchFactory).with(this.paymentSearchFactory).with(this.loanSearchFactory).with(this.recordOperationSearchFactory).with(this.inventorySearchFactory).with(this.captureSearchFactory).with(this.matchSearchFactory).with(this.recordRequestSearchFactory).with(this.zServerSearchFactory).with(this.reminderSearchFactory).with(this.messageSearchFactory).with(this.globalSearchFactory);
    }

    @ConstructorProperties(value={"publicContextPath", "settingLoader", "translator", "allowedDatasetsDepartmentedProvider", "allowedDocumentFondsProvider", "nonDetailedDocumentLoader", "searchRepository", "documentSearchSortingLoader", "authoritySearchSortingLoader", "exemplarSearchSortingLoader", "documentDefaultPageSizeProvider", "searchHistory", "newestDocumentsLoader", "newestDocumentsService", "systemInstitutionProvider", "searchedKeywordsLoader", "restrictionToLuceneQueryConverter", "restrictionToZServerQueryConverter", "phraseEntityLoader", "searchFactoryResolver", "globalSearchFactory", "documentIndexSearchFactory", "topRatedSearchFactory", "newestSearchFactory", "authorityIndexSearchFactory", "mostLentSearchFactory", "mostWatchedSearchFactory", "exemplarSearchFactory", "userSearchFactory", "fileSearchFactory", "paymentSearchFactory", "loanSearchFactory", "recordOperationSearchFactory", "inventorySearchFactory", "captureSearchFactory", "matchSearchFactory", "recordRequestSearchFactory", "reminderSearchFactory", "messageSearchFactory", "zServerSearchFactory", "actionSaver", "searchTitleResolver", "searchSubtitleResolver", "facetTypeLoader", "facetTypeSaver", "exportDescriptorLoader", "fieldsTypeSearchFormFactory", "searchSelectionTypeSearchFormFactory", "newestTypeSearchFormFactory", "mostWatchedTypeSearchFormFactory", "topRatedTypeSearchFormFactory", "mostLentTypeSearchFormFactory", "documentIndexTypeSearchFormFactory", "authorityIndexTypeSearchFormFactory", "exemplarSearchTypeSearchFormFactory", "userSearchTypeSearchFormFactory", "recordOperationTypeSearchFormFactory", "fileSearchTypeSearchFormFactory", "paymentSearchTypeSearchFormFactory", "inventorySearchTypeSearchFormFactory", "matchSearchTypeSearchFormFactory", "loanSearchTypeSearchFormFactory", "loanReminderSearchTypeSearchFormFactory", "messageSearchTypeSearchFormFactory", "searchedKeywordsSaver", "securityManager", "departmentedSearchFieldToViewableSearchFieldConverter", "mapToMapSearchParamsConverter", "modelAndPageViewFactory", "facetTypeRequestToFacetTypeConverter"})
    @Generated
    public SearchViewConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull SettingLoader settingLoader, @NonNull Translator<Department> translator, @NonNull @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider, @NonNull AllValuesProvider<Fond> allowedDocumentFondsProvider, @NonNull AllByIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull Repository<Search<? extends MapBackedParams, ?>, UUID> searchRepository, @NonNull AllValuesProvider<Sorting> documentSearchSortingLoader, @NonNull AllValuesProvider<Sorting> authoritySearchSortingLoader, @NonNull AllValuesProvider<Sorting> exemplarSearchSortingLoader, @NonNull SameTypeSettableProvider<Integer> documentDefaultPageSizeProvider, @NonNull AllProvidingRepository<Search<MapBackedParams, ?>, UUID> searchHistory, @NonNull PageSearchLoader<MapBackedParams, UUID> newestDocumentsLoader, @NonNull NewestDocumentsService newestDocumentsService, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull SearchedKeywordsLoader searchedKeywordsLoader, @NonNull Converter<Restriction<? extends SearchField>, String> restrictionToLuceneQueryConverter, @NonNull Converter<Restriction<? extends SearchField>, String> restrictionToZServerQueryConverter, @NonNull PhraseEntityLoader phraseEntityLoader, @NonNull SearchFactoryResolver searchFactoryResolver, @NonNull SearchFactory globalSearchFactory, @NonNull SearchFactory documentIndexSearchFactory, @NonNull SearchFactory topRatedSearchFactory, @NonNull SearchFactory newestSearchFactory, @NonNull SearchFactory authorityIndexSearchFactory, @NonNull SearchFactory mostLentSearchFactory, @NonNull SearchFactory mostWatchedSearchFactory, @NonNull SearchFactory exemplarSearchFactory, @NonNull SearchFactory userSearchFactory, @NonNull SearchFactory fileSearchFactory, @NonNull SearchFactory paymentSearchFactory, @NonNull SearchFactory loanSearchFactory, @NonNull SearchFactory recordOperationSearchFactory, @NonNull SearchFactory inventorySearchFactory, @NonNull SearchFactory captureSearchFactory, @NonNull SearchFactory matchSearchFactory, @NonNull SearchFactory recordRequestSearchFactory, @NonNull SearchFactory reminderSearchFactory, @NonNull SearchFactory messageSearchFactory, @NonNull SearchFactory zServerSearchFactory, @NonNull ActionSaver actionSaver, @NonNull SearchTextResolver searchTitleResolver, @NonNull SearchTextResolver searchSubtitleResolver, @NonNull Codebook<FacetType, Integer> facetTypeLoader, @NonNull Saver<FacetType> facetTypeSaver, @NonNull ExportDescriptorLoader exportDescriptorLoader, @NonNull SearchFormFactory fieldsTypeSearchFormFactory, @NonNull SearchFormFactory searchSelectionTypeSearchFormFactory, @NonNull SearchFormFactory newestTypeSearchFormFactory, @NonNull SearchFormFactory mostWatchedTypeSearchFormFactory, @NonNull SearchFormFactory topRatedTypeSearchFormFactory, @NonNull SearchFormFactory mostLentTypeSearchFormFactory, @NonNull SearchFormFactory documentIndexTypeSearchFormFactory, @NonNull SearchFormFactory authorityIndexTypeSearchFormFactory, @NonNull SearchFormFactory exemplarSearchTypeSearchFormFactory, @NonNull SearchFormFactory userSearchTypeSearchFormFactory, @NonNull SearchFormFactory recordOperationTypeSearchFormFactory, @NonNull SearchFormFactory fileSearchTypeSearchFormFactory, @NonNull SearchFormFactory paymentSearchTypeSearchFormFactory, @NonNull SearchFormFactory inventorySearchTypeSearchFormFactory, @NonNull SearchFormFactory matchSearchTypeSearchFormFactory, @NonNull SearchFormFactory loanSearchTypeSearchFormFactory, @NonNull SearchFormFactory loanReminderSearchTypeSearchFormFactory, @NonNull SearchFormFactory messageSearchTypeSearchFormFactory, @NonNull SearchedKeywordsSaver searchedKeywordsSaver, @NonNull SecurityManager securityManager, @NonNull BiFunction<Department, SearchField, ViewableSearchField> departmentedSearchFieldToViewableSearchFieldConverter, @NonNull MapToMapSearchParamsConverter mapToMapSearchParamsConverter, @NonNull ModelAndPageViewFactory modelAndPageViewFactory, @NonNull Converter<FacetTypeRequest, FacetType> facetTypeRequestToFacetTypeConverter) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(allowedDatasetsDepartmentedProvider, "allowedDatasetsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDocumentFondsProvider, "allowedDocumentFondsProvider is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(searchRepository, "searchRepository is marked non-null but is null");
        Objects.requireNonNull(documentSearchSortingLoader, "documentSearchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(authoritySearchSortingLoader, "authoritySearchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarSearchSortingLoader, "exemplarSearchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(documentDefaultPageSizeProvider, "documentDefaultPageSizeProvider is marked non-null but is null");
        Objects.requireNonNull(searchHistory, "searchHistory is marked non-null but is null");
        Objects.requireNonNull(newestDocumentsLoader, "newestDocumentsLoader is marked non-null but is null");
        Objects.requireNonNull(newestDocumentsService, "newestDocumentsService is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(searchedKeywordsLoader, "searchedKeywordsLoader is marked non-null but is null");
        Objects.requireNonNull(restrictionToLuceneQueryConverter, "restrictionToLuceneQueryConverter is marked non-null but is null");
        Objects.requireNonNull(restrictionToZServerQueryConverter, "restrictionToZServerQueryConverter is marked non-null but is null");
        Objects.requireNonNull(phraseEntityLoader, "phraseEntityLoader is marked non-null but is null");
        Objects.requireNonNull(searchFactoryResolver, "searchFactoryResolver is marked non-null but is null");
        Objects.requireNonNull(globalSearchFactory, "globalSearchFactory is marked non-null but is null");
        Objects.requireNonNull(documentIndexSearchFactory, "documentIndexSearchFactory is marked non-null but is null");
        Objects.requireNonNull(topRatedSearchFactory, "topRatedSearchFactory is marked non-null but is null");
        Objects.requireNonNull(newestSearchFactory, "newestSearchFactory is marked non-null but is null");
        Objects.requireNonNull(authorityIndexSearchFactory, "authorityIndexSearchFactory is marked non-null but is null");
        Objects.requireNonNull(mostLentSearchFactory, "mostLentSearchFactory is marked non-null but is null");
        Objects.requireNonNull(mostWatchedSearchFactory, "mostWatchedSearchFactory is marked non-null but is null");
        Objects.requireNonNull(exemplarSearchFactory, "exemplarSearchFactory is marked non-null but is null");
        Objects.requireNonNull(userSearchFactory, "userSearchFactory is marked non-null but is null");
        Objects.requireNonNull(fileSearchFactory, "fileSearchFactory is marked non-null but is null");
        Objects.requireNonNull(paymentSearchFactory, "paymentSearchFactory is marked non-null but is null");
        Objects.requireNonNull(loanSearchFactory, "loanSearchFactory is marked non-null but is null");
        Objects.requireNonNull(recordOperationSearchFactory, "recordOperationSearchFactory is marked non-null but is null");
        Objects.requireNonNull(inventorySearchFactory, "inventorySearchFactory is marked non-null but is null");
        Objects.requireNonNull(captureSearchFactory, "captureSearchFactory is marked non-null but is null");
        Objects.requireNonNull(matchSearchFactory, "matchSearchFactory is marked non-null but is null");
        Objects.requireNonNull(recordRequestSearchFactory, "recordRequestSearchFactory is marked non-null but is null");
        Objects.requireNonNull(reminderSearchFactory, "reminderSearchFactory is marked non-null but is null");
        Objects.requireNonNull(messageSearchFactory, "messageSearchFactory is marked non-null but is null");
        Objects.requireNonNull(zServerSearchFactory, "zServerSearchFactory is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(searchTitleResolver, "searchTitleResolver is marked non-null but is null");
        Objects.requireNonNull(searchSubtitleResolver, "searchSubtitleResolver is marked non-null but is null");
        Objects.requireNonNull(facetTypeLoader, "facetTypeLoader is marked non-null but is null");
        Objects.requireNonNull(facetTypeSaver, "facetTypeSaver is marked non-null but is null");
        Objects.requireNonNull(exportDescriptorLoader, "exportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(fieldsTypeSearchFormFactory, "fieldsTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(searchSelectionTypeSearchFormFactory, "searchSelectionTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(newestTypeSearchFormFactory, "newestTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(mostWatchedTypeSearchFormFactory, "mostWatchedTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(topRatedTypeSearchFormFactory, "topRatedTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(mostLentTypeSearchFormFactory, "mostLentTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(documentIndexTypeSearchFormFactory, "documentIndexTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(authorityIndexTypeSearchFormFactory, "authorityIndexTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(exemplarSearchTypeSearchFormFactory, "exemplarSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(userSearchTypeSearchFormFactory, "userSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeSearchFormFactory, "recordOperationTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(fileSearchTypeSearchFormFactory, "fileSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(paymentSearchTypeSearchFormFactory, "paymentSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(inventorySearchTypeSearchFormFactory, "inventorySearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(matchSearchTypeSearchFormFactory, "matchSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(loanSearchTypeSearchFormFactory, "loanSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(loanReminderSearchTypeSearchFormFactory, "loanReminderSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(messageSearchTypeSearchFormFactory, "messageSearchTypeSearchFormFactory is marked non-null but is null");
        Objects.requireNonNull(searchedKeywordsSaver, "searchedKeywordsSaver is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(departmentedSearchFieldToViewableSearchFieldConverter, "departmentedSearchFieldToViewableSearchFieldConverter is marked non-null but is null");
        Objects.requireNonNull(mapToMapSearchParamsConverter, "mapToMapSearchParamsConverter is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(facetTypeRequestToFacetTypeConverter, "facetTypeRequestToFacetTypeConverter is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.settingLoader = settingLoader;
        this.translator = translator;
        this.allowedDatasetsDepartmentedProvider = allowedDatasetsDepartmentedProvider;
        this.allowedDocumentFondsProvider = allowedDocumentFondsProvider;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.searchRepository = searchRepository;
        this.documentSearchSortingLoader = documentSearchSortingLoader;
        this.authoritySearchSortingLoader = authoritySearchSortingLoader;
        this.exemplarSearchSortingLoader = exemplarSearchSortingLoader;
        this.documentDefaultPageSizeProvider = documentDefaultPageSizeProvider;
        this.searchHistory = searchHistory;
        this.newestDocumentsLoader = newestDocumentsLoader;
        this.newestDocumentsService = newestDocumentsService;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.searchedKeywordsLoader = searchedKeywordsLoader;
        this.restrictionToLuceneQueryConverter = restrictionToLuceneQueryConverter;
        this.restrictionToZServerQueryConverter = restrictionToZServerQueryConverter;
        this.phraseEntityLoader = phraseEntityLoader;
        this.searchFactoryResolver = searchFactoryResolver;
        this.globalSearchFactory = globalSearchFactory;
        this.documentIndexSearchFactory = documentIndexSearchFactory;
        this.topRatedSearchFactory = topRatedSearchFactory;
        this.newestSearchFactory = newestSearchFactory;
        this.authorityIndexSearchFactory = authorityIndexSearchFactory;
        this.mostLentSearchFactory = mostLentSearchFactory;
        this.mostWatchedSearchFactory = mostWatchedSearchFactory;
        this.exemplarSearchFactory = exemplarSearchFactory;
        this.userSearchFactory = userSearchFactory;
        this.fileSearchFactory = fileSearchFactory;
        this.paymentSearchFactory = paymentSearchFactory;
        this.loanSearchFactory = loanSearchFactory;
        this.recordOperationSearchFactory = recordOperationSearchFactory;
        this.inventorySearchFactory = inventorySearchFactory;
        this.captureSearchFactory = captureSearchFactory;
        this.matchSearchFactory = matchSearchFactory;
        this.recordRequestSearchFactory = recordRequestSearchFactory;
        this.reminderSearchFactory = reminderSearchFactory;
        this.messageSearchFactory = messageSearchFactory;
        this.zServerSearchFactory = zServerSearchFactory;
        this.actionSaver = actionSaver;
        this.searchTitleResolver = searchTitleResolver;
        this.searchSubtitleResolver = searchSubtitleResolver;
        this.facetTypeLoader = facetTypeLoader;
        this.facetTypeSaver = facetTypeSaver;
        this.exportDescriptorLoader = exportDescriptorLoader;
        this.fieldsTypeSearchFormFactory = fieldsTypeSearchFormFactory;
        this.searchSelectionTypeSearchFormFactory = searchSelectionTypeSearchFormFactory;
        this.newestTypeSearchFormFactory = newestTypeSearchFormFactory;
        this.mostWatchedTypeSearchFormFactory = mostWatchedTypeSearchFormFactory;
        this.topRatedTypeSearchFormFactory = topRatedTypeSearchFormFactory;
        this.mostLentTypeSearchFormFactory = mostLentTypeSearchFormFactory;
        this.documentIndexTypeSearchFormFactory = documentIndexTypeSearchFormFactory;
        this.authorityIndexTypeSearchFormFactory = authorityIndexTypeSearchFormFactory;
        this.exemplarSearchTypeSearchFormFactory = exemplarSearchTypeSearchFormFactory;
        this.userSearchTypeSearchFormFactory = userSearchTypeSearchFormFactory;
        this.recordOperationTypeSearchFormFactory = recordOperationTypeSearchFormFactory;
        this.fileSearchTypeSearchFormFactory = fileSearchTypeSearchFormFactory;
        this.paymentSearchTypeSearchFormFactory = paymentSearchTypeSearchFormFactory;
        this.inventorySearchTypeSearchFormFactory = inventorySearchTypeSearchFormFactory;
        this.matchSearchTypeSearchFormFactory = matchSearchTypeSearchFormFactory;
        this.loanSearchTypeSearchFormFactory = loanSearchTypeSearchFormFactory;
        this.loanReminderSearchTypeSearchFormFactory = loanReminderSearchTypeSearchFormFactory;
        this.messageSearchTypeSearchFormFactory = messageSearchTypeSearchFormFactory;
        this.searchedKeywordsSaver = searchedKeywordsSaver;
        this.securityManager = securityManager;
        this.departmentedSearchFieldToViewableSearchFieldConverter = departmentedSearchFieldToViewableSearchFieldConverter;
        this.mapToMapSearchParamsConverter = mapToMapSearchParamsConverter;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.facetTypeRequestToFacetTypeConverter = facetTypeRequestToFacetTypeConverter;
    }
}

