/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.deletion.RecordDeleter;
import cz.kpsys.portaro.record.edit.RecordEditationFactory;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingMergeTableWriteGenerator;
import cz.kpsys.portaro.record.holding.RecordHoldingSourceLoader;
import cz.kpsys.portaro.record.merge.AppserverAuthorityMerger;
import cz.kpsys.portaro.record.merge.AuthorityMerger;
import cz.kpsys.portaro.record.merge.DefaultRecordDetailMerger;
import cz.kpsys.portaro.record.merge.DefaultRecordMerger;
import cz.kpsys.portaro.record.merge.DocumentMerger;
import cz.kpsys.portaro.record.merge.RecordDetailMerger;
import cz.kpsys.portaro.record.merge.RecordMerger;
import cz.kpsys.portaro.record.merge.SecuredRecordMerger;
import cz.kpsys.portaro.record.merge.TableWritesDocumentMerger;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.security.SecurityManager;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy
public class RecordMergeConfig {
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final IdAndIdsLoadable<? extends Record, UUID> recordLoader;
    @NonNull
    private final ContextualFunction<Record, Department, Boolean> departmentedRecordCanHaveExemplarsPredicate;
    @NonNull
    private final ContextualFunction<Record, Department, Boolean> subtreeDepartmentedRecordHasExemplarsPredicate;
    @NonNull
    private final RecordDeleter recordDeleter;
    @NonNull
    private final RecordEditationFactory recordEditationFactory;
    @NonNull
    private final RecordHoldingLoader recordHoldingLoader;
    @NonNull
    private final RecordHoldingSourceLoader recordHoldingSourceLoader;
    @NonNull
    private final ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader;
    @NonNull
    private final TableWriteGenerator<RecordOperation> recordOperationTableWriteGenerator;

    @Bean
    public RecordMerger recordMerger() {
        DefaultRecordMerger pure = new DefaultRecordMerger((RecordDetailMerger)new DefaultRecordDetailMerger(this.recordEditationFactory), (DocumentMerger)new TableWritesDocumentMerger(this.dmlAppserverService, this.recordDeleter, new RecordHoldingMergeTableWriteGenerator(this.recordHoldingLoader, this.recordHoldingSourceLoader), this.recordOperationTypeLoader, this.recordOperationTableWriteGenerator), (AuthorityMerger)new AppserverAuthorityMerger(this.appserverXmlMapper, this.mappingAppserver), this.recordLoader, this.departmentedRecordCanHaveExemplarsPredicate, this.subtreeDepartmentedRecordHasExemplarsPredicate);
        return new SecuredRecordMerger(this.securityManager, (RecordMerger)pure);
    }

    @ConstructorProperties(value={"mappingAppserver", "dmlAppserverService", "appserverXmlMapper", "securityManager", "recordLoader", "departmentedRecordCanHaveExemplarsPredicate", "subtreeDepartmentedRecordHasExemplarsPredicate", "recordDeleter", "recordEditationFactory", "recordHoldingLoader", "recordHoldingSourceLoader", "recordOperationTypeLoader", "recordOperationTableWriteGenerator"})
    @Generated
    public RecordMergeConfig(@NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull ObjectMapper appserverXmlMapper, @NonNull SecurityManager securityManager, @NonNull IdAndIdsLoadable<? extends Record, UUID> recordLoader, @NonNull ContextualFunction<Record, Department, Boolean> departmentedRecordCanHaveExemplarsPredicate, @NonNull ContextualFunction<Record, Department, Boolean> subtreeDepartmentedRecordHasExemplarsPredicate, @NonNull RecordDeleter recordDeleter, @NonNull RecordEditationFactory recordEditationFactory, @NonNull RecordHoldingLoader recordHoldingLoader, @NonNull RecordHoldingSourceLoader recordHoldingSourceLoader, @NonNull ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader, @NonNull TableWriteGenerator<RecordOperation> recordOperationTableWriteGenerator) {
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(recordLoader, "recordLoader is marked non-null but is null");
        Objects.requireNonNull(departmentedRecordCanHaveExemplarsPredicate, "departmentedRecordCanHaveExemplarsPredicate is marked non-null but is null");
        Objects.requireNonNull(subtreeDepartmentedRecordHasExemplarsPredicate, "subtreeDepartmentedRecordHasExemplarsPredicate is marked non-null but is null");
        Objects.requireNonNull(recordDeleter, "recordDeleter is marked non-null but is null");
        Objects.requireNonNull(recordEditationFactory, "recordEditationFactory is marked non-null but is null");
        Objects.requireNonNull(recordHoldingLoader, "recordHoldingLoader is marked non-null but is null");
        Objects.requireNonNull(recordHoldingSourceLoader, "recordHoldingSourceLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTableWriteGenerator, "recordOperationTableWriteGenerator is marked non-null but is null");
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.appserverXmlMapper = appserverXmlMapper;
        this.securityManager = securityManager;
        this.recordLoader = recordLoader;
        this.departmentedRecordCanHaveExemplarsPredicate = departmentedRecordCanHaveExemplarsPredicate;
        this.subtreeDepartmentedRecordHasExemplarsPredicate = subtreeDepartmentedRecordHasExemplarsPredicate;
        this.recordDeleter = recordDeleter;
        this.recordEditationFactory = recordEditationFactory;
        this.recordHoldingLoader = recordHoldingLoader;
        this.recordHoldingSourceLoader = recordHoldingSourceLoader;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.recordOperationTableWriteGenerator = recordOperationTableWriteGenerator;
    }
}

