/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.app.PortaroUrls;
import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.AppserverResponseHandler;
import cz.kpsys.portaro.appserver.mapping.AppserverSaveResponseHandler;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.barcode.BarCodeValidatorContextualProvider;
import cz.kpsys.portaro.commons.barcode.BarCodeType;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.barcode.BarCodeValidatorByBarCodeTypeProvider;
import cz.kpsys.portaro.commons.barcode.ValidLengthBarCodeValidator;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.cache.CacheDeleter;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualConsumer;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.web.StaticLink;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.ContextHierarchySelection;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.exemplar.AccessNumberSequenceItemLoaderDelegating;
import cz.kpsys.portaro.exemplar.ContextualRecordCanHaveExemplarsPredicate;
import cz.kpsys.portaro.exemplar.DepartmentedRecordExemplarsCountResolver;
import cz.kpsys.portaro.exemplar.DepartmentedRecordExemplarsDeleter;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarDescriptor;
import cz.kpsys.portaro.exemplar.ExemplarListSorter;
import cz.kpsys.portaro.exemplar.ExemplarLoader;
import cz.kpsys.portaro.exemplar.ExemplarProxy;
import cz.kpsys.portaro.exemplar.ExemplarRowMapper;
import cz.kpsys.portaro.exemplar.ExemplarSecurityActions;
import cz.kpsys.portaro.exemplar.ExemplarSequenceItemLoader;
import cz.kpsys.portaro.exemplar.ExemplarSettingKeys;
import cz.kpsys.portaro.exemplar.ExemplarWithDocumentAndDiscardion;
import cz.kpsys.portaro.exemplar.MultiPropertyExemplarComparator;
import cz.kpsys.portaro.exemplar.SearchingDepartmentedRecordExemplarsLoader;
import cz.kpsys.portaro.exemplar.SignatureSequenceItemLoaderDelegating;
import cz.kpsys.portaro.exemplar.SortingExemplarLoader;
import cz.kpsys.portaro.exemplar.SpringDbExemplarAllByIdsLoader;
import cz.kpsys.portaro.exemplar.SpringDbExemplarIdSearchLoader;
import cz.kpsys.portaro.exemplar.SpringDbExemplarLoader;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceItem;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceLoader;
import cz.kpsys.portaro.exemplar.accessnumber.SpringDbAccessNumberSequenceLoader;
import cz.kpsys.portaro.exemplar.account.Account;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayLoader;
import cz.kpsys.portaro.exemplar.customvalue.CustomValue;
import cz.kpsys.portaro.exemplar.delete.ExemplarDeleter;
import cz.kpsys.portaro.exemplar.delete.ExemplarDeleterAppserver;
import cz.kpsys.portaro.exemplar.delete.SecuredExemplarDeleter;
import cz.kpsys.portaro.exemplar.discard.DiscardNumberSequenceItemLoader;
import cz.kpsys.portaro.exemplar.discard.Discardion;
import cz.kpsys.portaro.exemplar.discard.DiscardionEntity;
import cz.kpsys.portaro.exemplar.discard.DiscardionFromDtoConverter;
import cz.kpsys.portaro.exemplar.discard.ExemplarDiscarder;
import cz.kpsys.portaro.exemplar.discard.ExemplarDiscarderAppserver;
import cz.kpsys.portaro.exemplar.discard.SpringDbDiscardNumberSequenceItemLoader;
import cz.kpsys.portaro.exemplar.edit.AppserverExemplarSaver;
import cz.kpsys.portaro.exemplar.edit.BarCodeTrimmingExemplarSaverProxy;
import cz.kpsys.portaro.exemplar.edit.EditedExemplar;
import cz.kpsys.portaro.exemplar.edit.ExemplarSaverFondChangingProxy;
import cz.kpsys.portaro.exemplar.edit.ExemplarValidator;
import cz.kpsys.portaro.exemplar.edit.SecuredExemplarSaver;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.export.ExportedExemplarsLoader;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategoryLoader;
import cz.kpsys.portaro.exemplar.regal.RegalLoader;
import cz.kpsys.portaro.exemplar.regal.RegalMap;
import cz.kpsys.portaro.exemplar.regal.RegalMapSaver;
import cz.kpsys.portaro.exemplar.regal.RegalService;
import cz.kpsys.portaro.exemplar.regal.SpringDbRegalLoader;
import cz.kpsys.portaro.exemplar.regal.SpringDbRegalMapLoader;
import cz.kpsys.portaro.exemplar.regal.SpringDbRegalMapSaver;
import cz.kpsys.portaro.exemplar.replacementway.ReplacementWay;
import cz.kpsys.portaro.exemplar.restore.ExemplarDiscardionRestorer;
import cz.kpsys.portaro.exemplar.restore.ExemplarDiscardionRestorerAppserver;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceFactory;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceItem;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceLoader;
import cz.kpsys.portaro.exemplar.signature.SpringDbSignatureSequenceLoader;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.exemplar.volume.SpringDbVolumeLoader;
import cz.kpsys.portaro.exemplar.volume.Volume;
import cz.kpsys.portaro.exemplar.volume.VolumeLoader;
import cz.kpsys.portaro.exemplar.volume.VolumeSaveTableWriteGenerator;
import cz.kpsys.portaro.exemplar.volumenumber.SpringDbVolumeNumberSequenceItemLoader;
import cz.kpsys.portaro.exemplar.volumenumber.VolumeNumberSequenceItemLoader;
import cz.kpsys.portaro.export.CsvFileExporter;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.SearchedItemsExporter;
import cz.kpsys.portaro.export.StaticExportDescriptorLoader;
import cz.kpsys.portaro.export.TableGeneratorXlsFileExporter;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordSaver;
import cz.kpsys.portaro.record.deletion.RecordDeletionCommand;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.search.ContextualCountPredicateGtZeroResolver;
import cz.kpsys.portaro.search.ItemCustomizableContextualSearchFunction;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.table.TableGenerator;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.Templates;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class ExemplarConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final ExemplarStatusLoader exemplarStatusLoader;
    @NonNull
    private final ByIdLoadable<Account, String> accountLoader;
    @NonNull
    private final LoanCategoryLoader loanCategoryLoader;
    @NonNull
    private final AcquisitionWayLoader acquisitionWayLoader;
    @NonNull
    private final Codebook<CustomValue, String> customValueLoader;
    @NonNull
    private final Codebook<ReplacementWay, String> replacementWayLoader;
    @NonNull
    private final ByIdLoadable<ThematicGroup, String> thematicGroupLoader;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final Provider<Fond> defaultDocumentFondProvider;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final ByIdLoadable<? extends Record, UUID> recordLoader;
    @NonNull
    private final RecordSaver recordSaver;
    @NonNull
    private final CacheDeletableById recordCache;
    @NonNull
    private final ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader;
    @NonNull
    private final TableWriteGenerator<RecordOperation> recordOperationTableWriteGenerator;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final StaticExportDescriptorLoader staticExportDescriptorLoader;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final BarCodeValidatorByBarCodeTypeProvider barCodeValidatorByBarCodeTypeProvider;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;

    @Bean
    public VolumeLoader volumeLoader() {
        return new SpringDbVolumeLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public Saver<Volume> volumeSaver() {
        return GenericTableWriteSaver.ofIdSettable((TableWriteGenerator)new VolumeSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (AppserverResponseHandler)AppserverSaveResponseHandler.forConcreteColumnIntegerId((String)"volume", (String)"id_vol"), List.of());
    }

    @Bean
    public RowMapper<Exemplar> exemplarRowMapper() {
        return new ExemplarRowMapper(this.locationLoader, this.departmentLoader, this.rootDepartmentProvider, this.thematicGroupLoader, (ByIdLoadable)this.loanCategoryLoader, (ByIdLoadable)this.exemplarStatusLoader, (ByIdLoadable)this.acquisitionWayLoader, this.accountLoader, this.fondLoader, (ByIdLoadable)this.customValueLoader);
    }

    @Bean
    public IdAndIdsLoadable<Exemplar, Integer> exemplarAllByIdsLoader() {
        SpringDbExemplarAllByIdsLoader exemplarAllByIdsLoader = new SpringDbExemplarAllByIdsLoader(this.jdbcTemplate, this.queryFactory, this.exemplarRowMapper());
        ChunkingAllByIdsLoader chunkingAllByIdsLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)exemplarAllByIdsLoader);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)chunkingAllByIdsLoader, Exemplar.class);
    }

    @Bean
    public ExemplarLoader exemplarLoader() {
        SpringDbExemplarLoader bean = new SpringDbExemplarLoader(this.jdbcTemplate, this.queryFactory, this.exemplarAllByIdsLoader(), this.exemplarRowMapper());
        return new SortingExemplarLoader((ExemplarLoader)bean, this.exemplarListSorter());
    }

    @Bean
    public ByIdLoadable<? extends ExemplarDescriptor, Integer> exemplarDescriptorLoader() {
        return this.exemplarLoader();
    }

    @Bean
    public ExemplarListSorter exemplarListSorter() {
        MultiPropertyExemplarComparator exemplarComparator = new MultiPropertyExemplarComparator(this.settingLoader.getOnRootProvidedList(SettingKeys.EXEMPLAR_SORT_PROPS));
        MultiPropertyExemplarComparator bindingComparator = new MultiPropertyExemplarComparator(this.settingLoader.getOnRootProvidedList(SettingKeys.BINDING_SORT_PROPS));
        MultiPropertyExemplarComparator issueComparator = new MultiPropertyExemplarComparator(this.settingLoader.getOnRootProvidedList(SettingKeys.ISSUE_SORT_PROPS));
        return new ExemplarListSorter((Comparator)exemplarComparator, (Comparator)bindingComparator, (Comparator)issueComparator);
    }

    @Bean
    public ExportedExemplarsLoader exportedExemplarsLoader() {
        return new ExportedExemplarsLoader((PageSearchLoader)this.exemplarSearchLoader(), this.exemplarListSorter(), (HierarchyContextsByModeLoader)this.departmentAccessor, this.departmentAccessor, this.settingLoader.getDepartmentedProvider(ExemplarSettingKeys.EXEMPLAR_STATUSES_EXPORT).throwingWhenNull().invalidWhen(Collection::isEmpty), this.securityManager);
    }

    @Bean
    public Codebook<RegalMap, String> regalMapLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbRegalMapLoader(this.jdbcTemplate, this.queryFactory)).staticCached(RegalMap.class.getSimpleName()).build();
    }

    @Bean
    public RegalMapSaver regalMapSaver() {
        return new SpringDbRegalMapSaver(this.jdbcTemplate, this.queryFactory, List.of(this.cacheService.createCleanerFor(RegalMap.class.getSimpleName())));
    }

    @Bean
    public RegalLoader regalLoader() {
        return new SpringDbRegalLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.regalMapLoader());
    }

    @Bean
    public RegalService regalService() {
        return new RegalService(this.regalLoader(), (ByIdLoadable)this.regalMapLoader(), this.settingLoader.getOnRootProvider(SettingKeys.REGAL_MAP_PROPERTY), (Provider)StaticProvider.of((Object)"signature"));
    }

    @Bean
    public ExemplarDeleter exemplarDeleter() {
        ProviderByIdProvider deletableExemplarStatusProvider = ProviderByIdProvider.ofStaticId((ByIdLoadable)this.exemplarStatusLoader, (Object)0);
        ExemplarDeleterAppserver bean = new ExemplarDeleterAppserver(this.mappingAppserver, (Provider)deletableExemplarStatusProvider, this.exemplarSaver(), this.appserverXmlMapper);
        return new SecuredExemplarDeleter((ExemplarDeleter)bean, this.securityManager);
    }

    @Bean
    public ExemplarDiscarder exemplarDiscarder() {
        ProviderByIdProvider discardedExemplarStatusProvider = ProviderByIdProvider.ofStaticId((ByIdLoadable)this.exemplarStatusLoader, (Object)11);
        return new ExemplarDiscarderAppserver(this.dmlAppserverService, this.exemplarLoader(), (Provider)discardedExemplarStatusProvider, this.recordOperationTypeLoader, this.recordOperationTableWriteGenerator, this.recordLoader);
    }

    @Bean
    public ExemplarDiscardionRestorer exemplarDiscardionRestorer() {
        ProviderByIdProvider restoredExemplarStatusProvider = ProviderByIdProvider.ofStaticId((ByIdLoadable)this.exemplarStatusLoader, (Object)7);
        return new ExemplarDiscardionRestorerAppserver(this.dmlAppserverService, this.exemplarLoader(), (Provider)restoredExemplarStatusProvider, this.recordOperationTypeLoader, this.recordOperationTableWriteGenerator, this.recordLoader);
    }

    @Bean
    public Saver<EditedExemplar> exemplarSaver() {
        AppserverExemplarSaver pure = this.pureExemplarSaver();
        ExemplarSaverFondChangingProxy exemplarSaverFondChangingProxy = new ExemplarSaverFondChangingProxy((Saver)pure, CatalogConstants.FONDS_FOR_CONVERT_FROM_AFTER_FIRST_EXEMPLAR_CREATION, this.defaultDocumentFondProvider, this.recordLoader, this.recordSaver, this.departmentAccessor, this.securityAccessor);
        BarCodeTrimmingExemplarSaverProxy barCodeTrimmingExemplarSaverProxy = new BarCodeTrimmingExemplarSaverProxy((Saver)exemplarSaverFondChangingProxy, this.exemplarBarCodeValidatorProvider());
        return new SecuredExemplarSaver((Saver)barCodeTrimmingExemplarSaverProxy, this.securityManager);
    }

    @Bean
    public AppserverExemplarSaver pureExemplarSaver() {
        return new AppserverExemplarSaver(this.dmlAppserverService, this.accessNumberSequenceItemLoader(), this.signatureSequenceItemLoader(), this.recordOperationTypeLoader, this.recordOperationTableWriteGenerator, this.recordLoader);
    }

    @Bean
    public ExemplarValidator exemplarValidator() {
        return new ExemplarValidator((PageSearchLoader)this.exemplarSearchLoader(), this.settingLoader.getDepartmentedProvider(SettingKeys.BUILDING_SCOPE_ACCESS_NUMBERS_UNIQUENESS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.TITLE_SIGNATURES_ENABLED), this.departmentAccessor);
    }

    @Bean
    public AccessNumberSequenceLoader accessNumberSequenceLoader() {
        return new SpringDbAccessNumberSequenceLoader(this.jdbcTemplate, this.queryFactory, this.locationLoader);
    }

    @Bean
    public ExemplarSequenceItemLoader<AccessNumberSequenceItem> accessNumberSequenceItemLoader() {
        return new AccessNumberSequenceItemLoaderDelegating((PageSearchLoader)this.exemplarSearchLoader(), this.accessNumberSequenceLoader(), this.settingLoader.getOnRootProvider(SettingKeys.BUILDING_SCOPE_ACCESS_NUMBERS_UNIQUENESS_ENABLED), this.departmentAccessor);
    }

    @Bean
    public SignatureSequenceLoader signatureSequenceLoader() {
        SignatureSequenceFactory factory = new SignatureSequenceFactory(this.settingLoader.getOnRootProvider(SettingKeys.TITLE_SIGNATURES_ENABLED));
        return new SpringDbSignatureSequenceLoader(this.jdbcTemplate, this.queryFactory, factory);
    }

    @Bean
    public ExemplarSequenceItemLoader<SignatureSequenceItem> signatureSequenceItemLoader() {
        return new SignatureSequenceItemLoaderDelegating(this.signatureSequenceLoader(), this.exemplarLoader(), this.exemplarSearchLoader(), this.settingLoader.getOnRootProvider(SettingKeys.TITLE_SIGNATURES_ENABLED));
    }

    @Bean
    public DiscardNumberSequenceItemLoader discardNumberSequenceItemLoader() {
        return new SpringDbDiscardNumberSequenceItemLoader(this.jdbcTemplate, this.queryFactory, this.settingLoader.getOnRootProvider(SettingKeys.DISCARD_NUMBERS_WITHIN_BUILDING_ENABLED));
    }

    @Bean
    public VolumeNumberSequenceItemLoader volumeNumberSequenceItemLoader() {
        return new SpringDbVolumeNumberSequenceItemLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public IdAndIdsLoadable<Discardion, Long> discardionLoader() {
        ListToModifiedListConverter entitiesToModelsConverter = new ListToModifiedListConverter((Converter)new DiscardionFromDtoConverter((ByIdLoadable)this.replacementWayLoader));
        return this.modelBeanBuilder.allByIdsLoader(DiscardionEntity.class, (Converter)entitiesToModelsConverter).build();
    }

    @Bean
    public PageSearchLoader<MapBackedParams, Integer> exemplarIdSearchLoader() {
        return new SpringDbExemplarIdSearchLoader(this.jdbcTemplate, this.queryFactory, this.departmentAccessor, this.accessNumberSequenceLoader(), this.signatureSequenceLoader(), (Provider)new StaticContextualDelegatingProvider(this.exemplarBarCodeValidatorProvider(), this.realRootDepartmentProvider));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Exemplar> exemplarSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.exemplarIdSearchLoader(), (AllByIdsLoadable)this.exemplarAllByIdsLoader()));
    }

    @Bean
    public CacheDeleter<Exemplar> exemplarCacheDeletable() {
        return exemplar -> this.recordCache.deleteFromCacheById((Object)exemplar.getRecordId());
    }

    @Bean
    public ContextualFunction<Record, Department, Boolean> departmentedRecordCanHaveExemplarsPredicate() {
        return new ContextualRecordCanHaveExemplarsPredicate();
    }

    @Bean
    public ContextualFunction<Record, Department, Boolean> subtreeDepartmentedRecordHasExemplarsPredicate() {
        return new ContextualCountPredicateGtZeroResolver(this.subtreeDepartmentedRecordExemplarsCountResolver());
    }

    @Bean
    public ContextualFunction<Record, Department, Boolean> singleNodeDepartmentedRecordHasExemplarsPredicate() {
        return new ContextualCountPredicateGtZeroResolver(this.singleNodeDepartmentedRecordExemplarsCountResolver());
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<Record, Department, Integer> subtreeDepartmentedRecordExemplarsCountResolver() {
        return new DepartmentedRecordExemplarsCountResolver(this.departmentedRecordCanHaveExemplarsPredicate(), this.exemplarIdSearchLoader(), (HierarchyContextsByModeLoader)this.departmentAccessor, ContextHierarchySelection.SUBTREE);
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<Record, Department, Integer> singleNodeDepartmentedRecordExemplarsCountResolver() {
        return new DepartmentedRecordExemplarsCountResolver(this.departmentedRecordCanHaveExemplarsPredicate(), this.exemplarIdSearchLoader(), (HierarchyContextsByModeLoader)this.departmentAccessor, ContextHierarchySelection.NODE);
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<Record, Department, List<Exemplar>> subtreeDepartmentedRecordExemplarsLoader() {
        return new SearchingDepartmentedRecordExemplarsLoader((PageSearchLoader)this.exemplarSearchLoader(), (HierarchyContextsByModeLoader)this.departmentAccessor, ContextHierarchySelection.SUBTREE);
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<Record, Department, List<Exemplar>> familyDepartmentedRecordExemplarsLoader() {
        return new SearchingDepartmentedRecordExemplarsLoader((PageSearchLoader)this.exemplarSearchLoader(), (HierarchyContextsByModeLoader)this.departmentAccessor, ContextHierarchySelection.FAMILY);
    }

    @Bean
    public ContextualConsumer<RecordDeletionCommand, Department> subtreeDepartmentedRecordExemplarsDeleter() {
        return new DepartmentedRecordExemplarsDeleter(this.subtreeDepartmentedRecordExemplarsLoader(), this.exemplarDeleter(), this.authenticationHolder);
    }

    @Bean
    public ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider() {
        return new BarCodeValidatorContextualProvider(this.barCodeValidatorByBarCodeTypeProvider.withAdditionalValidator(BarCodeType.CUSTOM, (BarCodeValidator)new ValidLengthBarCodeValidator(this.settingLoader.getOnRootProvider(SettingKeys.EXEMPLAR_BAR_CODE_MAX_LENGTH))), this.settingLoader.getDepartmentedProvider(SettingKeys.EXEMPLAR_BARCODE_TYPES));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        if (this.featureManager.isEnabled("exports")) {
            CsvFileExporter exemplarsCsvExporter = new CsvFileExporter("exemplars.csv", Templates.TEMPLATE_EXEMPLARS_CSV, Exemplar.class, "exemplars", this.templateEngine);
            this.exporterResolver.addStatic("exemplars-csv:", (Exporter)exemplarsCsvExporter);
            SearchedItemsExporter searchedExemplarsCsvExporter = SearchedItemsExporter.ofUnlimited((Exporter)exemplarsCsvExporter).withCacheDeleter(this.exemplarCacheDeletable());
            this.exporterResolver.addStatic("searched-exemplars-csv:", (Exporter)searchedExemplarsCsvExporter);
            TableGenerator tableGenerator = new TableGenerator().withColumn(Texts.ofMessageCoded((String)"exemplar.AccessNumber.abbr"), ExemplarProxy::getAccessNumber).withColumn(Texts.ofMessageCoded((String)"exemplar.Signature.abbr"), ExemplarProxy::getSignature).withColumn(Texts.ofMessageCoded((String)"exemplar.BarCode.abbr"), ExemplarProxy::getBarCode).withColumn(Texts.ofNative((String)"ISBN"), ExemplarWithDocumentAndDiscardion::getDocumentIsbn).withColumn(Texts.ofNative((String)"N\u00e1zev"), ExemplarWithDocumentAndDiscardion::getDocumentName).withColumn(Texts.ofNative((String)"Autor"), ExemplarWithDocumentAndDiscardion::getDocumentAuthor).withColumn(Texts.ofMessageCoded((String)"department.Department.abbr"), ExemplarProxy::getDepartment).withColumn(Texts.ofNative((String)"Lokace"), ExemplarProxy::getLocation).withColumn(Texts.ofNative((String)"Fond"), ExemplarProxy::getFond).withColumn(Texts.ofNative((String)"Dat.vytv."), ExemplarProxy::getCreationDate).withColumn(Texts.ofNative((String)"Dat.zm\u011bny"), ExemplarProxy::getLastModificationDate).withColumn(Texts.ofNative((String)"\u00dabyt.\u010d."), ExemplarWithDocumentAndDiscardion::getDiscardionDiscardNumber).withColumn(Texts.ofNative((String)"Cena"), ExemplarProxy::getPrice).withColumn(Texts.ofNative((String)"Kus\u016f"), ExemplarProxy::getQuantity).withColumn(Texts.ofNative((String)"URL"), exemplar -> StaticLink.ofWithoutBase((String)PortaroUrls.getRecordPath((UUID)exemplar.getRecordId())));
            SearchedItemsExporter searchedExemplarsXlsExporter = SearchedItemsExporter.ofUnlimited((Exporter)new TableGeneratorXlsFileExporter("exemplars.xls", this.translator, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull(), tableGenerator, ExemplarWithDocumentAndDiscardion.class).withHeader()).withCacheDeleter(this.exemplarCacheDeletable());
            this.exporterResolver.addStatic("searched-exemplars-xls:", (Exporter)searchedExemplarsXlsExporter);
        }
        this.staticExportDescriptorLoader.with(List.of("searched-exemplars", "csv", "download"), "searched-exemplars-csv:", Texts.ofMessageCoded((String)"export.CsvButton")).with(List.of("searched-exemplars", "xls", "download"), "searched-exemplars-xls:", Texts.ofMessageCoded((String)"export.XlsButton"));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Exemplar.class, (ByIdLoadable)this.exemplarLoader()).registerForIntegerId(ExemplarDescriptor.class, this.exemplarDescriptorLoader()).registerForStringId(RegalMap.class, (ByIdLoadable)this.regalMapLoader()).registerForIntegerId(Volume.class, (ByIdLoadable)this.volumeLoader());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        @NonNull ContextualProvider exemplarStatuses = this.settingLoader.getDepartmentedProvider(SettingKeys.EXEMPLAR_STATUSES);
        @NonNull ContextualProvider exportableExemplarStatuses = this.settingLoader.getDepartmentedProvider(ExemplarSettingKeys.EXEMPLAR_STATUSES_EXPORT);
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLARS_PAGE_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLARS_SHOW_OF_DOCUMENT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, document) -> document.isExemplarable() ? PermissionResult.allow() : PermissionResult.forbidden(), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}), (auth, ctx, document) -> {
            if (CatalogConstants.FONDS_FOR_CONVERT_FROM_AFTER_FIRST_EXEMPLAR_CREATION.contains(document.getFond().getId())) {
                return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8101)).can(auth, ctx, null);
            }
            return PermissionResult.forbidden();
        }}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_EXPORT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}), (auth, ctx, exemplar) -> ((List)exportableExemplarStatuses.getOn((Object)ctx)).contains(exemplar.getStatus().getId()) ? PermissionResult.allow() : PermissionResult.forbidden((Text)Texts.ofNative((String)"Exemplar status is not exportable"))}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}), (auth, ctx, exemplar) -> ((List)exemplarStatuses.getOn((Object)ctx)).contains(exemplar.getStatus().getId()) ? PermissionResult.allow() : PermissionResult.disabled((Text)Texts.ofNative((String)"Exemplar status is not showable"))}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_CREATE_ANY, this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8101)));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_CREATE_WITH_DEPARTMENT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, department) -> department.isExemplarable() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Department is not exemplarable")), PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.get(ExemplarSecurityActions.EXEMPLAR_CREATE_ANY))}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_EDIT_ANY, this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8102)));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_EDIT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.get(ExemplarSecurityActions.EXEMPLAR_EDIT_ANY)), PermissionResolver.adaptingSubject(Exemplar::getDepartment, (PermissionResolver)this.permissionFactory.editSubjectWithDepartment())}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_DISCARD, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8105)), PermissionResolver.adaptingSubject(Exemplar::getDepartment, (PermissionResolver)this.permissionFactory.editSubjectWithDepartment())}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8104)), PermissionResolver.adaptingSubject(Exemplar::getDepartment, (PermissionResolver)this.permissionFactory.editSubjectWithDepartment())}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_FIELD_GENERATE, this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8106)));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_ALL_FIELDS_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(ExemplarSecurityActions.LOAN_CATEGORIES_SHOW, this.permissionFactory.editAction(Integer.valueOf(4420)));
        this.permissionRegistry.add(ExemplarSecurityActions.LOAN_CATEGORY_CREATE, this.permissionFactory.editAction(Integer.valueOf(4421)));
        this.permissionRegistry.add(ExemplarSecurityActions.LOAN_CATEGORY_EDIT, this.permissionFactory.editAction(Integer.valueOf(4422)));
        this.permissionRegistry.add(ExemplarSecurityActions.LOAN_CATEGORY_DELETE, this.permissionFactory.editAction(Integer.valueOf(4423)));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_RESTORE, this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(8301)));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "cacheService", "locationLoader", "exemplarStatusLoader", "accountLoader", "loanCategoryLoader", "acquisitionWayLoader", "customValueLoader", "replacementWayLoader", "thematicGroupLoader", "mappingAppserver", "dmlAppserverService", "converterRegisterer", "authenticationHolder", "permissionRegistry", "securityManager", "permissionFactory", "fondLoader", "defaultDocumentFondProvider", "settingLoader", "templateEngine", "translator", "departmentLoader", "rootDepartmentProvider", "departmentAccessor", "securityAccessor", "recordLoader", "recordSaver", "recordCache", "recordOperationTypeLoader", "recordOperationTableWriteGenerator", "featureManager", "exporterResolver", "staticExportDescriptorLoader", "modelBeanBuilder", "codebookLoaderBuilderFactory", "appserverXmlMapper", "barCodeValidatorByBarCodeTypeProvider", "realRootDepartmentProvider"})
    @Generated
    public ExemplarConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CacheService cacheService, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull ExemplarStatusLoader exemplarStatusLoader, @NonNull ByIdLoadable<Account, String> accountLoader, @NonNull LoanCategoryLoader loanCategoryLoader, @NonNull AcquisitionWayLoader acquisitionWayLoader, @NonNull Codebook<CustomValue, String> customValueLoader, @NonNull Codebook<ReplacementWay, String> replacementWayLoader, @NonNull ByIdLoadable<ThematicGroup, String> thematicGroupLoader, @NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull ConverterRegisterer converterRegisterer, @NonNull AuthenticationHolder authenticationHolder, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull PermissionFactory permissionFactory, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull Provider<Fond> defaultDocumentFondProvider, @NonNull SettingLoader settingLoader, @NonNull TemplateEngine templateEngine, @NonNull Translator<Department> translator, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull Provider<Department> rootDepartmentProvider, @NonNull DepartmentAccessor departmentAccessor, @NonNull SecurityAccessor securityAccessor, @NonNull ByIdLoadable<? extends Record, UUID> recordLoader, @NonNull RecordSaver recordSaver, @NonNull CacheDeletableById recordCache, @NonNull ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader, @NonNull TableWriteGenerator<RecordOperation> recordOperationTableWriteGenerator, @NonNull FeatureManager featureManager, @NonNull ExporterResolver exporterResolver, @NonNull StaticExportDescriptorLoader staticExportDescriptorLoader, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ObjectMapper appserverXmlMapper, @NonNull BarCodeValidatorByBarCodeTypeProvider barCodeValidatorByBarCodeTypeProvider, @NonNull Provider<Department> realRootDepartmentProvider) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(accountLoader, "accountLoader is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(acquisitionWayLoader, "acquisitionWayLoader is marked non-null but is null");
        Objects.requireNonNull(customValueLoader, "customValueLoader is marked non-null but is null");
        Objects.requireNonNull(replacementWayLoader, "replacementWayLoader is marked non-null but is null");
        Objects.requireNonNull(thematicGroupLoader, "thematicGroupLoader is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(defaultDocumentFondProvider, "defaultDocumentFondProvider is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(recordLoader, "recordLoader is marked non-null but is null");
        Objects.requireNonNull(recordSaver, "recordSaver is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTableWriteGenerator, "recordOperationTableWriteGenerator is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(staticExportDescriptorLoader, "staticExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(barCodeValidatorByBarCodeTypeProvider, "barCodeValidatorByBarCodeTypeProvider is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.cacheService = cacheService;
        this.locationLoader = locationLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.accountLoader = accountLoader;
        this.loanCategoryLoader = loanCategoryLoader;
        this.acquisitionWayLoader = acquisitionWayLoader;
        this.customValueLoader = customValueLoader;
        this.replacementWayLoader = replacementWayLoader;
        this.thematicGroupLoader = thematicGroupLoader;
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.converterRegisterer = converterRegisterer;
        this.authenticationHolder = authenticationHolder;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
        this.fondLoader = fondLoader;
        this.defaultDocumentFondProvider = defaultDocumentFondProvider;
        this.settingLoader = settingLoader;
        this.templateEngine = templateEngine;
        this.translator = translator;
        this.departmentLoader = departmentLoader;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.departmentAccessor = departmentAccessor;
        this.securityAccessor = securityAccessor;
        this.recordLoader = recordLoader;
        this.recordSaver = recordSaver;
        this.recordCache = recordCache;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.recordOperationTableWriteGenerator = recordOperationTableWriteGenerator;
        this.featureManager = featureManager;
        this.exporterResolver = exporterResolver;
        this.staticExportDescriptorLoader = staticExportDescriptorLoader;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.appserverXmlMapper = appserverXmlMapper;
        this.barCodeValidatorByBarCodeTypeProvider = barCodeValidatorByBarCodeTypeProvider;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }
}

