<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>

<div class="search-selection-modal">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true" ng-click="$ctrl.close()">&times;</button>
        <h3 class="modal-title">
            <span ng-hide="$ctrl.title">${loc.loc("hledani.vybratZVyhledanych")?noEsc}</span>
            <span ng-show="$ctrl.title">{{$ctrl.title}}</span>
        </h3>
    </div>

    <div class="modal-body">

        <kp-svelte-component-wrapper ng-if="$ctrl.canShowForms()"
                                     component="::$ctrl.kpUniversalFormComponent"
                                     props="{formSettings: $ctrl.formSettings, model: $ctrl.searchModel, formControlOptions: $ctrl.formOptionsForDebounce}"
                                     ng-on-model-change="$ctrl.requestSearch()"
                                     ng-on-submit="$ctrl.tryToSubmit()">
        </kp-svelte-component-wrapper>

        <div class="row" style="margin-top: 20px;">
            <div ng-if="$ctrl.canCreateNew()" class="col-xs-12">
                <div class="pull-right">
                    <button ng-click="$ctrl.createNew()" class="btn btn-default btn-sm" ng-class="{'btn-primary': $ctrl.isResultEmpty()}">
                        ${loc.loc("record.editation.CreateNew")?noEsc}
                    </button>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top: 20px;">
            <jp-pagination ng-show="$ctrl.canShowResults()" jp-pagination="$ctrl.getPagination()" class="col-xs-12">

                <div class="selectable-item" ng-repeat="item in $parent.pagination.items track by $index" >

                    <kp-selectable-record-card record="item" is-selected="item === $ctrl.selectedItem" ng-if="$ctrl.isRecord(item)"></kp-selectable-record-card>
                    <kp-selectable-exemplar-card exemplar="item" is-selected="item === $ctrl.selectedItem" ng-if="$ctrl.isExemplar(item)"></kp-selectable-exemplar-card>

                    <kp-selectable-custom-template-card
                            model="item"
                            is-selected="item === $ctrl.selectedItem"
                            custom-template-url="$ctrl.customTemplateUrl"
                            ng-if="!$ctrl.isRecord(item) && !$ctrl.isExemplar(item) && $ctrl.customTemplateUrl"
                    >
                    </kp-selectable-custom-template-card>

                    <div class="item-selector" ng-click="$ctrl.select(item)"></div>
                </div>

            </jp-pagination>

            <kp-available-intents available-intents="$ctrl.getAvailableIntents()"
                                  new-search-with-params-callback="$ctrl.newSearchWithParams"
                                  defined-action-returned-value-handler="$ctrl.select"
                                  ng-show="$ctrl.getPagination().state.page === 'NORMAL'">
            </kp-available-intents>
        </div>

        <div ng-if="$ctrl.showQuantityInput()">
            <label>
                <span>${loc.loc("commons.PocetKusu")?noEsc}</span>
                <input class="form-control" type="number" ng-model="$ctrl.selectedItem.quantity" ng-required="true" jp-focus-when="$ctrl.showQuantityInput()" />
            </label>
        </div>

    </div>


    <div class="modal-footer">
        <button type="button" class="btn btn-primary" ng-if="!$ctrl.submitItemOnSelect()" ng-disabled="!$ctrl.isSubmittable()" ng-click="$ctrl.submitSelectedItem()" data-qa="search-selection-select">
            ${loc.loc("commons.Select")?noEsc}
        </button>
        <button type="button" class="btn btn-default" data-dismiss="modal" ng-click="$ctrl.close()" data-qa="search-selection-close">
            ${loc.loc("commons.zavrit")?noEsc}
        </button>
    </div>
</div>
