<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="panel-heading">
    <strong>${loc.loc("loan.Prezencne")?noEsc}</strong>
    <span class="label label-warning">${loc.loc("loan.Prezencni")?noEsc}</span>
</div>

<div class="panel-body">
    <p ng-if="group.requestItems.length === 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentJePrezencneNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentJePrezencneNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>
    <p ng-if="group.requestItems.length > 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentyJsouPrezencneNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentyJsouPrezencneNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>
    <p class="loan-request-option-buildings-list">
        <strong>{{option.capability.buildings|prop:'text'|inline:', '}}</strong>
    </p>
</div>