<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <div id="hledaneDotazy" class="container" ng-controller="SearchHistoryController as $ctrl">


        <div class="row">
            <div class="col-xs-12">
                <h1>${loc.loc("hledani.HistorieHledani")?noEsc}</h1>
            </div>
        </div>

        <div class="row">

            <div class="main-panel-hlavni col-sm-8">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>${loc.loc("hledani.DatumVyhledani")?noEsc}</th>
                            <th style="width: 50%">${loc.loc("hledani.VyhledavanyDotaz")?noEsc}</th>
                            <th style="width: 10%">${loc.loc("hledani.PocetVyhledanychZaznamu")?noEsc}</th>
                            <th>${loc.loc("commons.hledat")?noEsc}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="query in $ctrl.history" style="padding: 5px 3px;">
                            <td>{{query.date  | jpDate:'d.M.yyyy HH:mm'}}</td>
                            <td><samp><small>{{query.title}}</small></samp></td>
                            <td>{{query.totalElements}}</td>
                            <td><a ng-href="{{query.url}}">${loc.loc("commons.hledat")?noEsc}</a></td>
                        </tr>
                    </tbody>
                </table>
            </div>


            <!-- pravy sloupec -->
            <aside class="main-panel-pravy col-sm-4">
                <kp-svelte-component-wrapper component="::$ctrl.kpFavouritesPanelComponent"></kp-svelte-component-wrapper>
                <kp-svelte-component-wrapper component="::$ctrl.kpVisitedPanelComponent"></kp-svelte-component-wrapper>

            </aside>

        </div>


    </div>
</@layouts.full>