/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.appserver.Appserver;
import cz.kpsys.portaro.appserver.properties.AppserverPropertiesLoader;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.monitoring.health.AppserverHealthIndicator;
import cz.kpsys.portaro.monitoring.health.AppserverHealthMonitor;
import cz.kpsys.portaro.monitoring.health.MemoryHealthIndicator;
import cz.kpsys.portaro.monitoring.health.RunHealthIndicator;
import cz.kpsys.portaro.monitoring.info.AppserverInfoContributor;
import cz.kpsys.portaro.monitoring.info.InstallationInfoContributor;
import cz.kpsys.portaro.monitoring.info.InstanceInfoContributor;
import cz.kpsys.portaro.monitoring.info.LicenceInfoContributor;
import cz.kpsys.portaro.monitoring.info.TagsInfoContributor;
import cz.kpsys.portaro.setting.SettingLoader;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.actuate.logging.LogFileWebEndpoint;
import org.springframework.boot.actuate.management.HeapDumpWebEndpoint;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.InMemoryHttpExchangeRepository;
import org.springframework.boot.logging.LogFile;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.unit.DataSize;

@Configuration
public class MonitoringConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoringConfig.class);
    @NonNull
    private final String instanceName;
    @NonNull
    private final AppserverPropertiesLoader appserverPropertiesLoader;
    @NonNull
    private final Appserver appserver;
    @NonNull
    private final @NonNull Provider<@NonNull String> rootSerialCodeProvider;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final Date startTime;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ApplicationContext applicationContext;
    @NonNull
    private final AppserverHealthMonitor appserverHealthMonitor;
    @NonNull
    private final @NonNull Supplier<@NonNull Licence> licenceProvider;
    @NonNull
    private final DataSource dataSource;
    @NonNull
    private final DataSource notAutocommitDataSource;
    @NonNull
    private final DataSource fileStreamAutoCommittingDataSource;
    @NonNull
    private final DataSource notCriticalDataSource;
    @NonNull
    private final @NonNull Provider<@NonNull String> databaseProductNameProvider;

    @Bean
    public DataSourceHealthIndicator dataSourceHealthIndicator() {
        return new DataSourceHealthIndicator(this.dataSource);
    }

    @Bean
    public DataSourceHealthIndicator notAutocommitDataSourceHealthIndicator() {
        return new DataSourceHealthIndicator(this.notAutocommitDataSource);
    }

    @Bean
    public DataSourceHealthIndicator fileStreamAutoCommittingDataSourceHealthIndicator() {
        return new DataSourceHealthIndicator(this.fileStreamAutoCommittingDataSource);
    }

    @Bean
    public DataSourceHealthIndicator notCriticalDataSourceHealthIndicator() {
        return new DataSourceHealthIndicator(this.notCriticalDataSource);
    }

    @Bean
    public RunHealthIndicator portaroHealthIndicator() {
        return new RunHealthIndicator(this.settingLoader.getOnRootProvider(SettingKeys.SERVER_URL));
    }

    @Bean
    public MemoryHealthIndicator memoryHealthIndicator() {
        return new MemoryHealthIndicator();
    }

    @Bean
    public AppserverHealthIndicator appserverHealthIndicator() {
        return new AppserverHealthIndicator(this.appserver.getUrl(), this.appserverHealthMonitor, this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED));
    }

    @Bean
    public DiskSpaceHealthIndicator diskSpaceHealthIndicator() {
        return new DiskSpaceHealthIndicator(new File("."), DataSize.ofMegabytes((long)100L));
    }

    @Bean
    public HttpExchangeRepository httpExchangeRepository() {
        InMemoryHttpExchangeRepository bean = new InMemoryHttpExchangeRepository();
        bean.setCapacity(300);
        return bean;
    }

    @Bean
    public LicenceInfoContributor licenceInfoContributor() {
        return new LicenceInfoContributor(this.licenceProvider);
    }

    @Bean
    public TagsInfoContributor tagsInfoContributor() {
        return new TagsInfoContributor(this.currentVersionProvider, this.licenceProvider, (Supplier)this.databaseProductNameProvider);
    }

    @Bean
    public InstanceInfoContributor appInfoContributor() {
        return new InstanceInfoContributor(this.instanceName, this.startTime);
    }

    @Bean
    public AppserverInfoContributor appserverInfoContributor() {
        return new AppserverInfoContributor(this.appserver.getUrl(), this.appserverPropertiesLoader);
    }

    @Bean
    public InstallationInfoContributor installationInfoContributor() {
        return new InstallationInfoContributor((Provider)new StaticContextualDelegatingProvider(this.systemInstitutionProvider, this.rootDepartmentProvider), this.currentVersionProvider, this.licenceVersionProvider, this.rootSerialCodeProvider, this.settingLoader.getOnRootProvider(SettingKeys.LICENCE_KEY), this.settingLoader.getOnRootProvider(SettingKeys.SERVER_URL), this.rootDepartmentProvider);
    }

    @Bean
    public LogFileWebEndpoint logFileWebEndpoint() {
        return new LogFileWebEndpoint(LogFile.get((PropertyResolver)this.applicationContext.getEnvironment()), null);
    }

    @Bean
    public HeapDumpWebEndpoint heapDumpWebEndpoint() {
        return new HeapDumpWebEndpoint();
    }

    @ConstructorProperties(value={"instanceName", "appserverPropertiesLoader", "appserver", "rootSerialCodeProvider", "systemInstitutionProvider", "rootDepartmentProvider", "startTime", "currentVersionProvider", "licenceVersionProvider", "settingLoader", "applicationContext", "appserverHealthMonitor", "licenceProvider", "dataSource", "notAutocommitDataSource", "fileStreamAutoCommittingDataSource", "notCriticalDataSource", "databaseProductNameProvider"})
    @Generated
    public MonitoringConfig(@NonNull String instanceName, @NonNull AppserverPropertiesLoader appserverPropertiesLoader, @NonNull Appserver appserver, @NonNull @NonNull Provider<@NonNull String> rootSerialCodeProvider, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull Provider<Department> rootDepartmentProvider, @NonNull Date startTime, @NonNull @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider, @NonNull SettingLoader settingLoader, @NonNull ApplicationContext applicationContext, @NonNull AppserverHealthMonitor appserverHealthMonitor, @NonNull @NonNull Supplier<@NonNull Licence> licenceProvider, @NonNull DataSource dataSource, @NonNull DataSource notAutocommitDataSource, @NonNull DataSource fileStreamAutoCommittingDataSource, @NonNull DataSource notCriticalDataSource, @NonNull @NonNull Provider<@NonNull String> databaseProductNameProvider) {
        Objects.requireNonNull(instanceName, "instanceName is marked non-null but is null");
        Objects.requireNonNull(appserverPropertiesLoader, "appserverPropertiesLoader is marked non-null but is null");
        Objects.requireNonNull(appserver, "appserver is marked non-null but is null");
        Objects.requireNonNull(rootSerialCodeProvider, "rootSerialCodeProvider is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(startTime, "startTime is marked non-null but is null");
        Objects.requireNonNull(currentVersionProvider, "currentVersionProvider is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(appserverHealthMonitor, "appserverHealthMonitor is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(dataSource, "dataSource is marked non-null but is null");
        Objects.requireNonNull(notAutocommitDataSource, "notAutocommitDataSource is marked non-null but is null");
        Objects.requireNonNull(fileStreamAutoCommittingDataSource, "fileStreamAutoCommittingDataSource is marked non-null but is null");
        Objects.requireNonNull(notCriticalDataSource, "notCriticalDataSource is marked non-null but is null");
        Objects.requireNonNull(databaseProductNameProvider, "databaseProductNameProvider is marked non-null but is null");
        this.instanceName = instanceName;
        this.appserverPropertiesLoader = appserverPropertiesLoader;
        this.appserver = appserver;
        this.rootSerialCodeProvider = rootSerialCodeProvider;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.startTime = startTime;
        this.currentVersionProvider = currentVersionProvider;
        this.licenceVersionProvider = licenceVersionProvider;
        this.settingLoader = settingLoader;
        this.applicationContext = applicationContext;
        this.appserverHealthMonitor = appserverHealthMonitor;
        this.licenceProvider = licenceProvider;
        this.dataSource = dataSource;
        this.notAutocommitDataSource = notAutocommitDataSource;
        this.fileStreamAutoCommittingDataSource = fileStreamAutoCommittingDataSource;
        this.notCriticalDataSource = notCriticalDataSource;
        this.databaseProductNameProvider = databaseProductNameProvider;
    }
}

