/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.alert.AlertProvider;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.credreg.CredentialsRegistrationSettings;
import cz.kpsys.portaro.auth.current.CurrentAuthDto;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.view.AuthenticationSystemView;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.core.application.PortaroVersion;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.RootCustomDirectory;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessorNewDirCreatingDecorator;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.licence.FeatureEnabledProvider;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.opening.OpeningData;
import cz.kpsys.portaro.opening.OpeningNoticeByStateGenerator;
import cz.kpsys.portaro.opening.OpeningTimeRangesProviderByDayStringProviders;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.UntypedSearcherFactory;
import cz.kpsys.portaro.search.view.SearchFormFactory;
import cz.kpsys.portaro.search.view.ViewableSearchField;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.template.CustomFileTemplateRenderer;
import cz.kpsys.portaro.template.StaticTemplateRenderer;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.user.relation.RepresentableUserLoader;
import cz.kpsys.portaro.view.domain.CurrentPage;
import cz.kpsys.portaro.view.domain.LoginView;
import cz.kpsys.portaro.view.domain.menu.CompositeMenuLoader;
import cz.kpsys.portaro.view.domain.menu.MenuItem;
import cz.kpsys.portaro.view.domain.menu.MenuItemEntity;
import cz.kpsys.portaro.view.web.CatalogWebSettingsKeys;
import cz.kpsys.portaro.view.web.DepartmentSelectorApiController;
import cz.kpsys.portaro.view.web.OpensearchDescriptionFileController;
import cz.kpsys.portaro.view.web.SetController;
import cz.kpsys.portaro.view.web.currentdepartment.CurrentDepartmentSaver;
import cz.kpsys.portaro.view.web.page.CustomFileController;
import cz.kpsys.portaro.view.web.page.DefaultCurrentPageFactory;
import cz.kpsys.portaro.view.web.page.ErrorsPageController;
import cz.kpsys.portaro.view.web.page.IndexController;
import cz.kpsys.portaro.view.web.page.MediaViewerPageController;
import cz.kpsys.portaro.view.web.page.PagesController;
import cz.kpsys.portaro.view.web.page.ViewsController;
import cz.kpsys.portaro.view.web.rest.FormApiController;
import cz.kpsys.portaro.view.web.rest.OpeningCalendarApiController;
import cz.kpsys.portaro.view.web.rest.user.CurrentAuthApiController;
import cz.kpsys.portaro.view.web.rest.user.LoginViewApiController;
import cz.kpsys.portaro.web.page.AngularTemplateController;
import cz.kpsys.portaro.web.page.CompositeCurrentPageDialogsResolver;
import cz.kpsys.portaro.web.page.CurrentPageDialogsResolver;
import cz.kpsys.portaro.web.page.CurrentPageFactory;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import cz.kpsys.portaro.web.page.SettableModelAndPageViewFactory;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class WebPageConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final PortaroVersion portaroVersion;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final ContextualProvider<Department, List<AuthenticationSystemView>> authSystemViewsListDepartmentedProvider;
    @NonNull
    private final CurrentDepartmentSaver currentDepartmentSaver;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final ContextualProvider<Department, List<ViewableSearchField>> viewableSearchFieldsProvider;
    @NonNull
    private final Codebook<FileAccessType, Integer> fileAccessTypeLoader;
    @NonNull
    private final LocaleResolver localeResolver;
    @NonNull
    private final BeanFactory applicationContext;
    @NonNull
    private final ContextualProvider<Department, CredentialsRegistrationSettings> credentialsRegistrationSettingsDepartmentedProvider;
    @NonNull
    private final RootCustomDirectoryAccessor rootCustomDirectoryAccessor;
    @NonNull
    private final Saver<RootCustomDirectory> rootCustomDirectorySaver;
    @NonNull
    private final ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader;
    @NonNull
    private final FileDataStreamer cachedUnsecuredFileDataStreamer;
    @NonNull
    private final AlertProvider alertProvider;
    @NonNull
    private final Saver<ParentableDirectory> directorySaver;
    @NonNull
    private final Converter<UserAuthentication, CurrentAuthDto> currentAuthToResponseConverter;
    @NonNull
    private final RepresentableUserLoader representableUserLoader;
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final CompositeCurrentPageDialogsResolver currentPageDialogsResolver;
    @NonNull
    private final UntypedSearcherFactory untypedSearcherFactory;
    @NonNull
    private final SearchFormFactory searchFormFactory;
    @NonNull
    private final SettableModelAndPageViewFactory modelAndPageViewFactory;

    @Bean
    public StaticTemplateRenderer customFileTemplateRenderer() {
        return new CustomFileTemplateRenderer(this.templateEngine, this.applicationContext, this.untypedSearcherFactory, this.translator);
    }

    @Bean
    public IndexController indexController() {
        return new IndexController(this.publicContextPath, (ModelAndPageViewFactory)this.modelAndPageViewFactory, this.customFileTemplateRenderer());
    }

    @Bean
    public PagesController pagesController() {
        return new PagesController((ModelAndPageViewFactory)this.modelAndPageViewFactory, this.customFileTemplateRenderer());
    }

    @Bean
    public AngularTemplateController angularTemplateController() {
        return new AngularTemplateController((ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public OpensearchDescriptionFileController opensearchDescriptionFileController() {
        return new OpensearchDescriptionFileController();
    }

    @Bean
    public CustomFileController customFileController() {
        return new CustomFileController(this.hierarchyTraversingCustomFileLoader, this.cachedUnsecuredFileDataStreamer, this.currentPageFactory(), this.localeResolver);
    }

    @Bean
    public FormApiController formApiController() {
        return new FormApiController(this.searchFormFactory);
    }

    @Bean
    public ViewsController viewsController() {
        return new ViewsController(this.actionSaver, (Provider)new FeatureEnabledProvider(this.featureManager, "exemplar-search"), (Provider)new FeatureEnabledProvider(this.featureManager, "search-parameters-history"), this.settingLoader.getOnRootProvider(SettingKeys.BASIC_MODE_SEARCH_FIELDS_COUNT), this.viewableSearchFieldsProvider, (RootCustomDirectoryAccessor)new RootCustomDirectoryAccessorNewDirCreatingDecorator(this.rootCustomDirectoryAccessor, this.directorySaver, this.rootCustomDirectorySaver, () -> (FileAccessType)this.fileAccessTypeLoader.getById((Object)FileAccessType.PERMIT_ID)), (ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public MediaViewerPageController mediaViewerPageController() {
        return new MediaViewerPageController(this.publicContextPath, this.directoryLoader, this.actionSaver, (ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public CurrentAuthApiController currentAuthApiController() {
        return new CurrentAuthApiController(this.currentAuthToResponseConverter);
    }

    @Bean
    public LoginViewApiController loginViewApiController() {
        return new LoginViewApiController(this.loginViewDepartmentedProvider());
    }

    @Bean
    public SetController setController() {
        return new SetController(this.publicContextPath, this.rootDepartmentProvider, this.currentDepartmentSaver, this.localeResolver);
    }

    @Bean
    public OpeningCalendarApiController openingCalendarApiController() {
        OpeningTimeRangesProviderByDayStringProviders openingTimeRangesProvider = new OpeningTimeRangesProviderByDayStringProviders().withDay(DayOfWeek.MONDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_MONDAY)).withDay(DayOfWeek.TUESDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_TUESDAY)).withDay(DayOfWeek.WEDNESDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_WEDNESDAY)).withDay(DayOfWeek.THURSDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_THURSDAY)).withDay(DayOfWeek.FRIDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_FRIDAY)).withDay(DayOfWeek.SATURDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_SATURDAY)).withDay(DayOfWeek.SUNDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_SUNDAY));
        ContextualProvider data = department -> new OpeningData((Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID), openingTimeRangesProvider.getOn(department));
        return new OpeningCalendarApiController(data, (Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID), List.of(Texts.ofDefaulted((Text)Texts.ofMessageCoded((String)"library.opening.note"), (Text)Texts.ofEmpty())), (Converter)new OpeningNoticeByStateGenerator(Instant::now));
    }

    @Bean
    public ContextualProvider<Department, List<MenuItem>> menuItemsDepartmentedProvider() {
        Codebook menuItemEntityLoader = this.codebookLoaderBuilderFactory.create().providedByJpa(MenuItemEntity.class, "order").staticCached(MenuItem.class.getSimpleName()).build();
        return new CompositeMenuLoader(this.securityManager, this.allowedAuthorityFondsDepartmentedProvider, this.settingLoader.getDepartmentedProvider(SettingKeys.AUTHORITY_INDEX_PREFIXES_BY_FONDS), menuItemEntityLoader);
    }

    @Bean
    public ContextualProvider<Department, List<String>> forbiddenMenuItems() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.FORBIDDEN_MENU_ITEMS);
    }

    @Bean
    public ContextualProvider<Department, LoginView> loginViewDepartmentedProvider() {
        return ctx -> new LoginView(((Boolean)this.settingLoader.getDepartmentedProvider(SettingKeys.FULL_REGISTRATION_ENABLED).getOn(ctx)).booleanValue(), ((CredentialsRegistrationSettings)this.credentialsRegistrationSettingsDepartmentedProvider.getOn(ctx)).isEnabled(), ((Boolean)this.settingLoader.getDepartmentedProvider(SettingKeys.FORGOTTEN_CREDENTIALS_ENABLED).getOn(ctx)).booleanValue(), (List)this.authSystemViewsListDepartmentedProvider.getOn(ctx), ((Boolean)this.settingLoader.getDepartmentedProvider(SettingKeys.MVS_ACTIVE_ENABLED).getOn(ctx)).booleanValue());
    }

    @Bean
    public List<LabeledId<String>> enabledLanguages() {
        List<LabeledId> allLanguages = List.of(new LabeledId((Serializable)((Object)CoreConstants.Locales.CS.getLanguage()), Texts.ofNative((String)"\u010cesky")), new LabeledId((Serializable)((Object)CoreConstants.Locales.SK.getLanguage()), Texts.ofNative((String)"Slovensky")), new LabeledId((Serializable)((Object)CoreConstants.Locales.EN.getLanguage()), Texts.ofNative((String)"English")), new LabeledId((Serializable)((Object)CoreConstants.Locales.DE.getLanguage()), Texts.ofNative((String)"Deutsch")), new LabeledId((Serializable)((Object)CoreConstants.Locales.FR.getLanguage()), Texts.ofNative((String)"Fran\u00e7ais")), new LabeledId((Serializable)((Object)CoreConstants.Locales.ES.getLanguage()), Texts.ofNative((String)"Espa\u00f1ol")), new LabeledId((Serializable)((Object)CoreConstants.Locales.IT.getLanguage()), Texts.ofNative((String)"Italiano")), new LabeledId((Serializable)((Object)CoreConstants.Locales.HU.getLanguage()), Texts.ofNative((String)"Magyar")), new LabeledId((Serializable)((Object)CoreConstants.Locales.PL.getLanguage()), Texts.ofNative((String)"Polskie")));
        return new ProvidedProxiedList(() -> {
            List languageCodes = ListUtil.convert((Iterable)this.settingLoader.getOnRootProvidedList(SettingKeys.ENABLED_LOCALES), Locale::getLanguage);
            return ListUtil.filterAndSortByRule((Collection)allLanguages, (Collection)languageCodes);
        });
    }

    @Bean
    public CurrentPageFactory<CurrentPage> currentPageFactory() {
        return new DefaultCurrentPageFactory(this.portaroVersion, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL), this.publicContextPath, this.authenticationHolder, this.securityManager, this.currentAuthToResponseConverter, this.loginViewDepartmentedProvider(), this.menuItemsDepartmentedProvider(), this.translator, this.enabledLanguages(), this.alertProvider, this.representableUserLoader, this.settingLoader.getOnRootProvider(SettingKeys.CAMERA_SCANNER_ENABLED), this.currentAuthWebResolver, this.forbiddenMenuItems(), this.customFileTemplateRenderer(), (CurrentPageDialogsResolver)this.currentPageDialogsResolver, this.settingLoader.getOnRootProvider(SettingKeys.GLOBAL_SEARCH_INPUT_ENABLED), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.HEADER_BACKGROUND_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.HEADER_TEXT_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.HEADER_LINK_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.MAIN_MENU_BACKGROUND_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.MAIN_MENU_TEXT_COLOR));
    }

    @Bean
    public ErrorsPageController errorsPageController() {
        return new ErrorsPageController(this.translator, (ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public DepartmentSelectorApiController departmentSelectorApiController() {
        return new DepartmentSelectorApiController(this.settingLoader.getContextToValueMap(SettingKeys.SERVER_URL), this.departmentAccessor);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerCurrentPageFactory() {
        this.modelAndPageViewFactory.setCurrentPageFactory(this.currentPageFactory());
    }

    @ConstructorProperties(value={"publicContextPath", "featureManager", "portaroVersion", "actionSaver", "translator", "templateEngine", "codebookLoaderBuilderFactory", "allowedAuthorityFondsDepartmentedProvider", "departmentAccessor", "securityManager", "settingLoader", "authenticationHolder", "directoryLoader", "authSystemViewsListDepartmentedProvider", "currentDepartmentSaver", "rootDepartmentProvider", "viewableSearchFieldsProvider", "fileAccessTypeLoader", "localeResolver", "applicationContext", "credentialsRegistrationSettingsDepartmentedProvider", "rootCustomDirectoryAccessor", "rootCustomDirectorySaver", "hierarchyTraversingCustomFileLoader", "cachedUnsecuredFileDataStreamer", "alertProvider", "directorySaver", "currentAuthToResponseConverter", "representableUserLoader", "currentAuthWebResolver", "currentPageDialogsResolver", "untypedSearcherFactory", "searchFormFactory", "modelAndPageViewFactory"})
    @Generated
    public WebPageConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull FeatureManager featureManager, @NonNull PortaroVersion portaroVersion, @NonNull ActionSaver actionSaver, @NonNull Translator<Department> translator, @NonNull TemplateEngine templateEngine, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider, @NonNull DepartmentAccessor departmentAccessor, @NonNull SecurityManager securityManager, @NonNull SettingLoader settingLoader, @NonNull AuthenticationHolder authenticationHolder, @NonNull DirectoryLoader directoryLoader, @NonNull ContextualProvider<Department, List<AuthenticationSystemView>> authSystemViewsListDepartmentedProvider, @NonNull CurrentDepartmentSaver currentDepartmentSaver, @NonNull Provider<Department> rootDepartmentProvider, @NonNull ContextualProvider<Department, List<ViewableSearchField>> viewableSearchFieldsProvider, @NonNull Codebook<FileAccessType, Integer> fileAccessTypeLoader, @NonNull LocaleResolver localeResolver, @NonNull BeanFactory applicationContext, @NonNull ContextualProvider<Department, CredentialsRegistrationSettings> credentialsRegistrationSettingsDepartmentedProvider, @NonNull RootCustomDirectoryAccessor rootCustomDirectoryAccessor, @NonNull Saver<RootCustomDirectory> rootCustomDirectorySaver, @NonNull ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader, @NonNull FileDataStreamer cachedUnsecuredFileDataStreamer, @NonNull AlertProvider alertProvider, @NonNull Saver<ParentableDirectory> directorySaver, @NonNull Converter<UserAuthentication, CurrentAuthDto> currentAuthToResponseConverter, @NonNull RepresentableUserLoader representableUserLoader, @NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull CompositeCurrentPageDialogsResolver currentPageDialogsResolver, @NonNull UntypedSearcherFactory untypedSearcherFactory, @NonNull SearchFormFactory searchFormFactory, @NonNull SettableModelAndPageViewFactory modelAndPageViewFactory) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(allowedAuthorityFondsDepartmentedProvider, "allowedAuthorityFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(authSystemViewsListDepartmentedProvider, "authSystemViewsListDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentSaver, "currentDepartmentSaver is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(viewableSearchFieldsProvider, "viewableSearchFieldsProvider is marked non-null but is null");
        Objects.requireNonNull(fileAccessTypeLoader, "fileAccessTypeLoader is marked non-null but is null");
        Objects.requireNonNull(localeResolver, "localeResolver is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(credentialsRegistrationSettingsDepartmentedProvider, "credentialsRegistrationSettingsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(rootCustomDirectoryAccessor, "rootCustomDirectoryAccessor is marked non-null but is null");
        Objects.requireNonNull(rootCustomDirectorySaver, "rootCustomDirectorySaver is marked non-null but is null");
        Objects.requireNonNull(hierarchyTraversingCustomFileLoader, "hierarchyTraversingCustomFileLoader is marked non-null but is null");
        Objects.requireNonNull(cachedUnsecuredFileDataStreamer, "cachedUnsecuredFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(alertProvider, "alertProvider is marked non-null but is null");
        Objects.requireNonNull(directorySaver, "directorySaver is marked non-null but is null");
        Objects.requireNonNull(currentAuthToResponseConverter, "currentAuthToResponseConverter is marked non-null but is null");
        Objects.requireNonNull(representableUserLoader, "representableUserLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentPageDialogsResolver, "currentPageDialogsResolver is marked non-null but is null");
        Objects.requireNonNull(untypedSearcherFactory, "untypedSearcherFactory is marked non-null but is null");
        Objects.requireNonNull(searchFormFactory, "searchFormFactory is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.featureManager = featureManager;
        this.portaroVersion = portaroVersion;
        this.actionSaver = actionSaver;
        this.translator = translator;
        this.templateEngine = templateEngine;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.allowedAuthorityFondsDepartmentedProvider = allowedAuthorityFondsDepartmentedProvider;
        this.departmentAccessor = departmentAccessor;
        this.securityManager = securityManager;
        this.settingLoader = settingLoader;
        this.authenticationHolder = authenticationHolder;
        this.directoryLoader = directoryLoader;
        this.authSystemViewsListDepartmentedProvider = authSystemViewsListDepartmentedProvider;
        this.currentDepartmentSaver = currentDepartmentSaver;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.viewableSearchFieldsProvider = viewableSearchFieldsProvider;
        this.fileAccessTypeLoader = fileAccessTypeLoader;
        this.localeResolver = localeResolver;
        this.applicationContext = applicationContext;
        this.credentialsRegistrationSettingsDepartmentedProvider = credentialsRegistrationSettingsDepartmentedProvider;
        this.rootCustomDirectoryAccessor = rootCustomDirectoryAccessor;
        this.rootCustomDirectorySaver = rootCustomDirectorySaver;
        this.hierarchyTraversingCustomFileLoader = hierarchyTraversingCustomFileLoader;
        this.cachedUnsecuredFileDataStreamer = cachedUnsecuredFileDataStreamer;
        this.alertProvider = alertProvider;
        this.directorySaver = directorySaver;
        this.currentAuthToResponseConverter = currentAuthToResponseConverter;
        this.representableUserLoader = representableUserLoader;
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.currentPageDialogsResolver = currentPageDialogsResolver;
        this.untypedSearcherFactory = untypedSearcherFactory;
        this.searchFormFactory = searchFormFactory;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
    }
}

