/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.json.ByIntConverterJsonDeserializer;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.record.ExportingRecord;
import cz.kpsys.portaro.record.IdsToRecordsConverter;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.record.search.RawableSearchService;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.lucene.LuceneSearchResult;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.sdi.Periodicity;
import cz.kpsys.portaro.user.sdi.SdiRequest;
import cz.kpsys.portaro.user.sdi.SdiRequestDeleterAppserver;
import cz.kpsys.portaro.user.sdi.SdiRequestLoader;
import cz.kpsys.portaro.user.sdi.SdiRequestSaverAppserver;
import cz.kpsys.portaro.user.sdi.SdiSending;
import cz.kpsys.portaro.user.sdi.SdiSendingLoader;
import cz.kpsys.portaro.user.sdi.SdiSendingSaveTableWriteGenerator;
import cz.kpsys.portaro.user.sdi.SdiService;
import cz.kpsys.portaro.user.sdi.SpringDbSdiRequestLoader;
import cz.kpsys.portaro.user.sdi.SpringDbSdiSendingLoader;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.SdiApiController;
import cz.kpsys.portaro.view.web.rest.SdiRequestCreationRequest;
import cz.kpsys.portaro.view.web.rest.SdiRequestCreationRequestDefaulter;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class SdiConfig {
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final FormatterRegistry conversionService;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final Converter<Record, ExportingRecord> recordToViewableRecordConverter;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final AllByIdsLoadable<RichRecord, UUID> richRecordLoader;
    @NonNull
    private final AllByIdsLoadable<RichDocument, Integer> documentByKindedIdLoader;
    @NonNull
    private final RawableSearchService<LuceneSearchResult<Record, MapBackedParams>, MapBackedParams, Record> recordSearchService;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final ByIdLoadable<User, Integer> userLoader;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, UUID> recordOperationRecordIdSearchLoader;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final SearchTextResolver searchTitleResolver;
    @NonNull
    private final CacheDeletableById recordCache;

    @Bean
    public SdiApiController sdiApiController() {
        return new SdiApiController(this.sdiService(), this.sdiRequestLoader(), this.sdiRequestDeleter(), this.sdiRequestSaver(), this.sdiSendingLoader(), this.securityManager);
    }

    @Bean
    public SdiRequestLoader sdiRequestLoader() {
        return new SpringDbSdiRequestLoader(this.jdbcTemplate, this.queryFactory, this.basicUserLoader, this.departmentLoader);
    }

    @Bean
    public Saver<SdiRequest> sdiRequestSaver() {
        return new SdiRequestSaverAppserver(this.dmlAppserverService, this.userLoader);
    }

    @Bean
    public Deleter<SdiRequest> sdiRequestDeleter() {
        return new SdiRequestDeleterAppserver(this.dmlAppserverService);
    }

    @Bean
    public SdiSendingLoader sdiSendingLoader() {
        return new SpringDbSdiSendingLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public Saver<SdiSending> sdiSendingSaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new SdiSendingSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[0]);
    }

    @Bean
    public TypedDepartmentedObjectModifier<SdiRequestCreationRequest> sdiRequestCreationRequestDefaulter() {
        return new SdiRequestCreationRequestDefaulter(this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.searchTitleResolver, this.translator);
    }

    @Bean
    public SdiService sdiService() {
        return new SdiService(this.sdiRequestLoader(), this.sdiSendingLoader(), this.sdiSendingSaver(), (Converter)new IdsToRecordsConverter().withDocumentSupport(this.documentByKindedIdLoader).withRecordSupport(this.richRecordLoader), this.recordSearchService, this.mailService, this.templateEngine, this.recordToViewableRecordConverter, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull(), this.translator, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.recordOperationTypeLoader, this.recordOperationRecordIdSearchLoader, this.rootDepartmentProvider, this.recordCache).withTimeZone(CoreConstants.CZECH_TIME_ZONE_ID);
    }

    @Logged
    @Scheduled(cron="0 0 5 * * *")
    @SchedulerLock(name="SdiConfig_sendSdi", lockAtLeastFor="PT10M", lockAtMostFor="PT20M")
    public void sendSdi() {
        this.sdiService().sendAllSendable();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        IdToObjectConverter integerToSdiRequestConverter = new IdToObjectConverter((ByIdLoadable)this.sdiRequestLoader());
        this.conversionService.addConverter(Integer.class, SdiRequest.class, (Converter)integerToSdiRequestConverter);
        this.conversionService.addConverter(String.class, SdiRequest.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToSdiRequestConverter));
        this.objectMapperModule.addDeserializer(Periodicity.class, (JsonDeserializer)new ByIntConverterJsonDeserializer(Periodicity.class, (Converter)new IdToObjectConverter((ByIdLoadable)Periodicity.CODEBOOK)));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.SDI_USE, this.permissionFactory.currentEvidedAuthenticActive());
        this.permissionRegistry.add(SecurityActions.ALL_SDI_REQUESTS_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.USER_SDI_REQUESTS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})})}));
        this.permissionRegistry.add(SecurityActions.SDI_SAVE, (PermissionResolver)PermissionResolver.adaptingSubject(SdiRequest::getUser, (PermissionResolver)this.permissionRegistry.get(SecurityActions.USER_SDI_REQUESTS_SHOW)));
    }

    @ConstructorProperties(value={"settingLoader", "jdbcTemplate", "queryFactory", "dmlAppserverService", "permissionRegistry", "permissionFactory", "conversionService", "objectMapperModule", "templateEngine", "recordToViewableRecordConverter", "mailService", "richRecordLoader", "documentByKindedIdLoader", "recordSearchService", "translator", "userLoader", "basicUserLoader", "departmentLoader", "recordOperationTypeLoader", "recordOperationRecordIdSearchLoader", "securityManager", "rootDepartmentProvider", "searchTitleResolver", "recordCache"})
    @Generated
    public SdiConfig(@NonNull SettingLoader settingLoader, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DmlAppserverService dmlAppserverService, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull FormatterRegistry conversionService, @NonNull SimpleModule objectMapperModule, @NonNull TemplateEngine templateEngine, @NonNull Converter<Record, ExportingRecord> recordToViewableRecordConverter, @NonNull MailService mailService, @NonNull AllByIdsLoadable<RichRecord, UUID> richRecordLoader, @NonNull AllByIdsLoadable<RichDocument, Integer> documentByKindedIdLoader, @NonNull RawableSearchService<LuceneSearchResult<Record, MapBackedParams>, MapBackedParams, Record> recordSearchService, @NonNull Translator<Department> translator, @NonNull ByIdLoadable<User, Integer> userLoader, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, UUID> recordOperationRecordIdSearchLoader, @NonNull SecurityManager securityManager, @NonNull Provider<Department> rootDepartmentProvider, @NonNull SearchTextResolver searchTitleResolver, @NonNull CacheDeletableById recordCache) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(recordToViewableRecordConverter, "recordToViewableRecordConverter is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(documentByKindedIdLoader, "documentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(recordSearchService, "recordSearchService is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationRecordIdSearchLoader, "recordOperationRecordIdSearchLoader is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(searchTitleResolver, "searchTitleResolver is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.dmlAppserverService = dmlAppserverService;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.conversionService = conversionService;
        this.objectMapperModule = objectMapperModule;
        this.templateEngine = templateEngine;
        this.recordToViewableRecordConverter = recordToViewableRecordConverter;
        this.mailService = mailService;
        this.richRecordLoader = richRecordLoader;
        this.documentByKindedIdLoader = documentByKindedIdLoader;
        this.recordSearchService = recordSearchService;
        this.translator = translator;
        this.userLoader = userLoader;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.recordOperationRecordIdSearchLoader = recordOperationRecordIdSearchLoader;
        this.securityManager = securityManager;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.searchTitleResolver = searchTitleResolver;
        this.recordCache = recordCache;
    }
}

