/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.CompositeObjectUrlIdResolver;
import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.commons.cache.CacheBackedRepository;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.LabeledValuesGroup;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticAllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.CastingByIdLoader;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.CompositeByIdLoader;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.commons.web.ObjectUrlIdResolver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.JpaAllValuesProvider;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.ExemplarSettingKeys;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.directory.AllIdsByDirectoryProvider;
import cz.kpsys.portaro.filter.Filter;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.filter.LazyFilter;
import cz.kpsys.portaro.record.AppserverRecordSaver;
import cz.kpsys.portaro.record.DelegatingRichRecordsByIdsLoader;
import cz.kpsys.portaro.record.InternalRecordLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordEntity;
import cz.kpsys.portaro.record.RecordSaver;
import cz.kpsys.portaro.record.RecordSecurityActions;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.RichRecordLoader;
import cz.kpsys.portaro.record.SecuredRecordSaver;
import cz.kpsys.portaro.record.SimilarRecordsLoader;
import cz.kpsys.portaro.record.SpringDbAllDatabasedRichRecordsByIdsLoader;
import cz.kpsys.portaro.record.SpringDbSimilarRecordsLoader;
import cz.kpsys.portaro.record.authority.Authority;
import cz.kpsys.portaro.record.authority.RecordHierarchyLoader;
import cz.kpsys.portaro.record.authority.RecordLoaderDelegatingAuthorityLoader;
import cz.kpsys.portaro.record.authority.RichAuthority;
import cz.kpsys.portaro.record.authority.RichAuthorityRowMapper;
import cz.kpsys.portaro.record.authority.SpringDbAuthorityHierarchyLoader;
import cz.kpsys.portaro.record.authority.SpringDbAuthoritySearchLoader;
import cz.kpsys.portaro.record.detail.AppserverRecordDetailLoader;
import cz.kpsys.portaro.record.detail.CodebookDelegatingFieldTypeLoader;
import cz.kpsys.portaro.record.detail.FieldType;
import cz.kpsys.portaro.record.detail.FieldTypeEntityToNormalizedFieldTypeDtoConverter;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.detail.FieldTypeLoader;
import cz.kpsys.portaro.record.detail.FieldTypeLoaderByStringIdDispatching;
import cz.kpsys.portaro.record.detail.FieldTypeLoaderDispatching;
import cz.kpsys.portaro.record.detail.IdentifiedFieldContainer;
import cz.kpsys.portaro.record.detail.IndicatorType;
import cz.kpsys.portaro.record.detail.IndicatorTypeLoader;
import cz.kpsys.portaro.record.detail.IndicatorTypeLoaderWithDefaultIfNotFound;
import cz.kpsys.portaro.record.detail.LoaderDelegatingIndicatorTypeLoader;
import cz.kpsys.portaro.record.detail.NormalizedFieldTypeEntitiesToFieldTypesConverter;
import cz.kpsys.portaro.record.detail.SpringDbIndicatorTypeLoader;
import cz.kpsys.portaro.record.detail.StaticMapIncludingFieldTypeLoader;
import cz.kpsys.portaro.record.detail.SubfieldTypeId;
import cz.kpsys.portaro.record.detail.UnknownFieldTypeFactory;
import cz.kpsys.portaro.record.detail.appservermarc.MarcXmlToDetailConverterImpl;
import cz.kpsys.portaro.record.detail.convert.MarcXmlToDetailConverter;
import cz.kpsys.portaro.record.detail.data.AuthorityFieldTypeDtoLoaderJpa;
import cz.kpsys.portaro.record.detail.data.AuthorityFieldTypeEntity;
import cz.kpsys.portaro.record.detail.data.DocumentFieldTypeDtoLoaderJpa;
import cz.kpsys.portaro.record.detail.data.DocumentFieldTypeEntity;
import cz.kpsys.portaro.record.detail.data.ShowableAuthorityFieldNumberByFondLoader;
import cz.kpsys.portaro.record.detail.data.ViewableFieldEntity;
import cz.kpsys.portaro.record.detail.value.FieldValueConverterFactory;
import cz.kpsys.portaro.record.document.AuthoritySourceDocumentProvider;
import cz.kpsys.portaro.record.document.CompositeDocumentContentTypeResolver;
import cz.kpsys.portaro.record.document.Document;
import cz.kpsys.portaro.record.document.DocumentContentTypeResolver;
import cz.kpsys.portaro.record.document.DocumentLoader;
import cz.kpsys.portaro.record.document.RecordDelegatingDocumentLoader;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.document.RichDocumentRowMapper;
import cz.kpsys.portaro.record.document.SpringDbAllDocumentIdsByDirectoryLoader;
import cz.kpsys.portaro.record.document.SpringDbAuthoritySourceDocumentProvider;
import cz.kpsys.portaro.record.document.SpringDbDocumentSearchLoader;
import cz.kpsys.portaro.record.edit.field007.Field007CodeEntity;
import cz.kpsys.portaro.record.edit.field007.Field007Definitions;
import cz.kpsys.portaro.record.edit.field007.Field007DefinitionsLoader;
import cz.kpsys.portaro.record.edit.field007.Field007DocumentCategoryEntity;
import cz.kpsys.portaro.record.edit.field007.Field007LabelEntity;
import cz.kpsys.portaro.record.edit.field008.Field008CodeEntity;
import cz.kpsys.portaro.record.edit.field008.Field008Definitions;
import cz.kpsys.portaro.record.edit.field008.Field008DefinitionsLoader;
import cz.kpsys.portaro.record.edit.field008.Field008EditFormData;
import cz.kpsys.portaro.record.evaluation.DocumentRating;
import cz.kpsys.portaro.record.evaluation.DocumentRatingRowMapper;
import cz.kpsys.portaro.record.evaluation.RatingSaver;
import cz.kpsys.portaro.record.evaluation.RatingSaverEvaluatedCheckingProxy;
import cz.kpsys.portaro.record.evaluation.SpringDbRatingLoaderAndSaver;
import cz.kpsys.portaro.record.file.IdentifiedFileSaverRecordPrimaryImageSavingAppserverDecorator;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.fond.FondResolver;
import cz.kpsys.portaro.record.link.DocumentLinkLoader;
import cz.kpsys.portaro.record.link.DocumentLinkLoaderForSearchElsewhereItems;
import cz.kpsys.portaro.record.link.SpringDbObalkyKnihDocumentLinkLoader;
import cz.kpsys.portaro.record.list.RecordIdStorage;
import cz.kpsys.portaro.record.list.RecordIdStorageImpl;
import cz.kpsys.portaro.record.operation.CachingRecordEditLevelProvider;
import cz.kpsys.portaro.record.operation.EntitiesToRecordOperationRecordIdsConverter;
import cz.kpsys.portaro.record.operation.EntitiesToRecordOperationsConverter;
import cz.kpsys.portaro.record.operation.EntityToRecordOperationTypeConverter;
import cz.kpsys.portaro.record.operation.RecordEditLevelProvider;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.operation.RecordOperationEntity;
import cz.kpsys.portaro.record.operation.RecordOperationSearchDelegatingRecordEditLevelProvider;
import cz.kpsys.portaro.record.operation.RecordOperationToEntityConverter;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.record.operation.RecordOperationTypeEntity;
import cz.kpsys.portaro.record.operation.SpringDbRecordOperationEntitySearchLoader;
import cz.kpsys.portaro.record.sec.CurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.record.view.DocumentShowListener;
import cz.kpsys.portaro.record.view.ViewableIndicatorTypeLoaderDelegating;
import cz.kpsys.portaro.record.viewcount.SpringDbRecordShowCountSaver;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.role.editor.EditLevel;
import cz.kpsys.portaro.user.role.editor.EditorAccount;
import cz.kpsys.portaro.view.web.rest.record.RecordUrlIdResolver;
import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class RecordConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordConfig.class);
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final Codebook<Fond, Integer> documentFondLoader;
    @NonNull
    private final Codebook<Fond, Integer> authorityFondLoader;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final NamedParameterJdbcOperations notCriticalJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader;
    @NonNull
    private final UserByBasicUserLoader userLoader;
    @NonNull
    private final FilterLoader filterLoader;
    @NonNull
    private final HttpServletRequest httpServletRequest;
    @NonNull
    private final ByIdLoadable<AllValuesProvider<? extends LabeledIdentified<?>>, String> acceptableValuesProviderLoader;
    @NonNull
    private final Saver<IdentifiedFile> pureLoadedIdentifiedFileSaver;
    @NonNull
    private final AllByIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final CompositeObjectUrlIdResolver objectUrlIdResolver;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final Provider<Fond> supplierAuthorityFondProvider;
    @NonNull
    private final ByIdLoadable<LabeledValuesGroup<LabeledIdentified<String>, String>, Object> defValAcceptableValuesGroupLoader;
    @NonNull
    private final ExecutorService executorService;

    @Bean
    public IdAndIdsLoadable<RecordEntity, UUID> recordEntityLoader() {
        return this.modelBeanBuilder.allByIdsLoader(RecordEntity.class);
    }

    @Bean
    public Saver<RecordEntity> recordEntitySaver() {
        return this.saverBuilderFactory.saver().withClearedCacheName(RichRecord.class.getSimpleName()).build();
    }

    @Bean
    public RatingSaver ratingSaver() {
        return new RatingSaverEvaluatedCheckingProxy((RatingSaver)this.ratingLoader(), this.byUserEvaluatedDocuments());
    }

    @Bean
    public SpringDbRatingLoaderAndSaver ratingLoader() {
        return new SpringDbRatingLoaderAndSaver(this.jdbcTemplate, this.queryFactory, (CacheDeletableById)this.recordCache());
    }

    @Bean
    public RowMapper<DocumentRating> documentRatingRowMapper() {
        return new DocumentRatingRowMapper();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public RecordIdStorage byUserEvaluatedDocuments() {
        return new RecordIdStorageImpl();
    }

    @Bean
    public DocumentShowListener recordShowCountSaver() {
        return new SpringDbRecordShowCountSaver(this.jdbcTemplate, this.queryFactory, this.executorService);
    }

    @Bean
    public SimilarRecordsLoader similarRecordsLoader() {
        return new SpringDbSimilarRecordsLoader(this.notCriticalJdbcTemplate, this.queryFactory, this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORDS), this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORD_STATUSES), (AllValuesProvider)this.authorityFondLoader, (AllByIdsLoadable)this.nonDetailedRichRecordLoader());
    }

    @Bean
    public RowMapper<RichAuthority> authorityRowMapper() {
        return new RichAuthorityRowMapper((ByIdLoadable)this.authorityFondLoader, this.recordDetailLoader(), (ByIdLoadable)RecordStatus.CODEBOOK);
    }

    @Bean
    public RecordHierarchyLoader recordHierarchyLoader() {
        return new SpringDbAuthorityHierarchyLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public Repository<Record, UUID> externalRecordRepository() {
        return CacheBackedRepository.of((DynamicCache)new GuavaTimedDynamicCache(Record::getId, Duration.ofMinutes(2L), false), Record::getId);
    }

    @Bean
    public IdAndIdsLoadable<? extends Record, UUID> recordLoader() {
        return new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)new CompositeByIdLoader(new ByIdLoadable[]{this.richRecordLoader(), this.externalRecordRepository()}));
    }

    @Bean
    public UnknownFieldTypeFactory unknownFieldTypeFactory() {
        return new UnknownFieldTypeFactory();
    }

    @Bean
    public FieldTypeLoader authorityFieldTypeLoader() {
        AuthorityFieldTypeDtoLoaderJpa entityLoader = new AuthorityFieldTypeDtoLoaderJpa((JpaRepository)new SimpleJpaRepository(AuthorityFieldTypeEntity.class, this.entityManager));
        this.cacheService.registerSpringCacheCleaner(FieldType.class.getSimpleName(), "authorityFieldTypes");
        ConvertingAllValuesProvider normalizedFieldTypeEntityLoader = ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)entityLoader, (Converter)new FieldTypeEntityToNormalizedFieldTypeDtoConverter(FieldTypeId.record((boolean)true)));
        ViewableIndicatorTypeLoaderDelegating indicatorTypeLoader = new ViewableIndicatorTypeLoaderDelegating((IndicatorTypeLoader)new IndicatorTypeLoaderWithDefaultIfNotFound(this.authorityIndicatorTypeLoader()));
        NormalizedFieldTypeEntitiesToFieldTypesConverter normalizedToFieldTypesConverter = new NormalizedFieldTypeEntitiesToFieldTypesConverter((IndicatorTypeLoader)indicatorTypeLoader, this.showableAuthorityFieldNumberByFondLoader(), this.fieldValueConverterFactory());
        ConvertingAllValuesProvider fieldTypeLoader = ConvertingAllValuesProvider.byListConverter((AllValuesProvider)normalizedFieldTypeEntityLoader, (Converter)normalizedToFieldTypesConverter);
        Codebook fieldTypeCachedCodebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)fieldTypeLoader).staticCached(FieldType.class.getSimpleName()).fallbackWhenNotFoundById(fieldTypeId -> this.unknownFieldTypeFactory().createUnknownDatafieldType(FieldTypeId.parse((String)fieldTypeId))).build();
        CodebookDelegatingFieldTypeLoader bean = new CodebookDelegatingFieldTypeLoader(fieldTypeCachedCodebook, this.unknownFieldTypeFactory());
        return new StaticMapIncludingFieldTypeLoader(Map.of(FieldType.AUTHORITY_LEADER_FIELD_TYPE_ID, FieldType.AUTHORITY_LEADER_FIELD_TYPE), (FieldTypeLoader)bean);
    }

    @Bean
    public FieldTypeLoader documentFieldTypeLoader() {
        DocumentFieldTypeDtoLoaderJpa entityLoader = new DocumentFieldTypeDtoLoaderJpa((JpaRepository)new SimpleJpaRepository(DocumentFieldTypeEntity.class, this.entityManager));
        this.cacheService.registerSpringCacheCleaner(FieldType.class.getSimpleName(), "documentFieldTypes");
        ConvertingAllValuesProvider normalizedFieldTypeEntityLoader = ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)entityLoader, (Converter)new FieldTypeEntityToNormalizedFieldTypeDtoConverter(FieldTypeId.record((boolean)false)));
        ViewableIndicatorTypeLoaderDelegating indicatorTypeLoader = new ViewableIndicatorTypeLoaderDelegating((IndicatorTypeLoader)new IndicatorTypeLoaderWithDefaultIfNotFound(this.documentIndicatorTypeLoader()));
        NormalizedFieldTypeEntitiesToFieldTypesConverter normalizedToFieldTypesConverter = new NormalizedFieldTypeEntitiesToFieldTypesConverter((IndicatorTypeLoader)indicatorTypeLoader, this.showableAuthorityFieldNumberByFondLoader(), this.fieldValueConverterFactory());
        ConvertingAllValuesProvider fieldTypeLoader = ConvertingAllValuesProvider.byListConverter((AllValuesProvider)normalizedFieldTypeEntityLoader, (Converter)normalizedToFieldTypesConverter);
        Codebook fieldTypeCachedCodebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)fieldTypeLoader).staticCached(FieldType.class.getSimpleName()).fallbackWhenNotFoundById(fieldTypeId -> this.unknownFieldTypeFactory().createUnknownDatafieldType(FieldTypeId.parse((String)fieldTypeId))).build();
        CodebookDelegatingFieldTypeLoader bean = new CodebookDelegatingFieldTypeLoader(fieldTypeCachedCodebook, this.unknownFieldTypeFactory());
        return new StaticMapIncludingFieldTypeLoader(Map.of(FieldType.DOCUMENT_LEADER_FIELD_TYPE_ID, FieldType.DOCUMENT_LEADER_FIELD_TYPE, FieldType.TOC_FIELD_TYPE_ID, FieldType.TOC_FIELD_TYPE), (FieldTypeLoader)bean);
    }

    @Bean
    public FieldValueConverterFactory fieldValueConverterFactory() {
        return new FieldValueConverterFactory(this.defValAcceptableValuesGroupLoader, (Converter)StringToIntegerToAnyConverter.strict((Converter)new IdToObjectConverter((ByIdLoadable)this.fondLoader)), this.recordSaver());
    }

    @Bean
    public ShowableAuthorityFieldNumberByFondLoader showableAuthorityFieldNumberByFondLoader() {
        ShowableAuthorityFieldNumberByFondLoader bean = new ShowableAuthorityFieldNumberByFondLoader((ByIdLoadable)this.fondLoader, (JpaRepository)new SimpleJpaRepository(ViewableFieldEntity.class, this.entityManager));
        this.cacheService.registerSpringCacheCleaner(FieldType.class.getSimpleName(), "showableAuthorityFieldNumbers");
        return bean;
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FieldTypeLoader fieldTypeLoader() {
        return new FieldTypeLoaderDispatching(this.documentFieldTypeLoader(), this.authorityFieldTypeLoader());
    }

    @Bean
    public ByIdLoadable<FieldType, SubfieldTypeId> subfieldTypeLoader() {
        return id -> this.fieldTypeLoader().getSubfieldTypeById(id);
    }

    @Bean
    public ByIdLoadable<FieldType, FieldTypeId> topfieldTypeLoader() {
        return id -> this.fieldTypeLoader().getTopfieldTypeById(id);
    }

    @Bean
    public ByIdLoadable<FieldType, String> fieldTypeByStringIdLoader() {
        return new FieldTypeLoaderByStringIdDispatching(this.documentFieldTypeLoader(), this.authorityFieldTypeLoader());
    }

    @Bean
    public AllByIdsLoadable<IdentifiedFieldContainer, UUID> recordDetailLoader() {
        MarcXmlToDetailConverterImpl detailFromMarcXmlConstructor = new MarcXmlToDetailConverterImpl(false, this.fieldTypeLoader(), this.defaultableAuthorityIndicatorTypeLoader(), this.defaultableDocumentIndicatorTypeLoader(), (ByIdLoadable)this.fondLoader);
        AppserverRecordDetailLoader bean = new AppserverRecordDetailLoader(this.mappingAppserver, false, (MarcXmlToDetailConverter)detailFromMarcXmlConstructor, this.settingLoader.getOnRootProvider(SettingKeys.EXEMPLAR_DATA_IN_RECORD_ENABLED));
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)bean).withChunkSize(100);
    }

    @Bean
    public DynamicCache<RichRecord> recordCache() {
        GuavaTimedDynamicCache bean = new GuavaTimedDynamicCache(Record::getId, Duration.ofSeconds(30L), false).throwWhenCacheIsFull();
        this.cacheService.registerCleaner(RichRecord.class.getSimpleName(), () -> ((GuavaTimedDynamicCache)bean).clear());
        return bean;
    }

    @Bean
    public DynamicCache<RichRecord> exportedRecordCache() {
        return new GuavaTimedDynamicCache(Record::getId, Duration.ofSeconds(30L), false).throwWhenCacheIsFull();
    }

    @Bean
    public IdAndIdsLoadable<RichAuthority, Integer> authorityByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((RichRecordLoader)this.richRecordLoader()).getDetailedAuthoritiesByKindedIds(arg_0), RichAuthority.class);
    }

    @Bean
    public IdAndIdsLoadable<RichAuthority, Integer> nonDetailedAuthorityByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((RichRecordLoader)this.richRecordLoader()).getAuthoritiesByKindedIds(arg_0), RichAuthority.class);
    }

    @Bean
    public IdAndIdsLoadable<RichDocument, Integer> nonDetailedDocumentByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((RichRecordLoader)this.richRecordLoader()).getDocumentsByKindedIds(arg_0), RichDocument.class);
    }

    @Bean
    public IdAndIdsLoadable<RichDocument, Integer> documentByKindedIdLoader() {
        return new ByIdLoadableByAllByIdsLoadable(arg_0 -> ((RichRecordLoader)this.richRecordLoader()).getDetailedDocumentsByKindedIds(arg_0), RichDocument.class);
    }

    @Bean
    public IdAndIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader() {
        RecordDelegatingDocumentLoader documentLoader = new RecordDelegatingDocumentLoader(this.richRecordLoader(), false);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)documentLoader, RichDocument.class);
    }

    @Bean
    public DocumentLoader detailedDocumentLoader() {
        return new RecordDelegatingDocumentLoader(this.richRecordLoader(), true);
    }

    @Bean
    public IdAndIdsLoadable<Authority, UUID> authorityLoader() {
        return new RecordLoaderDelegatingAuthorityLoader(this.richRecordLoader());
    }

    @Bean
    public InternalRecordLoader databaseRecordAllByIdsLoader() {
        RichDocumentRowMapper richDocumentRowMapper = new RichDocumentRowMapper((ByIdLoadable)this.documentFondLoader, (ByIdLoadable)RecordStatus.CODEBOOK, this.settingLoader.getOnRootProvider(SettingKeys.CENTRAL_INDEX_ENABLED));
        return new SpringDbAllDatabasedRichRecordsByIdsLoader(this.jdbcTemplate, this.queryFactory, (RowMapper)richDocumentRowMapper, this.authorityRowMapper());
    }

    @Bean
    public RichRecordLoader richRecordLoader() {
        return new DelegatingRichRecordsByIdsLoader(this.recordCache(), this.recordDetailLoader(), this.databaseRecordAllByIdsLoader(), true);
    }

    @Bean
    public IdAndIdsLoadable<RichRecord, UUID> nonDetailedRichRecordLoader() {
        return new DelegatingRichRecordsByIdsLoader(this.recordCache(), this.recordDetailLoader(), this.databaseRecordAllByIdsLoader(), false);
    }

    @Bean
    public IdAndIdsLoadable<RichRecord, UUID> exportedRecordLoader() {
        return new DelegatingRichRecordsByIdsLoader(this.exportedRecordCache(), this.exportedRecordDetailLoader(), this.databaseRecordAllByIdsLoader(), true);
    }

    @Bean
    public AllByIdsLoadable<IdentifiedFieldContainer, UUID> exportedRecordDetailLoader() {
        MarcXmlToDetailConverterImpl detailFromMarcXmlConstructor = new MarcXmlToDetailConverterImpl(false, this.fieldTypeLoader(), this.defaultableAuthorityIndicatorTypeLoader(), this.defaultableDocumentIndicatorTypeLoader(), (ByIdLoadable)this.fondLoader);
        AppserverRecordDetailLoader bean = new AppserverRecordDetailLoader(this.mappingAppserver, true, (MarcXmlToDetailConverter)detailFromMarcXmlConstructor, () -> (Boolean)this.settingLoader.getOnRoot(ExemplarSettingKeys.PORTARO_GENERATED_EXPORT_EXEMPLARS) == false);
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)bean).withChunkSize(100);
    }

    @Bean
    public AuthoritySourceDocumentProvider authoritySourceDocumentProvider() {
        return new SpringDbAuthoritySourceDocumentProvider(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public IndicatorTypeLoader documentIndicatorTypeLoader() {
        Codebook cachedCodebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbIndicatorTypeLoader(this.jdbcTemplate, this.queryFactory, false, "def_dokindik")).staticCached(IndicatorType.class.getSimpleName()).build();
        LoaderDelegatingIndicatorTypeLoader bean = new LoaderDelegatingIndicatorTypeLoader((ByIdLoadable)cachedCodebook);
        return new ViewableIndicatorTypeLoaderDelegating((IndicatorTypeLoader)bean);
    }

    @Bean
    public IndicatorTypeLoader authorityIndicatorTypeLoader() {
        Codebook cachedCodebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbIndicatorTypeLoader(this.jdbcTemplate, this.queryFactory, true, "def_autindik")).staticCached(IndicatorType.class.getSimpleName()).build();
        LoaderDelegatingIndicatorTypeLoader bean = new LoaderDelegatingIndicatorTypeLoader((ByIdLoadable)cachedCodebook);
        return new ViewableIndicatorTypeLoaderDelegating((IndicatorTypeLoader)bean);
    }

    @Bean
    public IndicatorTypeLoader defaultableDocumentIndicatorTypeLoader() {
        return new IndicatorTypeLoaderWithDefaultIfNotFound(this.documentIndicatorTypeLoader());
    }

    @Bean
    public IndicatorTypeLoader defaultableAuthorityIndicatorTypeLoader() {
        return new IndicatorTypeLoaderWithDefaultIfNotFound(this.authorityIndicatorTypeLoader());
    }

    @Bean
    public RecordSaver recordSaver() {
        AppserverRecordSaver pure = new AppserverRecordSaver(this.mappingAppserver, (ByIdLoadable)this.authorityLoader(), List.of(this.recordCache(), this.recordEditLevelProvider()));
        return new SecuredRecordSaver((RecordSaver)pure, this.securityManager, this.authenticationHolder);
    }

    @Bean
    public Saver<RecordOperation> recordOperationSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordOperationToEntityConverter()).build();
    }

    @Bean
    public TableWriteGenerator<RecordOperation> recordOperationTableWriteGenerator() {
        return this.modelBeanBuilder.modelTableWriteGenerator((Converter)new RecordOperationToEntityConverter());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordOperation> recordOperationSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)new SpringDbRecordOperationEntitySearchLoader(this.jdbcTemplate, this.queryFactory, (AllValuesProvider)this.fondLoader), this.entitiesToRecordOperationsConverter()));
    }

    @Bean
    public Converter<List<RecordOperationEntity>, List<? extends RecordOperation>> entitiesToRecordOperationsConverter() {
        return new EntitiesToRecordOperationsConverter((ByIdLoadable)this.recordOperationTypeLoader(), this.departmentLoader, (AllByIdsLoadable)this.nonDetailedRichRecordLoader(), this.basicUserLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> recordOperationRecordIdSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)new SpringDbRecordOperationEntitySearchLoader(this.jdbcTemplate, this.queryFactory, (AllValuesProvider)this.fondLoader), this.entitiesToRecordOperationRecordIdsConverter()));
    }

    @Bean
    public Converter<List<RecordOperationEntity>, List<? extends UUID>> entitiesToRecordOperationRecordIdsConverter() {
        return new EntitiesToRecordOperationRecordIdsConverter();
    }

    @Bean
    public Codebook<RecordOperationType, Integer> recordOperationTypeLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(RecordOperationTypeEntity.class).convertedEachBy((Converter)new EntityToRecordOperationTypeConverter()).staticCached(RecordOperationType.class.getSimpleName()).build();
    }

    @Bean
    public DocumentContentTypeResolver documentContentTypeResolver() {
        return new CompositeDocumentContentTypeResolver();
    }

    @Bean
    public DocumentLinkLoader externalDetailDocumentLinkLoader() {
        return new SpringDbObalkyKnihDocumentLinkLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public DocumentLinkLoader searchElsewhereDocumentLinkLoader() {
        return new DocumentLinkLoaderForSearchElsewhereItems(this.settingLoader.getOnRootProvidedList(SettingKeys.SEARCH_ELSEWHERE_ITEMS));
    }

    @Bean
    public Saver<IdentifiedFile> loadedIdentifiedFileSaver() {
        return new IdentifiedFileSaverRecordPrimaryImageSavingAppserverDecorator(this.pureLoadedIdentifiedFileSaver, this.dmlAppserverService, (AllIdsByDirectoryProvider)this.allDocumentIdsByDirectoryProvider(), (AllByIdsLoadable)this.nonDetailedRichRecordLoader());
    }

    @Bean
    public SpringDbAllDocumentIdsByDirectoryLoader allDocumentIdsByDirectoryProvider() {
        return new SpringDbAllDocumentIdsByDirectoryLoader(this.jdbcTemplate, this.queryFactory, (List)this.settingLoader.getOnRoot(SettingKeys.FORBIDDEN_RECORDS), (List)this.settingLoader.getOnRoot(SettingKeys.FORBIDDEN_RECORD_STATUSES));
    }

    @Bean
    public CachingRecordEditLevelProvider recordEditLevelProvider() {
        RecordOperationSearchDelegatingRecordEditLevelProvider bean = new RecordOperationSearchDelegatingRecordEditLevelProvider(this.recordOperationSearchLoader(), (ByIdLoadable)this.recordOperationTypeLoader(), this.userLoader);
        CachingRecordEditLevelProvider cached = new CachingRecordEditLevelProvider((RecordEditLevelProvider)bean);
        this.cacheService.registerSpringCacheCleaner(RecordOperationType.class.getSimpleName(), "recordEditLevel");
        return cached;
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RichAuthority> authoritySearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbAuthoritySearchLoader(this.jdbcTemplate, this.queryFactory, this.authorityRowMapper()));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RichAuthority> notCriticalAuthoritySearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbAuthoritySearchLoader(this.notCriticalJdbcTemplate, this.queryFactory, this.authorityRowMapper()));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> documentIdSearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbDocumentSearchLoader(this.jdbcTemplate, this.queryFactory));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> notCriticalDocumentIdSearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbDocumentSearchLoader(this.notCriticalJdbcTemplate, this.queryFactory));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RichRecord> nonDetailedRecordSearchSqlLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)this.documentIdSearchSqlLoader(), arg_0 -> ((IdAndIdsLoadable)this.nonDetailedRichRecordLoader()).getAllByIds(arg_0)));
    }

    @Bean
    public Field007DefinitionsLoader field007DefinitionsLoader() {
        Field007DefinitionsLoader bean = new Field007DefinitionsLoader((AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field007DocumentCategoryEntity.class, this.entityManager)), (AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field007CodeEntity.class, this.entityManager)), (AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field007LabelEntity.class, this.entityManager)));
        this.cacheService.registerSpringCacheCleaner(Field007Definitions.class.getSimpleName(), "field007definitions");
        return bean;
    }

    @Bean
    public Field008DefinitionsLoader field008DefinitionsLoader() {
        Field008DefinitionsLoader bean = new Field008DefinitionsLoader((AllValuesProvider)new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(Field008CodeEntity.class, this.entityManager)), this.acceptableValuesProviderLoader, StaticAllValuesProvider.of((List)Field008EditFormData.getLabelEntities()), StaticAllValuesProvider.of((List)Field008EditFormData.getDocumentTypeEntities()), StaticAllValuesProvider.of((List)Field008EditFormData.getPublicationStatusEntities()), StaticAllValuesProvider.of((List)Field008EditFormData.getRecordModificationEntities()), StaticAllValuesProvider.of((List)Field008EditFormData.getCataloguingSourceEntities()));
        this.cacheService.registerSpringCacheCleaner(Field008Definitions.class.getSimpleName(), "field008definitions");
        return bean;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(Authority.class, (ByIdLoadable)new CastingByIdLoader((ByIdLoadable)this.recordLoader(), Authority.class)).registerForUuidId(Document.class, (ByIdLoadable)new CastingByIdLoader((ByIdLoadable)this.recordLoader(), Document.class)).registerForStringId(FieldType.class, this.fieldTypeByStringIdLoader()).registerForUuidId(Record.class, (ByIdLoadable)this.recordLoader()).registerForUuidId(RichAuthority.class, (ByIdLoadable)new CastingByIdLoader((ByIdLoadable)this.recordLoader(), RichAuthority.class)).registerForUuidId(RichDocument.class, (ByIdLoadable)new CastingByIdLoader((ByIdLoadable)this.recordLoader(), RichDocument.class)).registerForUuidId(RichRecord.class, (ByIdLoadable)this.richRecordLoader()).registerForIntegerId(RecordOperationType.class, (ByIdLoadable)this.recordOperationTypeLoader()).registerForIntegerId(RecordStatus.class, (ByIdLoadable)RecordStatus.CODEBOOK);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        LazyFilter recordAccessFilter = new LazyFilter(Integer.valueOf(3), this.filterLoader);
        PermissionResolver editFond = PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_LIBRARIAN"}), (auth, ctx, fond) -> {
            List editableFonds = this.currentAuthEditableFondsLoader.getAllByAuth(auth, ctx);
            return PermissionResult.ifCan((boolean)editableFonds.contains(fond), (UserAuthentication)auth).withReasonWhenForbid((Text)MultiText.ofTexts((Text[])new Text[]{Texts.ofNative((String)"You dont have permission to edit fond"), fond.getText(), Texts.ofNative((String)"You can edit only"), Texts.ofNative((String)StringUtil.listToStringOfIds((Collection)editableFonds, (String)", "))}).withSpaceDelimiter());
        }});
        PermissionResolver currentEditingSupplierAuthorityFondWhileAuthenticating = (auth, ctx, fond) -> {
            Optional supplierAuthorityFond = (Optional)this.supplierAuthorityFondProvider.optionally().get();
            if (supplierAuthorityFond.isPresent() && ((Fond)supplierAuthorityFond.get()).equals(fond) && this.permissionFactory.currentlyAuthenticating().can(auth, ctx, null).allowed()) {
                return PermissionResult.allow();
            }
            return PermissionResult.forbidden();
        };
        this.permissionRegistry.add(RecordSecurityActions.RECORDS_SHOW, (auth, ctx, record) -> PermissionResult.allow());
        this.permissionRegistry.add(RecordSecurityActions.RECORD_SHOW, this.permissionFactory.webAccessFilter((Filter)recordAccessFilter, this.httpServletRequest));
        this.permissionRegistry.add(RecordSecurityActions.RECORDS_CREATE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(2201)), this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(7201)), this.permissionFactory.currentlyAuthenticating()}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_OF_KIND, (auth, ctx, kind) -> {
            PermissionResult createAnyRecordPerm = this.permissionRegistry.get(RecordSecurityActions.RECORDS_CREATE).can(auth, ctx, null);
            if (!createAnyRecordPerm.allowed()) {
                return createAnyRecordPerm;
            }
            if (kind.equals("authority")) {
                PermissionResult currentlyAuthenticating = this.permissionFactory.currentlyAuthenticating().can(auth, ctx, null);
                if (currentlyAuthenticating.allowed()) {
                    return currentlyAuthenticating;
                }
                PermissionResult authorityCreateAction = this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(7201)).can(auth, ctx, null);
                if (!authorityCreateAction.allowed()) {
                    return authorityCreateAction;
                }
                if (this.currentAuthEditableFondsLoader.getAllByAuth(auth, ctx).stream().noneMatch(FondResolver::isAuthorityFond)) {
                    return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"You dont have user permission (in Verbis) to edit any authority fond"));
                }
                return PermissionResult.allow();
            }
            PermissionResult documentCreateAction = this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(2201)).can(auth, ctx, null);
            if (!documentCreateAction.allowed()) {
                return documentCreateAction;
            }
            if (this.currentAuthEditableFondsLoader.getAllByAuth(auth, ctx).stream().noneMatch(FondResolver::isDocumentFond)) {
                return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"You dont have user permission (in Verbis) to edit any document fond"));
            }
            return PermissionResult.allow();
        });
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_OF_FOND, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, fond) -> {
            String recordKind = fond.isOfDocument() ? "document" : "authority";
            return this.permissionRegistry.get(RecordSecurityActions.RECORD_CREATE_OF_KIND).can(auth, ctx, (Object)recordKind);
        }, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{currentEditingSupplierAuthorityFondWhileAuthenticating, editFond})}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE, (PermissionResolver)PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)this.permissionRegistry.get(RecordSecurityActions.RECORD_CREATE_OF_FOND)));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_EDIT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)currentEditingSupplierAuthorityFondWhileAuthenticating), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.adaptingSubject(Record::getFond, (auth, ctx, fond) -> {
            int actionId = fond.isOfDocument() ? 2202 : 7202;
            return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(actionId)).can(auth, ctx, null);
        }), PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)editFond), this.currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord()})}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HOLDING_DELETE_OF_RECORD, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.getStatus().isForDeleted() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Record is already deleted")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isActive() ? PermissionResult.allow() : PermissionResult.forbidden(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> {
            int actionId = record.getFond().isOfDocument() ? 2204 : 7204;
            return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(actionId)).can(auth, ctx, null);
        }, PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)editFond)})})}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HOLDING_DELETE, (PermissionResolver)PermissionResolver.adaptingSubject(recordHolding -> (Record)this.nonDetailedRichRecordLoader().getById((Object)recordHolding.getRecordId()), (PermissionResolver)this.permissionRegistry.get(RecordSecurityActions.RECORD_HOLDING_DELETE_OF_RECORD)));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_MERGE_FROM, this.permissionRegistry.get(RecordSecurityActions.RECORD_HOLDING_DELETE_OF_RECORD));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_MERGE_TO, this.permissionRegistry.get(RecordSecurityActions.RECORD_EDIT));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_OPERATION_SEARCH, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_REQUEST_SEARCH, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_OPERATIONS_SHOW_OF_RECORD, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_SEARCH_IN_DATASOURCE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, datasource) -> PermissionResult.ifCan((boolean)datasource.equals((Object)CatalogConstants.Search.DATASOURCE_LOCAL), (UserAuthentication)auth), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})}));
    }

    private PermissionResolver<Record> currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord() {
        return PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_LIBRARIAN"}), (auth, ctx, record) -> {
            EditLevel lastRecordEditLevel;
            Stream editorAccounts = auth.getActiveUser().roleStreamOn(EditorAccount.class, ctx);
            if (editorAccounts.noneMatch(arg_0 -> RecordConfig.lambda$currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord$16(lastRecordEditLevel = this.recordEditLevelProvider().getRecordEditLevel(record), arg_0))) {
                return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"Record is locked (You have not sufficient edit level to edit/delete record)"));
            }
            return PermissionResult.allow();
        }});
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerObjectUrlIdResolvers() {
        this.objectUrlIdResolver.with(Record.class, (ObjectUrlIdResolver)new RecordUrlIdResolver());
    }

    @ConstructorProperties(value={"fondLoader", "documentFondLoader", "authorityFondLoader", "cacheService", "jdbcTemplate", "notCriticalJdbcTemplate", "queryFactory", "entityManager", "mappingAppserver", "dmlAppserverService", "settingLoader", "converterRegisterer", "permissionRegistry", "securityManager", "permissionFactory", "currentAuthEditableFondsLoader", "userLoader", "filterLoader", "httpServletRequest", "acceptableValuesProviderLoader", "pureLoadedIdentifiedFileSaver", "basicUserLoader", "departmentLoader", "objectUrlIdResolver", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory", "authenticationHolder", "supplierAuthorityFondProvider", "defValAcceptableValuesGroupLoader", "executorService"})
    @Generated
    public RecordConfig(@NonNull Codebook<Fond, Integer> fondLoader, @NonNull Codebook<Fond, Integer> documentFondLoader, @NonNull Codebook<Fond, Integer> authorityFondLoader, @NonNull CacheService cacheService, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull NamedParameterJdbcOperations notCriticalJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull EntityManager entityManager, @NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull SettingLoader settingLoader, @NonNull ConverterRegisterer converterRegisterer, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull PermissionFactory permissionFactory, @NonNull CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader, @NonNull UserByBasicUserLoader userLoader, @NonNull FilterLoader filterLoader, @NonNull HttpServletRequest httpServletRequest, @NonNull ByIdLoadable<AllValuesProvider<? extends LabeledIdentified<?>>, String> acceptableValuesProviderLoader, @NonNull Saver<IdentifiedFile> pureLoadedIdentifiedFileSaver, @NonNull AllByIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull CompositeObjectUrlIdResolver objectUrlIdResolver, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull AuthenticationHolder authenticationHolder, @NonNull Provider<Fond> supplierAuthorityFondProvider, @NonNull ByIdLoadable<LabeledValuesGroup<LabeledIdentified<String>, String>, Object> defValAcceptableValuesGroupLoader, @NonNull ExecutorService executorService) {
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(documentFondLoader, "documentFondLoader is marked non-null but is null");
        Objects.requireNonNull(authorityFondLoader, "authorityFondLoader is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(notCriticalJdbcTemplate, "notCriticalJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(filterLoader, "filterLoader is marked non-null but is null");
        Objects.requireNonNull(httpServletRequest, "httpServletRequest is marked non-null but is null");
        Objects.requireNonNull(acceptableValuesProviderLoader, "acceptableValuesProviderLoader is marked non-null but is null");
        Objects.requireNonNull(pureLoadedIdentifiedFileSaver, "pureLoadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(objectUrlIdResolver, "objectUrlIdResolver is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(supplierAuthorityFondProvider, "supplierAuthorityFondProvider is marked non-null but is null");
        Objects.requireNonNull(defValAcceptableValuesGroupLoader, "defValAcceptableValuesGroupLoader is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        this.fondLoader = fondLoader;
        this.documentFondLoader = documentFondLoader;
        this.authorityFondLoader = authorityFondLoader;
        this.cacheService = cacheService;
        this.jdbcTemplate = jdbcTemplate;
        this.notCriticalJdbcTemplate = notCriticalJdbcTemplate;
        this.queryFactory = queryFactory;
        this.entityManager = entityManager;
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.settingLoader = settingLoader;
        this.converterRegisterer = converterRegisterer;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
        this.userLoader = userLoader;
        this.filterLoader = filterLoader;
        this.httpServletRequest = httpServletRequest;
        this.acceptableValuesProviderLoader = acceptableValuesProviderLoader;
        this.pureLoadedIdentifiedFileSaver = pureLoadedIdentifiedFileSaver;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.objectUrlIdResolver = objectUrlIdResolver;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.authenticationHolder = authenticationHolder;
        this.supplierAuthorityFondProvider = supplierAuthorityFondProvider;
        this.defValAcceptableValuesGroupLoader = defValAcceptableValuesGroupLoader;
        this.executorService = executorService;
    }

    private static /* synthetic */ boolean lambda$currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord$16(EditLevel lastRecordEditLevel, EditorAccount editorAccount) {
        return editorAccount.getEditLevel().isBetterThan(lastRecordEditLevel);
    }
}

