/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.mail.Mailer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.mail.MailerMailService;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.contact.ContactManager;
import cz.kpsys.portaro.user.locale.UserLocaleResolver;
import cz.kpsys.portaro.view.web.rest.mail.MailApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;

@Configuration
public class MailConfig {
    @NonNull
    private final Mailer<Department> mailer;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final ContactManager contactManager;
    @NonNull
    private final FileDataStreamer securedFileDataStreamer;
    @NonNull
    private final UserLocaleResolver userLocaleResolver;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final SettingLoader settingLoader;

    @Bean
    public MailApiController mailApiController() {
        return new MailApiController(this.mailService);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public MailService mailService() {
        return new MailerMailService(this.mailer, this.contactManager, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.userLocaleResolver, this.securedFileDataStreamer, this.translator, this.systemEmailProvider(), this.settingLoader.getDepartmentedProvider(SettingKeys.ORDERS_RECIPIENT_EMAIL));
    }

    @Bean
    public ContextualProvider<Department, String> systemEmailProvider() {
        return ctx -> {
            String replyToAddress = (String)this.settingLoader.getDepartmentedProvider(SettingKeys.SMTP_FROM_LIBRARY_MAILS_REPLY_TO_ADDRESS).getOn(ctx);
            if (replyToAddress != null) {
                return replyToAddress;
            }
            return (String)this.settingLoader.getDepartmentedProvider(SettingKeys.SMTP_SENDER_ADDRESS).getOn(ctx);
        };
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
    }

    @ConstructorProperties(value={"mailer", "mailService", "contactManager", "securedFileDataStreamer", "userLocaleResolver", "translator", "settingLoader"})
    @Generated
    public MailConfig(@NonNull Mailer<Department> mailer, @NonNull MailService mailService, @NonNull ContactManager contactManager, @NonNull FileDataStreamer securedFileDataStreamer, @NonNull UserLocaleResolver userLocaleResolver, @NonNull Translator<Department> translator, @NonNull SettingLoader settingLoader) {
        Objects.requireNonNull(mailer, "mailer is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(contactManager, "contactManager is marked non-null but is null");
        Objects.requireNonNull(securedFileDataStreamer, "securedFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(userLocaleResolver, "userLocaleResolver is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        this.mailer = mailer;
        this.mailService = mailService;
        this.contactManager = contactManager;
        this.securedFileDataStreamer = securedFileDataStreamer;
        this.userLocaleResolver = userLocaleResolver;
        this.translator = translator;
        this.settingLoader = settingLoader;
    }
}

