/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.FallbackedProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SavingProvider;
import cz.kpsys.portaro.commons.object.ValidatingProvider;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.core.application.PortaroVersion;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceKeyExpiredPredicate;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceProvider;
import cz.kpsys.portaro.licence.LicenceKeyExpiredException;
import cz.kpsys.portaro.licence.LicenceServerFetchingLicenceKeyProvider;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.DelegatingValueCustomSettingSaver;
import cz.kpsys.portaro.setting.IniNotSetException;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.view.web.LicenceApiController;
import cz.kpsys.portaro.view.web.LicenceKeyApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestOperations;

@Configuration
public class LicenceUpdaterConfig {
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Saver<CustomSetting<String>> customSettingSaver;
    @NonNull
    private final @NonNull Provider<@NonNull String> rootSerialCodeProvider;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;
    @NonNull
    private final PortaroVersion portaroVersion;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider;
    @NonNull
    private final LicenceKeyDecoder licenceKeyDecoder;
    @NonNull
    private final CustomSettingLoader customSettingLoader;

    @Bean
    public LicenceKeyApiController licenceKeyApiController() {
        return new LicenceKeyApiController(this.settingLoader.getDepartmentedProvider(SettingKeys.LICENCE_KEY));
    }

    @Bean
    public LicenceApiController licenceApiController() {
        return new LicenceApiController(this.licenceProvider(), this.savingLicenceServerJwtLicenceKeyProvider());
    }

    @Bean
    public Provider<@NonNull Licence> licenceProvider() {
        return new LicenceKeyDecodingLicenceProvider((Supplier)this.jwtLicenceKeyProvider(), this.licenceKeyDecoder);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public Provider<@NonNull String> jwtLicenceKeyProvider() {
        @NonNull Provider fromIniProvider = this.settingLoader.getOnRootProvider(SettingKeys.LICENCE_KEY).throwingWhenNull();
        @NonNull LicenceKeyDecodingLicenceKeyExpiredPredicate keyExpired = new LicenceKeyDecodingLicenceKeyExpiredPredicate(this.licenceKeyDecoder);
        @NonNull ValidatingProvider validatingFromIniProvider = ValidatingProvider.invalidWhen((Provider)fromIniProvider, (Predicate)keyExpired, expiredJwt -> new LicenceKeyExpiredException());
        return new FallbackedProvider((Provider)validatingFromIniProvider, this.savingLicenceServerJwtLicenceKeyProvider()).fallbackOnException(IniNotSetException.class).fallbackOnException(LicenceKeyExpiredException.class);
    }

    @Bean
    public Provider<@NonNull String> savingLicenceServerJwtLicenceKeyProvider() {
        LicenceServerFetchingLicenceKeyProvider fromLicenceServerProvider = new LicenceServerFetchingLicenceKeyProvider(this.rest, this.rootSerialCodeProvider, this.settingLoader.getOnRootProvider(SettingKeys.KPSYS_API_KEY).throwingWhenNull()).withExtraData("seatable.provided_url", this.rootServerUrlProvider).withExtraData("seatable.portaro_version", () -> ((PortaroVersion)this.portaroVersion).getValue()).withExtraData("seatable.portaro_business_version", () -> ((BusinessVersion)this.currentVersionProvider.get()).getValue()).withExtraData("seatable.current_licence_version", () -> ((BusinessVersion)this.licenceVersionProvider.get()).getValue());
        return new SavingProvider((Provider)fromLicenceServerProvider, this.licenceKeySaver());
    }

    @Bean
    public Saver<String> licenceKeySaver() {
        return new DelegatingValueCustomSettingSaver(this.customSettingSaver, (SettingTypeId)SettingKeys.LICENCE_KEY, this.rootDepartmentIdProvider, this.customSettingLoader);
    }

    @Logged
    @Scheduled(initialDelay=360000L, fixedDelay=32400000L)
    @SchedulerLock(name="LicenceUpdaterConfig_updateLicenceKey", lockAtLeastFor="PT10M", lockAtMostFor="PT20M")
    public void updateLicenceKey() {
        this.savingLicenceServerJwtLicenceKeyProvider().get();
    }

    @ConstructorProperties(value={"rest", "settingLoader", "customSettingSaver", "rootSerialCodeProvider", "rootServerUrlProvider", "portaroVersion", "currentVersionProvider", "licenceVersionProvider", "rootDepartmentIdProvider", "licenceKeyDecoder", "customSettingLoader"})
    @Generated
    public LicenceUpdaterConfig(@NonNull RestOperations rest, @NonNull SettingLoader settingLoader, @NonNull Saver<CustomSetting<String>> customSettingSaver, @NonNull @NonNull Provider<@NonNull String> rootSerialCodeProvider, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider, @NonNull PortaroVersion portaroVersion, @NonNull @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider, @NonNull @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider, @NonNull LicenceKeyDecoder licenceKeyDecoder, @NonNull CustomSettingLoader customSettingLoader) {
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(rootSerialCodeProvider, "rootSerialCodeProvider is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        Objects.requireNonNull(currentVersionProvider, "currentVersionProvider is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentIdProvider, "rootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(licenceKeyDecoder, "licenceKeyDecoder is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        this.rest = rest;
        this.settingLoader = settingLoader;
        this.customSettingSaver = customSettingSaver;
        this.rootSerialCodeProvider = rootSerialCodeProvider;
        this.rootServerUrlProvider = rootServerUrlProvider;
        this.portaroVersion = portaroVersion;
        this.currentVersionProvider = currentVersionProvider;
        this.licenceVersionProvider = licenceVersionProvider;
        this.rootDepartmentIdProvider = rootDepartmentIdProvider;
        this.licenceKeyDecoder = licenceKeyDecoder;
        this.customSettingLoader = customSettingLoader;
    }
}

