/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TtlCachedProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.DepartmentEntity;
import cz.kpsys.portaro.domaineddepartment.DefaultDepartmentActivator;
import cz.kpsys.portaro.domaineddepartment.DefaultDomainedDepartmentCreator;
import cz.kpsys.portaro.domaineddepartment.DepartmentActivator;
import cz.kpsys.portaro.domaineddepartment.DepartmentCreatedResponseCurrentPageDialogResolver;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreationRequest;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreationRequestToDepartmentEntityConverter;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreator;
import cz.kpsys.portaro.domaineddepartment.ServerUrlUniquenessResolver;
import cz.kpsys.portaro.domaineddepartment.UniquenessResolver;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.form.editor2.text.TextValueEditorModifier;
import cz.kpsys.portaro.form.property.AcceptableValuesResolver;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationWithDepartments;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.web.page.CompositeCurrentPageDialogsResolver;
import cz.kpsys.portaro.web.page.CurrentPageDialogResolver;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class DepartmentCreationConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepartmentCreationConfig.class);
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final AllValuesProvider<Department> departmentLoader;
    @NonNull
    private final Saver<DepartmentEntity> departmentEntitySaver;
    @NonNull
    private final Saver<CustomSetting<String>> customSettingSaver;
    @NonNull
    private final Saver<LocationWithDepartments> locationWithDepartmentsSaver;
    @NonNull
    private final AllValuesProvider<Location> locationLoader;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final ByIdLoadable<DepartmentEntity, Integer> departmentEntityLoader;
    @NonNull
    private final CompositeCurrentPageDialogsResolver currentPageDialogsResolver;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;

    @Bean
    public AcceptableValuesResolver<DomainedDepartmentCreationRequest, Department> departmentCreationAllowedParentDepartmentsResolver() {
        return (request, currentDepartment) -> this.departmentCreationAllowedParentDepartments().getAll();
    }

    @Bean
    public TextValueEditorModifier<DomainedDepartmentCreationRequest> departmentCreationServerUrlEditorModifier() {
        return new DomainedDepartmentCreationRequest.DepartmentCreationServerUrlEditorModifier(this.rootServerUrlProvider.throwingWhenNull());
    }

    @Bean
    public AllValuesProvider<Department> departmentCreationAllowedParentDepartments() {
        return () -> {
            if (((Boolean)this.settingLoader.getOnRoot(SettingKeys.DEPARTMENT_CREATION_ACCEPTABLE_PARENT_DEPARTMENTS_SHOW_ALL_CHILDS)).booleanValue()) {
                Department currentDepartment = (Department)this.rootDepartmentProvider.get();
                return this.departmentAccessor.getChildren(currentDepartment);
            }
            List departmentIds = (List)this.settingLoader.getOnRoot(SettingKeys.DEPARTMENT_CREATION_ACCEPTABLE_PARENT_DEPARTMENTS);
            return ListUtil.filterAndSortByRule((Collection)this.departmentAccessor.getAll(), (Collection)departmentIds);
        };
    }

    @Bean
    public DomainedDepartmentCreator domainedDepartmentCreator() {
        return new DefaultDomainedDepartmentCreator(new DomainedDepartmentCreationRequestToDepartmentEntityConverter(this.departmentLoader), this.departmentEntitySaver, this.customSettingSaver, this.locationWithDepartmentsSaver, this.locationLoader, (SettingTypeId)SettingKeys.SERVER_URL, this.eventer, this.customSettingLoader);
    }

    @Bean
    public DepartmentActivator departmentActivator() {
        return new DefaultDepartmentActivator(this.departmentEntityLoader, this.departmentEntitySaver, this.eventer);
    }

    @Bean
    public UniquenessResolver<String> serverUrlUniquenessResolver() {
        return new ServerUrlUniquenessResolver((List)new ProvidedProxiedList((Provider)TtlCachedProvider.ofSeconds((long)10L, () -> new ArrayList(this.settingLoader.getContextToValueMap(SettingKeys.SERVER_URL).values()))));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerCurrentPageDialogs() {
        this.currentPageDialogsResolver.add(Integer.valueOf(1000), (CurrentPageDialogResolver)new DepartmentCreatedResponseCurrentPageDialogResolver());
    }

    @ConstructorProperties(value={"rootDepartmentProvider", "departmentAccessor", "settingLoader", "departmentLoader", "departmentEntitySaver", "customSettingSaver", "locationWithDepartmentsSaver", "locationLoader", "eventer", "departmentEntityLoader", "currentPageDialogsResolver", "customSettingLoader", "rootServerUrlProvider"})
    @Generated
    public DepartmentCreationConfig(@NonNull Provider<Department> rootDepartmentProvider, @NonNull DepartmentAccessor departmentAccessor, @NonNull SettingLoader settingLoader, @NonNull AllValuesProvider<Department> departmentLoader, @NonNull Saver<DepartmentEntity> departmentEntitySaver, @NonNull Saver<CustomSetting<String>> customSettingSaver, @NonNull Saver<LocationWithDepartments> locationWithDepartmentsSaver, @NonNull AllValuesProvider<Location> locationLoader, @NonNull Eventer eventer, @NonNull ByIdLoadable<DepartmentEntity, Integer> departmentEntityLoader, @NonNull CompositeCurrentPageDialogsResolver currentPageDialogsResolver, @NonNull CustomSettingLoader customSettingLoader, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider) {
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentEntitySaver, "departmentEntitySaver is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(locationWithDepartmentsSaver, "locationWithDepartmentsSaver is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(departmentEntityLoader, "departmentEntityLoader is marked non-null but is null");
        Objects.requireNonNull(currentPageDialogsResolver, "currentPageDialogsResolver is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.departmentAccessor = departmentAccessor;
        this.settingLoader = settingLoader;
        this.departmentLoader = departmentLoader;
        this.departmentEntitySaver = departmentEntitySaver;
        this.customSettingSaver = customSettingSaver;
        this.locationWithDepartmentsSaver = locationWithDepartmentsSaver;
        this.locationLoader = locationLoader;
        this.eventer = eventer;
        this.departmentEntityLoader = departmentEntityLoader;
        this.currentPageDialogsResolver = currentPageDialogsResolver;
        this.customSettingLoader = customSettingLoader;
        this.rootServerUrlProvider = rootServerUrlProvider;
    }
}

