/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grini\u010das laiks",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apijas ziemas laiks",
               "",
               "Apijas vasaras laiks",
               "",
               "Apijas laiks",
               "",
            };
        final String[] Cook = new String[] {
               "Kuka salu ziemas laiks",
               "",
               "Kuka salu vasaras laiks",
               "",
               "Kuka salu laiks",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubas ziemas laiks",
               "CST",
               "Kubas vasaras laiks",
               "CDT",
               "Kubas laiks",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei ziemas laiks",
               "",
               "Fid\u017ei vasaras laiks",
               "",
               "Fid\u017ei laiks",
               "",
            };
        final String[] Gulf = new String[] {
               "Persijas l\u012b\u010da laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdas ziemas laiks",
               "",
               "Hovdas vasaras laiks",
               "",
               "Hovdas laiks",
               "",
            };
        final String[] Iran = new String[] {
               "Ir\u0101nas ziemas laiks",
               "",
               "Ir\u0101nas vasaras laiks",
               "",
               "Ir\u0101nas laiks",
               "",
            };
        final String[] Niue = new String[] {
               "Niues laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omskas ziemas laiks",
               "",
               "Omskas vasaras laiks",
               "",
               "Omskas laiks",
               "",
            };
        final String[] Peru = new String[] {
               "Peru ziemas laiks",
               "",
               "Peru vasaras laiks",
               "",
               "Peru laiks",
               "",
            };
        final String[] Truk = new String[] {
               "\u010c\u016bkas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Veika salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010c\u012bles ziemas laiks",
               "",
               "\u010c\u012bles vasaras laiks",
               "",
               "\u010c\u012bles laiks",
               "",
            };
        final String[] China = new String[] {
               "\u0136\u012bnas ziemas laiks",
               "CST",
               "\u0136\u012bnas vasaras laiks",
               "CDT",
               "\u0136\u012bnas laiks",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosu (K\u012blinga) salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Deivisas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijas ziemas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Jap\u0101nas ziemas laiks",
               "JST",
               "Jap\u0101nas vasaras laiks",
               "JDT",
               "Jap\u0101nas laiks",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korejas ziemas laiks",
               "KST",
               "Korejas vasaras laiks",
               "KST",
               "Korejas laiks",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nep\u0101las laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa ziemas laiks",
               "SST",
               "Samoa vasaras laiks",
               "SST",
               "Samoa laiks",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u0160ovas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongas ziemas laiks",
               "",
               "Tongas vasaras laiks",
               "",
               "Tongas laiks",
               "",
            };
        final String[] Yukon = new String[] {
               "Jukonas laiks",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "A\u013caskas ziemas laiks",
               "AKST",
               "A\u013caskas vasaras laiks",
               "AKDT",
               "A\u013caskas laiks",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazones ziemas laiks",
               "",
               "Amazones vasaras laiks",
               "",
               "Amazones laiks",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadiras ziemas laiks",
               "",
               "Anadiras vasaras laiks",
               "",
               "Anadiras laiks",
               "",
            };
        final String[] Azores = new String[] {
               "Azoru salu ziemas laiks",
               "",
               "Azoru salu vasaras laiks",
               "",
               "Azoru salu laiks",
               "",
            };
        final String[] Bhutan = new String[] {
               "But\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejas Darusalamas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Lieldienu salas ziemas laiks",
               "",
               "Lieldienu salas vasaras laiks",
               "",
               "Lieldienu salas laiks",
               "",
            };
        final String[] Guyana = new String[] {
               "Gaj\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izra\u0113las ziemas laiks",
               "IST",
               "Izra\u0113las vasaras laiks",
               "IDT",
               "Izra\u0113las laiks",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mosonas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Maskavas ziemas laiks",
               "MSK",
               "Maskavas vasaras laiks",
               "MSK",
               "Maskavas laiks",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponap\u0113 laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samaras ziemas laiks",
               "",
               "Samaras vasaras laiks",
               "",
               "Samaras laiks",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taibei ziemas laiks",
               "CST",
               "Taibei vasaras laiks",
               "CDT",
               "Taibei laiks",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostokas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Volisas un Futunas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ar\u0101bijas pussalas ziemas laiks",
               "",
               "Ar\u0101bijas pussalas vasaras laiks",
               "",
               "Ar\u0101bijas pussalas laiks",
               "",
            };
        final String[] Armenia = new String[] {
               "Arm\u0113nijas ziemas laiks",
               "",
               "Arm\u0113nijas vasaras laiks",
               "",
               "Arm\u0113nijas laiks",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bol\u012bvijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010cetemas ziemas laiks",
               "",
               "\u010cetemas vasaras laiks",
               "",
               "\u010cetemas laiks",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Univers\u0101lais koordin\u0113tais laiks",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambj\u0113 salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzijas ziemas laiks",
               "",
               "Gruzijas vasaras laiks",
               "",
               "Gruzijas laiks",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskas ziemas laiks",
               "",
               "Irkutskas vasaras laiks",
               "",
               "Irkutskas laiks",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanas ziemas laiks",
               "",
               "Magadanas vasaras laiks",
               "",
               "Magadanas laiks",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkas salas ziemas laiks",
               "",
               "Norfolkas salas vasaras laiks",
               "",
               "Norfolkas salas laiks",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernandu di Noro\u0146as ziemas laiks",
               "",
               "Fernandu di Noro\u0146as vasaras laiks",
               "",
               "Fernandu di Noro\u0146as laiks",
               "",
            };
        final String[] Reunion = new String[] {
               "Reinjonas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Roteras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Z\u0101lamana salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvajas ziemas laiks",
               "",
               "Urugvajas vasaras laiks",
               "",
               "Urugvajas laiks",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu ziemas laiks",
               "",
               "Vanuatu vasaras laiks",
               "",
               "Vanuatu laiks",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskas ziemas laiks",
               "",
               "Jakutskas vasaras laiks",
               "",
               "Jakutskas laiks",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantijas ziemas laiks",
               "AST",
               "Atlantijas vasaras laiks",
               "ADT",
               "Atlantijas laiks",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Braz\u012blijas ziemas laiks",
               "",
               "Braz\u012blijas vasaras laiks",
               "",
               "Braz\u012blijas laiks",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camorra ziemas laiks",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbijas ziemas laiks",
               "",
               "Kolumbijas vasaras laiks",
               "",
               "Kolumbijas laiks",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklenda (Malvinu) salu ziemas laiks",
               "",
               "Folklenda (Malvinu) salu vasaras laiks",
               "",
               "Folklenda (Malvinu) salu laiks",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaizijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Mald\u012bvijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatoras ziemas laiks",
               "",
               "Ulanbatoras vasaras laiks",
               "",
               "Ulanbatoras laiks",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakist\u0101nas ziemas laiks",
               "PKT",
               "Pakist\u0101nas vasaras laiks",
               "PKST",
               "Pakist\u0101nas laiks",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvajas ziemas laiks",
               "",
               "Paragvajas vasaras laiks",
               "",
               "Paragvajas laiks",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitk\u0113rnas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahal\u012bnas ziemas laiks",
               "",
               "Sahal\u012bnas vasaras laiks",
               "",
               "Sahal\u012bnas laiks",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argent\u012bnas ziemas laiks",
               "",
               "Argent\u012bnas vasaras laiks",
               "",
               "Argent\u012bnas laiks",
               "",
            };
        final String[] Christmas = new String[] {
               "Ziemsv\u0113tku salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongas ziemas laiks",
               "HKT",
               "Honkongas vasaras laiks",
               "HKST",
               "Honkongas laiks",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indo\u0137\u012bnas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovskas-Kam\u010datskas ziemas laiks",
               "",
               "Petropavlovskas-Kam\u010datskas vasaras laiks",
               "",
               "Petropavlovskas-Kam\u010datskas laiks",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizst\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lorda Hava salas ziemas laiks",
               "",
               "Lorda Hava salas vasaras laiks",
               "",
               "Lorda Hava salas laiks",
               "",
            };
        final String[] Marquesas = new String[] {
               "Mar\u0137\u012bza salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Maur\u012bcijas ziemas laiks",
               "",
               "Maur\u012bcijas vasaras laiks",
               "",
               "Maur\u012bcijas laiks",
               "",
            };
        final String[] Singapore = new String[] {
               "Singap\u016bras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecu\u0113las laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradas ziemas laiks",
               "MSK",
               "Volgogradas vasaras laiks",
               "MSK",
               "Volgogradas laiks",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017e\u0101nas ziemas laiks",
               "",
               "Azerbaid\u017e\u0101nas vasaras laiks",
               "",
               "Azerbaid\u017e\u0101nas laiks",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161as ziemas laiks",
               "",
               "Banglade\u0161as vasaras laiks",
               "",
               "Banglade\u0161as laiks",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaboverdes ziemas laiks",
               "",
               "Kaboverdes vasaras laiks",
               "",
               "Kaboverdes laiks",
               "",
            };
        final String[] East_Timor = new String[] {
               "Austrumtimoras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161e\u013cu salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikist\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekist\u0101nas ziemas laiks",
               "",
               "Uzbekist\u0101nas vasaras laiks",
               "",
               "Uzbekist\u0101nas laiks",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganist\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskas ziemas laiks",
               "",
               "Krasnojarskas vasaras laiks",
               "",
               "Krasnojarskas laiks",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Jaunz\u0113landes ziemas laiks",
               "NZST",
               "Jaunz\u0113landes vasaras laiks",
               "NZDT",
               "Jaunz\u0113landes laiks",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskas ziemas laiks",
               "",
               "Novosibirskas vasaras laiks",
               "",
               "Novosibirskas laiks",
               "",
            };
        final String[] Philippines = new String[] {
               "Filip\u012bnu ziemas laiks",
               "PST",
               "Filip\u012bnu vasaras laiks",
               "PDT",
               "Filip\u012bnu laiks",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokas ziemas laiks",
               "",
               "Vladivostokas vasaras laiks",
               "",
               "Vladivostokas laiks",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijas oke\u0101na laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lainas salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u0145\u016bfaundlendas ziemas laiks",
               "NST",
               "\u0145\u016bfaundlendas vasaras laiks",
               "NDT",
               "\u0145\u016bfaundlendas laiks",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenist\u0101nas ziemas laiks",
               "",
               "Turkmenist\u0101nas vasaras laiks",
               "",
               "Turkmenist\u0101nas laiks",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francijas Gvi\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Jaunkaledonijas ziemas laiks",
               "",
               "Jaunkaledonijas vasaras laiks",
               "",
               "Jaunkaledonijas laiks",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Dienvidd\u017eord\u017eijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgas ziemas laiks",
               "",
               "Jekaterinburgas vasaras laiks",
               "",
               "Jekaterinburgas laiks",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centr\u0101l\u0101frikas laiks",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austrum\u0101frikas laiks",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Rietum\u0101frikas ziemas laiks",
               "WAT",
               "Rietum\u0101frikas vasaras laiks",
               "WAT",
               "Rietum\u0101frikas laiks",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dimondirvilas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Centr\u0101leiropas ziemas laiks",
               "CET",
               "Centr\u0101leiropas vasaras laiks",
               "CEST",
               "Centr\u0101leiropas laiks",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Austrumeiropas ziemas laiks",
               "EET",
               "Austrumeiropas vasaras laiks",
               "EEST",
               "Austrumeiropas laiks",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Rietumeiropas ziemas laiks",
               "WET",
               "Rietumeiropas vasaras laiks",
               "WEST",
               "Rietumeiropas laiks",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikas Klus\u0101 oke\u0101na piekrastes ziemas laiks",
               "MST",
               "Meksikas Klus\u0101 oke\u0101na piekrastes vasaras laiks",
               "MDT",
               "Meksikas Klus\u0101 oke\u0101na piekrastes laiks",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Dienvid\u0101frikas ziemas laiks",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Centr\u0101lais ziemas laiks",
               "CST",
               "Centr\u0101lais vasaras laiks",
               "CDT",
               "Centr\u0101lais laiks",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Austrumu ziemas laiks",
               "EST",
               "Austrumu vasaras laiks",
               "EST",
               "Austrumu laiks",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Klus\u0101 oke\u0101na ziemas laiks",
               "PST",
               "Klus\u0101 oke\u0101na vasaras laiks",
               "PDT",
               "Klus\u0101 oke\u0101na laiks",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Francijas Dienvidj\u016bru un Antarktikas teritorijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberta salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaju\u2013Aleutu ziemas laiks",
               "HST",
               "Havaju\u2013Aleutu vasaras laiks",
               "HST",
               "Havaju\u2013Aleutu laiks",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u0113niksa salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Senpj\u0113ras un Mikelonas ziemas laiks",
               "",
               "Senpj\u0113ras un Mikelonas vasaras laiks",
               "",
               "Senpj\u0113ras un Mikelonas laiks",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kalnu ziemas laiks",
               "MST",
               "Kalnu vasaras laiks",
               "MST",
               "Kalnu laiks",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "M\u0101r\u0161ala salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Zieme\u013crietumu Meksikas ziemas laiks",
               "",
               "Zieme\u013crietumu Meksikas vasaras laiks",
               "",
               "Zieme\u013crietumu Meksikas laiks",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Jaungvinejas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Austr\u0101lijas centr\u0101lais ziemas laiks",
               "ACST",
               "Austr\u0101lijas centr\u0101lais vasaras laiks",
               "ACDT",
               "Austr\u0101lijas centr\u0101lais laiks",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Austr\u0101lijas austrumu ziemas laiks",
               "AEST",
               "Austr\u0101lijas austrumu vasaras laiks",
               "AEDT",
               "Austr\u0101lijas austrumu laiks",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Austr\u0101lijas rietumu ziemas laiks",
               "AWST",
               "Austr\u0101lijas rietumu vasaras laiks",
               "AWDT",
               "Austr\u0101lijas rietumu laiks",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Austrumgrenlandes ziemas laiks",
               "",
               "Austrumgrenlandes vasaras laiks",
               "",
               "Austrumgrenlandes laiks",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Rietumgrenlandes ziemas laiks",
               "",
               "Rietumgrenlandes vasaras laiks",
               "",
               "Rietumgrenlandes laiks",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Centr\u0101lindon\u0113zijas laiks",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austrumindon\u0113zijas laiks",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Rietumindon\u0113zijas laiks",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Austrumkazahst\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Rietumkazahst\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Austr\u0101lijas centr\u0101lais rietumu ziemas laiks",
               "",
               "Austr\u0101lijas centr\u0101lais rietumu vasaras laiks",
               "",
               "Austr\u0101lijas centr\u0101lais rietumu laiks",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grini\u010das laiks",
                    "GMT",
                    "\u012arijas ziemas laiks",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grini\u010das laiks",
                    "GMT",
                    "Lielbrit\u0101nijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grini\u010das laiks",
                    "GMT",
                    "Lielbrit\u0101nijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adena" },
            { "timezone.excity.Asia/Hovd", "Hovda" },
            { "timezone.excity.Asia/Omsk", "Omska" },
            { "timezone.excity.Asia/Oral", "Orala" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u0101na" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dubaija" },
            { "timezone.excity.Asia/Kabul", "Kabula" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katara" },
            { "timezone.excity.Asia/Seoul", "Seula" },
            { "timezone.excity.Asia/Tokyo", "Tokija" },
            { "timezone.excity.Asia/Tomsk", "Tomska" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "D\u017e\u016bba" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadira" },
            { "timezone.excity.Asia/Aqtobe", "Aktebe" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Beir\u016bta" },
            { "timezone.excity.Asia/Brunei", "Bruneja" },
            { "timezone.excity.Asia/Hebron", "Hebrona" },
            { "timezone.excity.Asia/Kuwait", "Kuveita" },
            { "timezone.excity.Asia/Muscat", "Maskata" },
            { "timezone.excity.Asia/Riyadh", "Rij\u0101da" },
            { "timezone.excity.Asia/Saigon", "Ho\u0161imina" },
            { "timezone.excity.Asia/Taipei", "Taibei" },
            { "timezone.excity.Asia/Tehran", "Teher\u0101na" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "nezin\u0101ma pils\u0113ta" },
            { "timezone.excity.Europe/Kiev", "Kijeva" },
            { "timezone.excity.Europe/Riga", "R\u012bga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mae" },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kaira" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Dakar", "Dakara" },
            { "timezone.excity.Africa/Lagos", "Lagosa" },
            { "timezone.excity.Africa/Tunis", "Tunisa" },
            { "timezone.excity.America/Adak", "Adaka" },
            { "timezone.excity.America/Nome", "Noma" },
            { "timezone.excity.Asia/Baghdad", "Bagd\u0101de" },
            { "timezone.excity.Asia/Bahrain", "Bahreina" },
            { "timezone.excity.Asia/Bangkok", "Bangkoka" },
            { "timezone.excity.Asia/Barnaul", "Barnaula" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161keka" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutska" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "timezone.excity.Asia/Karachi", "Kar\u0101\u010di" },
            { "timezone.excity.Asia/Kuching", "Ku\u010dina" },
            { "timezone.excity.Asia/Magadan", "Magadana" },
            { "timezone.excity.Asia/Nicosia", "Nikosija" },
            { "timezone.excity.Asia/Rangoon", "Ranguna" },
            { "timezone.excity.Asia/Yakutsk", "Jakutska" },
            { "timezone.excity.Asia/Yerevan", "Erev\u0101na" },
            { "timezone.excity.Europe/Kirov", "Kirova" },
            { "timezone.excity.Europe/Minsk", "Minska" },
            { "timezone.excity.Europe/Paris", "Par\u012bze" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Europe/Vaduz", "Vaduca" },
            { "timezone.excity.Indian/Cocos", "Kokosu (K\u012blinga) sala" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Pacific/Guam", "Guama" },
            { "timezone.excity.Pacific/Truk", "\u010c\u016bka" },
            { "timezone.excity.Pacific/Wake", "Veika sala" },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Banjul", "Band\u017eula" },
            { "timezone.excity.Africa/Bissau", "Bisava" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Maputo", "Maputu" },
            { "timezone.excity.Africa/Niamey", "Niameja" },
            { "timezone.excity.America/Bahia", "Baija" },
            { "timezone.excity.America/Belem", "Belena" },
            { "timezone.excity.America/Boise", "Boisisitija" },
            { "timezone.excity.America/Jujuy", "Huhuja" },
            { "timezone.excity.America/Thule", "Tule" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161gabata" },
            { "timezone.excity.Asia/Calcutta", "Kalk\u0101ta" },
            { "timezone.excity.Asia/Damascus", "Damaska" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Jayapura", "D\u017eajapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasara" },
            { "timezone.excity.Asia/Qostanay", "Kostanaja" },
            { "timezone.excity.Asia/Sakhalin", "Sahal\u012bna" },
            { "timezone.excity.Asia/Shanghai", "\u0160anhaja" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kenta" },
            { "timezone.excity.Asia/Ust-Nera", "Ustj\u0146era" },
            { "timezone.excity.Europe/Athens", "At\u0113nas" },
            { "timezone.excity.Europe/Berlin", "Berl\u012bne" },
            { "timezone.excity.Europe/Dublin", "Dublina" },
            { "timezone.excity.Europe/Jersey", "D\u017e\u0113rsija" },
            { "timezone.excity.Europe/Lisbon", "Lisabona" },
            { "timezone.excity.Europe/London", "Londona" },
            { "timezone.excity.Europe/Madrid", "Madride" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Maskava" },
            { "timezone.excity.Europe/Prague", "Pr\u0101ga" },
            { "timezone.excity.Europe/Tirane", "Tir\u0101na" },
            { "timezone.excity.Europe/Vienna", "V\u012bne" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Zagreba" },
            { "timezone.excity.Europe/Zurich", "C\u012brihe" },
            { "timezone.excity.Indian/Chagos", "\u010cagosa" },
            { "timezone.excity.Indian/Comoro", "Komoras" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abid\u017eana" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u012bra" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Tripoli", "Tripole" },
            { "timezone.excity.America/Belize", "Beliza" },
            { "timezone.excity.America/Cancun", "Kankuna" },
            { "timezone.excity.America/Cayman", "Kaimanu salas" },
            { "timezone.excity.America/Cuiaba", "Kujaba" },
            { "timezone.excity.America/Dawson", "Dousona" },
            { "timezone.excity.America/Denver", "Denvera" },
            { "timezone.excity.America/Guyana", "Gaj\u0101na" },
            { "timezone.excity.America/Inuvik", "Inuvika" },
            { "timezone.excity.America/Juneau", "D\u017euno" },
            { "timezone.excity.America/La_Paz", "Lapasa" },
            { "timezone.excity.America/Maceio", "Masejo" },
            { "timezone.excity.America/Manaus", "Manausa" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Naso" },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.America/Regina", "Rid\u017eaina" },
            { "timezone.excity.Asia/Hong_Kong", "Honkonga" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzaleme" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pontianak", "Pontianaka" },
            { "timezone.excity.Asia/Pyongyang", "Phenjana" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkanda" },
            { "timezone.excity.Asia/Singapore", "Singap\u016bra" },
            { "timezone.excity.Asia/Vientiane", "Vjen\u010dana" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Saratov", "Saratova" },
            { "timezone.excity.Europe/Tallinn", "Tallina" },
            { "timezone.excity.Europe/Vatican", "Vatik\u0101ns" },
            { "timezone.excity.Europe/Vilnius", "Vi\u013c\u0146a" },
            { "timezone.excity.Indian/Mayotte", "Majota" },
            { "timezone.excity.Indian/Reunion", "Reinjona" },
            { "timezone.excity.Pacific/Easter", "Lieldienu sala" },
            { "timezone.excity.Pacific/Kanton", "Kantona" },
            { "timezone.excity.Pacific/Kosrae", "Kosraja" },
            { "timezone.excity.Pacific/Majuro", "Mad\u017euro" },
            { "timezone.excity.Pacific/Midway", "Midvejs" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Ponape", "Ponpeja" },
            { "timezone.excity.Pacific/Saipan", "Saipana" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "timezone.excity.Pacific/Wallis", "Volisa" },
            { "timezone.excity.Africa/Blantyre", "Blantaira" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibutija" },
            { "timezone.excity.Africa/El_Aaiun", "Aj\u016bna" },
            { "timezone.excity.Africa/Freetown", "Fr\u012btauna" },
            { "timezone.excity.Africa/Khartoum", "Hart\u016bma" },
            { "timezone.excity.Africa/Kinshasa", "Kin\u0161asa" },
            { "timezone.excity.Africa/Monrovia", "Monrovija" },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.Africa/Sao_Tome", "Santome" },
            { "timezone.excity.Africa/Windhoek", "Vindhuka" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.America/Caracas", "Karakasa" },
            { "timezone.excity.America/Cayenne", "Kajenna" },
            { "timezone.excity.America/Chicago", "\u010cik\u0101ga" },
            { "timezone.excity.America/Cordoba", "Kordova" },
            { "timezone.excity.America/Creston", "Krestona" },
            { "timezone.excity.America/Curacao", "Kirasao" },
            { "timezone.excity.America/Detroit", "Detroita" },
            { "timezone.excity.America/Godthab", "N\u016bka" },
            { "timezone.excity.America/Grenada", "Gren\u0101da" },
            { "timezone.excity.America/Halifax", "Helifeksa" },
            { "timezone.excity.America/Iqaluit", "Ikaluita" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.America/Managua", "Managva" },
            { "timezone.excity.America/Marigot", "Merigota" },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "timezone.excity.America/Moncton", "Monktona" },
            { "timezone.excity.America/Nipigon", "Nipigona" },
            { "timezone.excity.America/Noronha", "Noro\u0146a" },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.America/Phoenix", "F\u012bniksa" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.America/Yakutat", "Jakutata" },
            { "timezone.excity.Asia/Choibalsan", "\u010coibalsana" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompe\u0146a" },
            { "timezone.excity.Atlantic/Azores", "Azoru salas" },
            { "timezone.excity.Atlantic/Canary", "Kan\u0101riju salas" },
            { "timezone.excity.Atlantic/Faeroe", "F\u0113ru salas" },
            { "timezone.excity.Australia/Eucla", "Jukla" },
            { "timezone.excity.Australia/Perth", "P\u0113rta" },
            { "timezone.excity.Europe/Belgrade", "Belgrada" },
            { "timezone.excity.Europe/Brussels", "Brisele" },
            { "timezone.excity.Europe/Budapest", "Budape\u0161ta" },
            { "timezone.excity.Europe/Busingen", "B\u012bzingene" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161i\u0146eva" },
            { "timezone.excity.Europe/Guernsey", "G\u0113rnsija" },
            { "timezone.excity.Europe/Istanbul", "Stambula" },
            { "timezone.excity.Europe/Sarajevo", "Sarajeva" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017ehoroda" },
            { "timezone.excity.Indian/Maldives", "Mald\u012bvija" },
            { "timezone.excity.Pacific/Chatham", "\u010cetema" },
            { "timezone.excity.Pacific/Gambier", "Gambj\u0113 salas" },
            { "timezone.excity.Pacific/Norfolk", "Norfolka" },
            { "timezone.excity.Africa/Bujumbura", "Bu\u017eumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u012b\u0161o" },
            { "timezone.excity.America/Anguilla", "Angilja" },
            { "timezone.excity.America/Asuncion", "Asunsjona" },
            { "timezone.excity.America/Barbados", "Barbadosa" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmontona" },
            { "timezone.excity.America/Mazatlan", "Masatlana" },
            { "timezone.excity.America/Miquelon", "Mikelona" },
            { "timezone.excity.America/New_York", "\u0145ujorka" },
            { "timezone.excity.America/Resolute", "Rezol\u016bta" },
            { "timezone.excity.America/Santarem", "Santarena" },
            { "timezone.excity.America/Santiago", "Santjago" },
            { "timezone.excity.America/St_Johns", "Sentd\u017eonsa" },
            { "timezone.excity.America/St_Kitts", "Sentkitsa" },
            { "timezone.excity.America/St_Lucia", "Sentl\u016bsija" },
            { "timezone.excity.America/Winnipeg", "Vinipega" },
            { "timezone.excity.Antarctica/Casey", "Keisi" },
            { "timezone.excity.Antarctica/Davis", "Deivisa" },
            { "timezone.excity.Antarctica/Syowa", "\u0160ova" },
            { "timezone.excity.Antarctica/Troll", "Trolla" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarska" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirska" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbatora" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostoka" },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "timezone.excity.Australia/Currie", "Kari" },
            { "timezone.excity.Australia/Darwin", "D\u0101rvina" },
            { "timezone.excity.Australia/Hobart", "Hob\u0101rta" },
            { "timezone.excity.Australia/Sydney", "Sidneja" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdama" },
            { "timezone.excity.Europe/Astrakhan", "Astraha\u0146a" },
            { "timezone.excity.Europe/Bucharest", "Bukareste" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u0101rs" },
            { "timezone.excity.Europe/Ljubljana", "\u013bub\u013cana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamna" },
            { "timezone.excity.Europe/Stockholm", "Stokholma" },
            { "timezone.excity.Europe/Ulyanovsk", "U\u013cjanovska" },
            { "timezone.excity.Europe/Volgograd", "Volgograda" },
            { "timezone.excity.Indian/Christmas", "Ziemsv\u0113tku sala" },
            { "timezone.excity.Indian/Kerguelen", "Kergel\u0113na sala" },
            { "timezone.excity.Indian/Mauritius", "Maur\u012bcija" },
            { "timezone.excity.Pacific/Auckland", "Oklenda" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "D\u017eonstona atols" },
            { "timezone.excity.Pacific/Pitcairn", "Pitk\u0113rna" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.Africa/Libreville", "Librevila" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumba\u0161i" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ota" },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.America/Anchorage", "Ankur\u0101\u017ea" },
            { "timezone.excity.America/Araguaina", "Aragvaina" },
            { "timezone.excity.America/Boa_Vista", "Boavista" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Chihuahua", "\u010civava" },
            { "timezone.excity.America/Glace_Bay", "Gleisbeja" },
            { "timezone.excity.America/Goose_Bay", "G\u016bsbeja" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/Guayaquil", "Gvajakila" },
            { "timezone.excity.America/Matamoros", "Matamorosa" },
            { "timezone.excity.America/Menominee", "Menomin\u012b" },
            { "timezone.excity.America/Monterrey", "Monterreja" },
            { "timezone.excity.America/Sao_Paulo", "Sanpaulu" },
            { "timezone.excity.America/St_Thomas", "Sentomasa" },
            { "timezone.excity.America/Vancouver", "Vank\u016bvera" },
            { "timezone.excity.Antarctica/Mawson", "Mosona" },
            { "timezone.excity.Antarctica/Palmer", "P\u0101lmera" },
            { "timezone.excity.Antarctica/Vostok", "Vostoka" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kualalumpura" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuz\u0146ecka" },
            { "timezone.excity.Europe/Copenhagen", "Kopenh\u0101gena" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburga" },
            { "timezone.excity.Europe/San_Marino", "Sanmar\u012bno" },
            { "timezone.excity.Europe/Simferopol", "Simferopole" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporo\u017eje" },
            { "timezone.excity.Pacific/Enderbury", "Enderberija" },
            { "timezone.excity.Pacific/Galapagos", "Galapagu salas" },
            { "timezone.excity.Pacific/Kwajalein", "Kvad\u017ealeina" },
            { "timezone.excity.Pacific/Marquesas", "Mar\u0137\u012bza salas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pagopago" },
            { "timezone.excity.Africa/Addis_Ababa", "Adisabeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazavila" },
            { "timezone.excity.Africa/Ouagadougou", "Vagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Grand_Turk", "Grandtk\u0113rka" },
            { "timezone.excity.America/Guadeloupe", "Gvadelupa" },
            { "timezone.excity.America/Hermosillo", "Ermosiljo" },
            { "timezone.excity.America/Kralendijk", "Kr\u0101lendeika" },
            { "timezone.excity.America/Louisville", "L\u016bivila" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "timezone.excity.America/Montserrat", "Montserrata" },
            { "timezone.excity.America/Rio_Branco", "Riobranko" },
            { "timezone.excity.America/St_Vincent", "Sentvinsenta" },
            { "timezone.excity.America/Whitehorse", "Vaithorsa" },
            { "timezone.excity.Antarctica/McMurdo", "Makmerdo" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Sred\u0146ekolimska" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburga" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikjavika" },
            { "timezone.excity.Atlantic/St_Helena", "Sv.Hel\u0113nas sala" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Australia/Brisbane", "Brisbena" },
            { "timezone.excity.Australia/Lindeman", "Lindemana" },
            { "timezone.excity.Europe/Isle_of_Man", "Menas sala" },
            { "timezone.excity.Europe/Kaliningrad", "Ka\u013ci\u0146ingrada" },
            { "timezone.excity.Pacific/Kiritimati", "Kirisimasi" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburga" },
            { "timezone.excity.America/El_Salvador", "Salvadora" },
            { "timezone.excity.America/Fort_Nelson", "Fortnelsona" },
            { "timezone.excity.America/Los_Angeles", "Losand\u017eelosa" },
            { "timezone.excity.America/Mexico_City", "Mehiko" },
            { "timezone.excity.America/Pangnirtung", "Pannirtuna" },
            { "timezone.excity.America/Porto_Velho", "Portuve\u013cu" },
            { "timezone.excity.America/Puerto_Rico", "Puertoriko" },
            { "timezone.excity.America/Rainy_River", "Reinirivera" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Tanderbeja" },
            { "timezone.excity.America/Yellowknife", "Jelounaifa" },
            { "timezone.excity.Arctic/Longyearbyen", "Longj\u0113rb\u012bene" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaboverde" },
            { "timezone.excity.Australia/Lord_Howe", "Lordhava" },
            { "timezone.excity.Australia/Melbourne", "Melburna" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivu" },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanala" },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u0101resal\u0101ma" },
            { "timezone.excity.America/Blanc-Sablon", "Blansablona" },
            { "timezone.excity.America/Buenos_Aires", "Buenosairesa" },
            { "timezone.excity.America/Campo_Grande", "Kampugrandi" },
            { "timezone.excity.America/Danmarkshavn", "Denm\u0101rk\u0161avna" },
            { "timezone.excity.America/Dawson_Creek", "Dousonkr\u012bka" },
            { "timezone.excity.America/Indiana/Knox", "Noksa, Indi\u0101na" },
            { "timezone.excity.America/Indianapolis", "Indianapolisa" },
            { "timezone.excity.America/Punta_Arenas", "Puntaarenasa" },
            { "timezone.excity.America/Rankin_Inlet", "Rankininleta" },
            { "timezone.excity.America/Santa_Isabel", "Santaisabela" },
            { "timezone.excity.America/Scoresbysund", "Itokortormita" },
            { "timezone.excity.Antarctica/Macquarie", "Makvori" },
            { "timezone.excity.Pacific/Bougainville", "Bugenvila sala" },
            { "timezone.excity.Pacific/Port_Moresby", "Portmorsbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kembrid\u017ebeja" },
            { "timezone.excity.America/Ciudad_Juarez", "Huaresa" },
            { "timezone.excity.America/Coral_Harbour", "Atikokana" },
            { "timezone.excity.America/Indiana/Vevay", "V\u012bveja, Indi\u0101na" },
            { "timezone.excity.America/Lower_Princes", "Louerprinseskvotera" },
            { "timezone.excity.America/Port_of_Spain", "Portofspeina" },
            { "timezone.excity.America/Santo_Domingo", "Santodomingo" },
            { "timezone.excity.America/St_Barthelemy", "Senbartelm\u012b" },
            { "timezone.excity.America/Swift_Current", "Sviftkarenta" },
            { "timezone.excity.Australia/Broken_Hill", "Brokenhila" },
            { "timezone.excity.America/Bahia_Banderas", "Bajabanderasa" },
            { "timezone.excity.America/Port-au-Prince", "Portoprensa" },
            { "timezone.excity.Atlantic/South_Georgia", "Dienvidd\u017eord\u017eija" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indi\u0101na" },
            { "timezone.excity.America/Indiana/Winamac", "Vinamaka, Indi\u0101na" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukumana" },
            { "timezone.excity.America/Argentina/Ushuaia", "U\u0161uaja" },
            { "timezone.excity.America/Indiana/Tell_City", "Telsitija, Indi\u0101na" },
            { "timezone.excity.America/Indiana/Vincennes", "Vinsensa, Indi\u0101na" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dimondirvila" },
            { "timezone.excity.America/Argentina/La_Rioja", "Larjoha" },
            { "timezone.excity.America/Argentina/San_Juan", "Sanhuana" },
            { "timezone.excity.America/Argentina/San_Luis", "Sanluisa" },
            { "timezone.excity.America/Indiana/Petersburg", "P\u012btersb\u0113rga, Indi\u0101na" },
            { "timezone.excity.America/Kentucky/Monticello", "Monti\u010delo, Kentuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Bjula, Zieme\u013cdakota" },
            { "timezone.excity.America/North_Dakota/Center", "Sentera, Zieme\u013cdakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Riogaljegosa" },
            { "timezone.excity.America/North_Dakota/New_Salem", "\u0145\u016bseilema, Zieme\u013cdakota" },
        };
        return data;
    }
}
